/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.org.objectweb.asmx.optimizer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class JarOptimizer {
    public static void main(String[] args) throws IOException {
        File f = new File(args[0]);
        JarOptimizer.optimize(f);
    }

    static void optimize(File f) throws IOException {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                JarOptimizer.optimize(files[i]);
            }
        } else if (f.getName().endsWith(".jar")) {
            File g2 = new File(f.getParentFile(), f.getName() + ".new");
            ZipFile zf = new ZipFile(f);
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(g2));
            Enumeration<? extends ZipEntry> e = zf.entries();
            byte[] buf = new byte[10000];
            while (e.hasMoreElements()) {
                int n;
                ZipEntry ze = e.nextElement();
                if (ze.isDirectory()) continue;
                out.putNextEntry(ze);
                InputStream is = zf.getInputStream(ze);
                do {
                    if ((n = is.read(buf, 0, buf.length)) == -1) continue;
                    out.write(buf, 0, n);
                } while (n != -1);
                out.closeEntry();
            }
            out.close();
            zf.close();
            f.delete();
            g2.renameTo(f);
        }
    }
}

