/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.javacutil.trees;

import com.sun.source.tree.ExpressionTree;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Names;
import java.util.StringTokenizer;
import javax.annotation.processing.ProcessingEnvironment;

public class TreeParser {
    private static final String DELIMS = ".[](),";
    private static final String SENTINAL = "";
    private final TreeMaker maker;
    private final Names names;
    StringTokenizer tokenizer = null;
    String token = null;

    public TreeParser(ProcessingEnvironment env) {
        Context context = ((JavacProcessingEnvironment)env).getContext();
        this.maker = TreeMaker.instance(context);
        this.names = Names.instance(context);
    }

    public ExpressionTree parseTree(String s2) {
        this.tokenizer = new StringTokenizer(s2, DELIMS, true);
        this.token = this.tokenizer.nextToken();
        try {
            JCTree.JCExpression jCExpression = this.parseExpression();
            return jCExpression;
        }
        catch (Exception e) {
            throw new ParseError(e);
        }
        finally {
            this.tokenizer = null;
            this.token = null;
        }
    }

    private String nextToken() {
        this.token = this.tokenizer.hasMoreTokens() ? this.tokenizer.nextToken() : SENTINAL;
        return this.token;
    }

    JCTree.JCExpression fromToken(String token) {
        if ("true".equals(token)) {
            return this.maker.Literal(true);
        }
        if ("false".equals(token)) {
            return this.maker.Literal(false);
        }
        if (Character.isLetter(token.charAt(0))) {
            return this.maker.Ident(this.names.fromString(token));
        }
        Number value = null;
        try {
            value = Integer.valueOf(token);
        }
        catch (Exception e2) {
            try {
                value = Double.valueOf(token);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        assert (value != null);
        return this.maker.Literal(value);
    }

    JCTree.JCExpression parseExpression() {
        JCTree.JCExpression tree = this.fromToken(this.token);
        while (this.tokenizer.hasMoreTokens()) {
            String delim = this.nextToken();
            if (".".equals(delim)) {
                this.nextToken();
                tree = this.maker.Select(tree, this.names.fromString(this.token));
                continue;
            }
            if ("(".equals(delim)) {
                this.nextToken();
                ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
                while (!")".equals(this.token)) {
                    JCTree.JCExpression arg = this.parseExpression();
                    args.append(arg);
                    if (!",".equals(this.token)) continue;
                    this.nextToken();
                }
                assert (")".equals(this.token));
                tree = this.maker.Apply(List.nil(), tree, args.toList());
                continue;
            }
            if ("[".equals(this.token)) {
                this.nextToken();
                JCTree.JCExpression index = this.parseExpression();
                assert ("]".equals(this.token));
                tree = this.maker.Indexed(tree, index);
                continue;
            }
            return tree;
        }
        return tree;
    }

    private static class ParseError
    extends RuntimeException {
        private static final long serialVersionUID = 1887754619522101929L;

        ParseError(Throwable cause) {
            super(cause);
        }
    }
}

