/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.typeinference;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeVariable;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.GenericAnnotatedTypeFactory;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.TypeVariableSubstitutor;
import org.checkerframework.framework.type.visitor.AnnotatedTypeScanner;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.framework.util.AnnotationMirrorMap;
import org.checkerframework.framework.util.AnnotationMirrorSet;
import org.checkerframework.javacutil.BugInCF;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypeAnnotationUtils;
import org.checkerframework.javacutil.TypesUtils;

public class TypeArgInferenceUtil {
    private static final TypeVariableSubstitutor substitutor = new TypeVariableSubstitutor();
    private static final Map<TypeVariable, AnnotatedTypeMirror> substituteMap = new HashMap<TypeVariable, AnnotatedTypeMirror>(5);

    public static List<AnnotatedTypeMirror> getArgumentTypes(ExpressionTree methodInvocation, AnnotatedTypeFactory typeFactory) {
        List<? extends ExpressionTree> argTrees;
        if (methodInvocation.getKind() == Tree.Kind.METHOD_INVOCATION) {
            argTrees = ((MethodInvocationTree)methodInvocation).getArguments();
        } else if (methodInvocation.getKind() == Tree.Kind.NEW_CLASS) {
            argTrees = ((NewClassTree)methodInvocation).getArguments();
        } else {
            throw new BugInCF("TypeArgumentInference.relationsFromMethodArguments:\ncouldn't determine arguments from tree: " + methodInvocation);
        }
        ArrayList<AnnotatedTypeMirror> argTypes = new ArrayList<AnnotatedTypeMirror>(argTrees.size());
        for (Tree tree : argTrees) {
            AnnotatedTypeMirror argType = typeFactory.getAnnotatedType(tree);
            if (TypesUtils.isPrimitive(argType.getUnderlyingType())) {
                argTypes.add(typeFactory.getBoxedType((AnnotatedTypeMirror.AnnotatedPrimitiveType)argType));
                continue;
            }
            argTypes.add(argType);
        }
        return argTypes;
    }

    public static boolean isATarget(AnnotatedTypeMirror type, Set<TypeVariable> targetTypeVars) {
        return type.getKind() == TypeKind.TYPEVAR && targetTypeVars.contains((TypeVariable)((Object)TypeAnnotationUtils.unannotatedType(type.getUnderlyingType())));
    }

    public static Set<TypeVariable> methodTypeToTargets(AnnotatedTypeMirror.AnnotatedExecutableType methodType) {
        List<AnnotatedTypeMirror.AnnotatedTypeVariable> annotatedTypeVars = methodType.getTypeVariables();
        LinkedHashSet<TypeVariable> targets = new LinkedHashSet<TypeVariable>(annotatedTypeVars.size());
        for (AnnotatedTypeMirror.AnnotatedTypeVariable atv : annotatedTypeVars) {
            targets.add((TypeVariable)((Object)TypeAnnotationUtils.unannotatedType(atv.getUnderlyingType())));
        }
        return targets;
    }

    public static AnnotatedTypeMirror assignedTo(AnnotatedTypeFactory atypeFactory, TreePath path) {
        AnnotatedTypeMirror res;
        Tree assignmentContext = TreeUtils.getAssignmentContext(path);
        if (assignmentContext == null) {
            res = null;
        } else if (assignmentContext instanceof AssignmentTree) {
            ExpressionTree variable = ((AssignmentTree)assignmentContext).getVariable();
            res = atypeFactory.getAnnotatedType(variable);
        } else if (assignmentContext instanceof CompoundAssignmentTree) {
            ExpressionTree variable = ((CompoundAssignmentTree)assignmentContext).getVariable();
            res = atypeFactory.getAnnotatedType(variable);
        } else if (assignmentContext instanceof MethodInvocationTree) {
            MethodInvocationTree methodInvocation = (MethodInvocationTree)assignmentContext;
            if (methodInvocation.getMethodSelect() instanceof MemberSelectTree && ((MemberSelectTree)methodInvocation.getMethodSelect()).getExpression() == path.getLeaf()) {
                return null;
            }
            ExecutableElement methodElt = TreeUtils.elementFromUse(methodInvocation);
            AnnotatedTypeMirror receiver = atypeFactory.getReceiverType(methodInvocation);
            res = TypeArgInferenceUtil.assignedToExecutable(atypeFactory, path, methodElt, receiver, methodInvocation.getArguments());
        } else if (assignmentContext instanceof NewArrayTree) {
            res = null;
        } else if (assignmentContext instanceof NewClassTree) {
            NewClassTree newClassTree = (NewClassTree)assignmentContext;
            ExecutableElement constructorElt = TreeUtils.constructor(newClassTree);
            AnnotatedTypeMirror.AnnotatedDeclaredType receiver = atypeFactory.fromNewClass(newClassTree);
            res = TypeArgInferenceUtil.assignedToExecutable(atypeFactory, path, constructorElt, receiver, newClassTree.getArguments());
        } else if (assignmentContext instanceof ReturnTree) {
            HashSet<Tree.Kind> kinds = new HashSet<Tree.Kind>(Arrays.asList(Tree.Kind.LAMBDA_EXPRESSION, Tree.Kind.METHOD));
            Tree enclosing = TreeUtils.enclosingOfKind(path, kinds);
            if (enclosing.getKind() == Tree.Kind.METHOD) {
                res = atypeFactory.getAnnotatedType((MethodTree)enclosing).getReturnType();
            } else {
                Pair<AnnotatedTypeMirror.AnnotatedDeclaredType, AnnotatedTypeMirror.AnnotatedExecutableType> fninf = atypeFactory.getFnInterfaceFromTree((LambdaExpressionTree)enclosing);
                res = ((AnnotatedTypeMirror.AnnotatedExecutableType)fninf.second).getReturnType();
            }
        } else if (assignmentContext instanceof VariableTree) {
            res = TypeArgInferenceUtil.assignedToVariable(atypeFactory, assignmentContext);
        } else {
            throw new BugInCF("AnnotatedTypes.assignedTo: shouldn't be here");
        }
        if (res != null && TypesUtils.isPrimitive(res.getUnderlyingType())) {
            return atypeFactory.getBoxedType((AnnotatedTypeMirror.AnnotatedPrimitiveType)res);
        }
        return res;
    }

    private static AnnotatedTypeMirror assignedToExecutable(AnnotatedTypeFactory atypeFactory, TreePath path, ExecutableElement methodElt, AnnotatedTypeMirror receiver, List<? extends ExpressionTree> arguments) {
        AnnotatedTypeMirror paramType;
        AnnotatedTypeMirror.AnnotatedExecutableType method = AnnotatedTypes.asMemberOf(atypeFactory.getContext().getTypeUtils(), atypeFactory, receiver, methodElt);
        int treeIndex = -1;
        for (int i = 0; i < arguments.size(); ++i) {
            ExpressionTree argumentTree = arguments.get(i);
            if (!TypeArgInferenceUtil.isArgument(path, argumentTree)) continue;
            treeIndex = i;
            break;
        }
        if (treeIndex == -1) {
            paramType = method.getReceiverType();
        } else if (treeIndex + 1 >= method.getParameterTypes().size() && methodElt.isVarArgs()) {
            AnnotatedTypeMirror varArgsType = method.getParameterTypes().get(method.getParameterTypes().size() - 1);
            paramType = ((AnnotatedTypeMirror.AnnotatedArrayType)varArgsType).getComponentType();
        } else {
            paramType = method.getParameterTypes().get(treeIndex);
        }
        if (paramType == null || TypeArgInferenceUtil.containsUninferredTypeParameter(paramType, method)) {
            return null;
        }
        return paramType;
    }

    private static boolean isArgument(TreePath path, ExpressionTree argumentTree) {
        if ((argumentTree = TreeUtils.skipParens(argumentTree)) == path.getLeaf()) {
            return true;
        }
        if (argumentTree.getKind() == Tree.Kind.CONDITIONAL_EXPRESSION) {
            ConditionalExpressionTree conditionalExpressionTree = (ConditionalExpressionTree)argumentTree;
            return TypeArgInferenceUtil.isArgument(path, conditionalExpressionTree.getTrueExpression()) || TypeArgInferenceUtil.isArgument(path, conditionalExpressionTree.getFalseExpression());
        }
        return false;
    }

    public static AnnotatedTypeMirror assignedToVariable(AnnotatedTypeFactory atypeFactory, Tree assignmentContext) {
        if (atypeFactory instanceof GenericAnnotatedTypeFactory) {
            GenericAnnotatedTypeFactory gatf = (GenericAnnotatedTypeFactory)atypeFactory;
            return gatf.getAnnotatedTypeLhsNoTypeVarDefault(assignmentContext);
        }
        return atypeFactory.getAnnotatedType(assignmentContext);
    }

    private static boolean containsUninferredTypeParameter(AnnotatedTypeMirror type, AnnotatedTypeMirror.AnnotatedExecutableType methodType) {
        List<AnnotatedTypeMirror.AnnotatedTypeVariable> annotatedTypeVars = methodType.getTypeVariables();
        ArrayList<TypeVariable> typeVars = new ArrayList<TypeVariable>(annotatedTypeVars.size());
        for (AnnotatedTypeMirror.AnnotatedTypeVariable annotatedTypeVar : annotatedTypeVars) {
            typeVars.add((TypeVariable)((Object)TypeAnnotationUtils.unannotatedType(annotatedTypeVar.getUnderlyingType())));
        }
        return TypeArgInferenceUtil.containsTypeParameter(type, typeVars);
    }

    public static boolean containsTypeParameter(AnnotatedTypeMirror type, Collection<TypeVariable> typeVariables) {
        Boolean result = type.accept(new TypeVariableFinder(), typeVariables);
        return result != null && result != false;
    }

    public static AnnotationMirrorMap<AnnotationMirror> createHierarchyMap(AnnotationMirrorSet annos, QualifierHierarchy qualifierHierarchy) {
        AnnotationMirrorMap<AnnotationMirror> result = new AnnotationMirrorMap<AnnotationMirror>();
        for (AnnotationMirror anno : annos) {
            result.put(qualifierHierarchy.getTopAnnotation(anno), anno);
        }
        return result;
    }

    public static void checkForUninferredTypes(AnnotatedTypeMirror type) {
        if (type.getKind() != TypeKind.WILDCARD) {
            return;
        }
        if (((AnnotatedTypeMirror.AnnotatedWildcardType)type).isUninferredTypeArgument()) {
            throw new BugInCF("Can't make a constraint that includes an uninferred type argument.");
        }
    }

    public static AnnotatedTypeMirror substitute(TypeVariable typeVariable, AnnotatedTypeMirror substitution, AnnotatedTypeMirror toModify) {
        substituteMap.clear();
        substituteMap.put(typeVariable, substitution.deepCopy());
        AnnotatedTypeMirror toModifyCopy = toModify.deepCopy();
        substitutor.substitute(substituteMap, toModifyCopy);
        return toModifyCopy;
    }

    public static AnnotatedTypeMirror substitute(Map<TypeVariable, AnnotatedTypeMirror> substitutions, AnnotatedTypeMirror toModify) {
        AnnotatedTypeMirror substitution = toModify.getKind() == TypeKind.TYPEVAR ? substitutions.get((TypeVariable)((Object)TypeAnnotationUtils.unannotatedType(toModify.getUnderlyingType()))) : null;
        if (substitution != null) {
            return substitution.deepCopy();
        }
        AnnotatedTypeMirror toModifyCopy = toModify.deepCopy();
        substitutor.substitute(substitutions, toModifyCopy);
        return toModifyCopy;
    }

    public static AnnotatedTypeMirror leastUpperBound(AnnotatedTypeFactory typeFactory, Iterable<AnnotatedTypeMirror> types) {
        Iterator<AnnotatedTypeMirror> typesIter = types.iterator();
        if (!typesIter.hasNext()) {
            throw new BugInCF("Calling LUB on empty list");
        }
        AnnotatedTypeMirror lubType = typesIter.next();
        AnnotatedTypeMirror nextType = null;
        while (typesIter.hasNext()) {
            nextType = typesIter.next();
            if (lubType.getKind().isPrimitive()) {
                if (!nextType.getKind().isPrimitive()) {
                    lubType = typeFactory.getBoxedType((AnnotatedTypeMirror.AnnotatedPrimitiveType)lubType);
                }
            } else if (nextType.getKind().isPrimitive() && !lubType.getKind().isPrimitive()) {
                nextType = typeFactory.getBoxedType((AnnotatedTypeMirror.AnnotatedPrimitiveType)nextType);
            }
            lubType = AnnotatedTypes.leastUpperBound(typeFactory, lubType, nextType);
        }
        return lubType;
    }

    private static class TypeVariableFinder
    extends AnnotatedTypeScanner<Boolean, Collection<TypeVariable>> {
        private TypeVariableFinder() {
        }

        @Override
        protected Boolean scan(Iterable<? extends AnnotatedTypeMirror> types, Collection<TypeVariable> typeVars) {
            if (types == null) {
                return false;
            }
            Boolean result = false;
            Boolean first = true;
            for (AnnotatedTypeMirror annotatedTypeMirror : types) {
                result = first != false ? (Boolean)this.scan(annotatedTypeMirror, typeVars) : this.scanAndReduce(annotatedTypeMirror, typeVars, result);
                first = false;
            }
            return result;
        }

        @Override
        protected Boolean reduce(Boolean r1, Boolean r2) {
            if (r1 == null) {
                return r2 != null && r2 != false;
            }
            if (r2 == null) {
                return r1;
            }
            return r1 != false || r2 != false;
        }

        @Override
        public Boolean visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type, Collection<TypeVariable> typeVars) {
            if (typeVars.contains((TypeVariable)((Object)TypeAnnotationUtils.unannotatedType(type.getUnderlyingType())))) {
                return true;
            }
            return (Boolean)super.visitTypeVariable(type, typeVars);
        }
    }
}

