/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.element;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.util.List;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.lang.model.element.Element;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.element.ElementAnnotationUtil;
import org.checkerframework.framework.util.element.TargetedElementAnnotationApplier;
import org.checkerframework.framework.util.element.TypeVarUseApplier;
import org.checkerframework.javacutil.BugInCF;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.PluginUtil;

public class MethodApplier
extends TargetedElementAnnotationApplier {
    private final AnnotatedTypeFactory typeFactory;
    private final Symbol.MethodSymbol methodSymbol;
    private final AnnotatedTypeMirror.AnnotatedExecutableType methodType;

    public static void apply(AnnotatedTypeMirror type, Element element, AnnotatedTypeFactory typeFactory) {
        new MethodApplier(type, element, typeFactory).extractAndApply();
    }

    public static boolean accepts(AnnotatedTypeMirror typeMirror, Element element) {
        return element instanceof Symbol.MethodSymbol && typeMirror instanceof AnnotatedTypeMirror.AnnotatedExecutableType;
    }

    MethodApplier(AnnotatedTypeMirror type, Element element, AnnotatedTypeFactory typeFactory) {
        super(type, element);
        this.typeFactory = typeFactory;
        this.methodSymbol = (Symbol.MethodSymbol)element;
        this.methodType = (AnnotatedTypeMirror.AnnotatedExecutableType)type;
    }

    @Override
    protected TargetType[] annotatedTargets() {
        return new TargetType[]{TargetType.METHOD_RECEIVER, TargetType.METHOD_RETURN, TargetType.THROWS};
    }

    @Override
    protected TargetType[] validTargets() {
        return new TargetType[]{TargetType.LOCAL_VARIABLE, TargetType.RESOURCE_VARIABLE, TargetType.EXCEPTION_PARAMETER, TargetType.NEW, TargetType.CAST, TargetType.INSTANCEOF, TargetType.METHOD_INVOCATION_TYPE_ARGUMENT, TargetType.CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT, TargetType.METHOD_REFERENCE, TargetType.CONSTRUCTOR_REFERENCE, TargetType.METHOD_REFERENCE_TYPE_ARGUMENT, TargetType.CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT, TargetType.METHOD_TYPE_PARAMETER, TargetType.METHOD_TYPE_PARAMETER_BOUND, TargetType.METHOD_FORMAL_PARAMETER};
    }

    @Override
    protected Iterable<Attribute.TypeCompound> getRawTypeAttributes() {
        return this.methodSymbol.getRawTypeAttributes();
    }

    @Override
    protected boolean isAccepted() {
        return MethodApplier.accepts(this.type, this.element);
    }

    @Override
    public void extractAndApply() {
        this.methodType.setElement(this.methodSymbol);
        if (this.methodType.getReturnType() instanceof AnnotatedTypeMirror.AnnotatedTypeVariable) {
            this.applyTypeVarUseOnReturnType();
        }
        ElementAnnotationUtil.addAnnotationsFromElement(this.methodType.getReturnType(), this.methodSymbol.getAnnotationMirrors());
        java.util.List<AnnotatedTypeMirror> params = this.methodType.getParameterTypes();
        for (int i = 0; i < params.size(); ++i) {
            ElementAnnotationUtil.addAnnotationsFromElement(params.get(i), ((Symbol.VarSymbol)((List)this.methodSymbol.getParameters()).get(i)).getAnnotationMirrors());
        }
        super.extractAndApply();
        ElementAnnotationUtil.applyAllElementAnnotations(this.methodType.getParameterTypes(), this.methodSymbol.getParameters(), this.typeFactory);
        ElementAnnotationUtil.applyAllElementAnnotations(this.methodType.getTypeVariables(), this.methodSymbol.getTypeParameters(), this.typeFactory);
    }

    @Override
    protected void handleTargeted(java.util.List<Attribute.TypeCompound> targeted) {
        ArrayList<Attribute.TypeCompound> unmatched = new ArrayList<Attribute.TypeCompound>();
        Map<TargetType, java.util.List<Attribute.TypeCompound>> targetTypeToAnno = ElementAnnotationUtil.partitionByTargetType(targeted, unmatched, TargetType.METHOD_RECEIVER, TargetType.METHOD_RETURN, TargetType.THROWS);
        ElementAnnotationUtil.annotateViaTypeAnnoPosition(this.methodType.getReceiverType(), (Collection<Attribute.TypeCompound>)targetTypeToAnno.get((Object)TargetType.METHOD_RECEIVER));
        ElementAnnotationUtil.annotateViaTypeAnnoPosition(this.methodType.getReturnType(), (Collection<Attribute.TypeCompound>)targetTypeToAnno.get((Object)TargetType.METHOD_RETURN));
        this.applyThrowsAnnotations(targetTypeToAnno.get((Object)TargetType.THROWS));
        if (!unmatched.isEmpty()) {
            throw new BugInCF("Unexpected annotations ( " + PluginUtil.join(",", unmatched) + " ) fortype ( " + this.type + " ) and element ( " + this.element + " ) ");
        }
    }

    private void applyThrowsAnnotations(java.util.List<Attribute.TypeCompound> annos) {
        java.util.List<AnnotatedTypeMirror> thrown = this.methodType.getThrownTypes();
        if (thrown.isEmpty()) {
            return;
        }
        LinkedHashMap typeToAnnos = new LinkedHashMap();
        for (AnnotatedTypeMirror annotatedTypeMirror : thrown) {
            typeToAnnos.put(annotatedTypeMirror, new ArrayList());
        }
        for (Attribute.TypeCompound typeCompound : annos) {
            TypeAnnotationPosition annoPos = typeCompound.position;
            if (annoPos.type_index >= 0 && annoPos.type_index < thrown.size()) {
                AnnotatedTypeMirror thrownType = thrown.get(annoPos.type_index);
                ((java.util.List)typeToAnnos.get(thrownType)).add(typeCompound);
                continue;
            }
            throw new BugInCF("MethodApplier.applyThrowsAnnotation: invalid throws index " + annoPos.type_index + " for annotation: " + typeCompound + " for element: " + ElementUtils.getVerboseName(this.element));
        }
        for (Map.Entry entry : typeToAnnos.entrySet()) {
            ElementAnnotationUtil.annotateViaTypeAnnoPosition((AnnotatedTypeMirror)entry.getKey(), (Collection)entry.getValue());
        }
    }

    private void applyTypeVarUseOnReturnType() {
        new TypeVarUseApplier(this.methodType.getReturnType(), this.methodSymbol, this.typeFactory).extractAndApply();
    }
}

