/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type;

import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.visitor.AnnotatedTypeScanner;

public class HashcodeAtmVisitor
extends AnnotatedTypeScanner<Integer, Void> {
    @Override
    protected Integer scan(AnnotatedTypeMirror type, Void v) {
        return this.reduce((Integer)super.scan(type, null), this.generateHashcode(type));
    }

    @Override
    protected Integer reduce(Integer hashcode1, Integer hashcode2) {
        if (hashcode1 == null) {
            return hashcode2;
        }
        if (hashcode2 == null) {
            return hashcode1;
        }
        return hashcode1 + hashcode2;
    }

    private Integer generateHashcode(AnnotatedTypeMirror type) {
        if (type == null) {
            return null;
        }
        return type.getAnnotations().toString().hashCode() * 17 + type.getUnderlyingType().toString().hashCode() * 13;
    }
}

