/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.framework.qual.Covariant;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.StructuralEqualityComparer;
import org.checkerframework.framework.type.SubtypeVisitHistory;
import org.checkerframework.framework.type.TypeHierarchy;
import org.checkerframework.framework.type.visitor.AbstractAtmComboVisitor;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.framework.util.AtmCombo;
import org.checkerframework.framework.util.TypeArgumentMapper;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TypesUtils;

public class DefaultTypeHierarchy
extends AbstractAtmComboVisitor<Boolean, Void>
implements TypeHierarchy {
    protected final BaseTypeChecker checker;
    protected final QualifierHierarchy qualifierHierarchy;
    protected final StructuralEqualityComparer equalityComparer;
    protected final boolean ignoreRawTypes;
    protected final boolean invariantArrayComponents;
    protected AnnotationMirror currentTop;
    protected final SubtypeVisitHistory visitHistory;
    protected final SubtypeVisitHistory typeargVisitHistory;

    public DefaultTypeHierarchy(BaseTypeChecker checker, QualifierHierarchy qualifierHierarchy, boolean ignoreRawTypes, boolean invariantArrayComponents) {
        this.checker = checker;
        this.qualifierHierarchy = qualifierHierarchy;
        this.visitHistory = new SubtypeVisitHistory();
        this.typeargVisitHistory = new SubtypeVisitHistory();
        this.equalityComparer = this.createEqualityComparer();
        this.ignoreRawTypes = ignoreRawTypes;
        this.invariantArrayComponents = invariantArrayComponents;
    }

    public StructuralEqualityComparer createEqualityComparer() {
        return new StructuralEqualityComparer(this.typeargVisitHistory);
    }

    @Override
    public boolean isSubtype(AnnotatedTypeMirror subtype, AnnotatedTypeMirror supertype) {
        for (AnnotationMirror annotationMirror : this.qualifierHierarchy.getTopAnnotations()) {
            if (this.isSubtype(subtype, supertype, annotationMirror)) continue;
            return false;
        }
        return true;
    }

    protected boolean isSubtype(AnnotatedTypeMirror subtype, AnnotatedTypeMirror supertype, AnnotationMirror top) {
        assert (top != null);
        this.currentTop = top;
        return AtmCombo.accept(subtype, supertype, null, this);
    }

    @Override
    protected String defaultErrorMessage(AnnotatedTypeMirror subtype, AnnotatedTypeMirror supertype, Void p) {
        return "Incomparable types (" + subtype + ", " + supertype + ") visitHistory = " + this.visitHistory;
    }

    protected boolean isPrimarySubtype(AnnotatedTypeMirror subtype, AnnotatedTypeMirror supertype) {
        return this.isPrimarySubtype(subtype, supertype, false);
    }

    protected boolean isPrimarySubtype(AnnotatedTypeMirror subtype, AnnotatedTypeMirror supertype, boolean annosCanBeEmtpy) {
        AnnotationMirror subtypeAnno = subtype.getAnnotationInHierarchy(this.currentTop);
        AnnotationMirror supertypeAnno = supertype.getAnnotationInHierarchy(this.currentTop);
        return this.isAnnoSubtype(subtypeAnno, supertypeAnno, annosCanBeEmtpy);
    }

    protected boolean isAnnoSubtype(AnnotationMirror subtypeAnno, AnnotationMirror supertypeAnno, boolean annosCanBeEmtpy) {
        if (annosCanBeEmtpy && subtypeAnno == null && supertypeAnno == null) {
            return true;
        }
        return this.qualifierHierarchy.isSubtype(subtypeAnno, supertypeAnno);
    }

    protected boolean isBottom(AnnotatedTypeMirror subtype) {
        AnnotationMirror bottom = this.qualifierHierarchy.getBottomAnnotation(this.currentTop);
        if (bottom == null) {
            return false;
        }
        switch (subtype.getKind()) {
            case TYPEVAR: {
                return this.isBottom(((AnnotatedTypeMirror.AnnotatedTypeVariable)subtype).getUpperBound());
            }
            case WILDCARD: {
                AnnotatedTypeMirror.AnnotatedWildcardType subtypeWc = (AnnotatedTypeMirror.AnnotatedWildcardType)subtype;
                return this.isBottom(subtypeWc);
            }
        }
        AnnotationMirror subtypeAnno = subtype.getAnnotationInHierarchy(this.currentTop);
        return this.isAnnoSubtype(subtypeAnno, bottom, false);
    }

    protected boolean checkAndSubtype(AnnotatedTypeMirror subtype, AnnotatedTypeMirror supertype) {
        if (this.visitHistory.contains(subtype, supertype, this.currentTop)) {
            return true;
        }
        Boolean result = this.isSubtype(subtype, supertype, this.currentTop);
        this.visitHistory.add(subtype, supertype, this.currentTop, result);
        return result;
    }

    protected boolean isSubtypeOfAll(AnnotatedTypeMirror subtype, Iterable<? extends AnnotatedTypeMirror> supertypes) {
        for (AnnotatedTypeMirror annotatedTypeMirror : supertypes) {
            if (this.isSubtype(subtype, annotatedTypeMirror, this.currentTop)) continue;
            return false;
        }
        return true;
    }

    protected boolean areAllSubtypes(Iterable<? extends AnnotatedTypeMirror> subtypes, AnnotatedTypeMirror supertype) {
        for (AnnotatedTypeMirror annotatedTypeMirror : subtypes) {
            if (this.isSubtype(annotatedTypeMirror, supertype, this.currentTop)) continue;
            return false;
        }
        return true;
    }

    protected boolean areEqualInHierarchy(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2) {
        return this.equalityComparer.areEqualInHierarchy(type1, type2, this.currentTop);
    }

    protected boolean isContainedBy(AnnotatedTypeMirror inside, AnnotatedTypeMirror outside, boolean canBeCovariant) {
        if (this.ignoreUninferredTypeArgument(inside) || this.ignoreUninferredTypeArgument(outside)) {
            return true;
        }
        if (outside.getKind() == TypeKind.WILDCARD) {
            if (this.typeargVisitHistory.contains(inside, outside, this.currentTop)) {
                return true;
            }
            this.typeargVisitHistory.add(inside, outside, this.currentTop, true);
            AnnotatedTypeMirror.AnnotatedWildcardType outsideWc = (AnnotatedTypeMirror.AnnotatedWildcardType)outside;
            AnnotatedTypeMirror outsideWcUB = outsideWc.getExtendsBound();
            if (inside.getKind() == TypeKind.WILDCARD) {
                outsideWcUB = this.checker.getTypeFactory().widenToUpperBound(outsideWcUB, (AnnotatedTypeMirror.AnnotatedWildcardType)inside);
            }
            while (outsideWcUB.getKind() == TypeKind.WILDCARD) {
                if (this.ignoreUninferredTypeArgument(outsideWcUB)) {
                    return true;
                }
                outsideWcUB = ((AnnotatedTypeMirror.AnnotatedWildcardType)outsideWcUB).getExtendsBound();
            }
            AnnotatedTypeMirror castedInside = DefaultTypeHierarchy.castedAsSuper(inside, outsideWcUB);
            if (!this.checkAndSubtype(castedInside, outsideWcUB)) {
                return false;
            }
            AnnotatedTypeMirror lowerbound = outsideWc.getSuperBound();
            if (lowerbound.getKind() == TypeKind.TYPEVAR) {
                return true;
            }
            return canBeCovariant || this.checkAndSubtype(lowerbound, inside);
        }
        if (TypesUtils.isCaptured(outside.getUnderlyingType())) {
            if (this.typeargVisitHistory.contains(inside, outside, this.currentTop)) {
                return true;
            }
            this.typeargVisitHistory.add(inside, outside, this.currentTop, true);
            AnnotatedTypeMirror.AnnotatedTypeVariable outsideCW = (AnnotatedTypeMirror.AnnotatedTypeVariable)outside;
            AnnotatedTypeMirror outsideWcUB = outsideCW.getUpperBound();
            if (inside.getKind() == TypeKind.WILDCARD) {
                outsideWcUB = this.checker.getTypeFactory().widenToUpperBound(outsideWcUB, (AnnotatedTypeMirror.AnnotatedWildcardType)inside);
            }
            while (outsideWcUB.getKind() == TypeKind.WILDCARD) {
                if (this.ignoreUninferredTypeArgument(outsideWcUB)) {
                    return true;
                }
                outsideWcUB = ((AnnotatedTypeMirror.AnnotatedWildcardType)outsideWcUB).getExtendsBound();
            }
            AnnotatedTypeMirror castedInside = DefaultTypeHierarchy.castedAsSuper(inside, outsideWcUB);
            if (!this.checkAndSubtype(castedInside, outsideWcUB)) {
                return false;
            }
            return canBeCovariant || this.checkAndSubtype(outsideCW.getLowerBound(), inside);
        }
        if (canBeCovariant) {
            return this.isSubtype(inside, outside, this.currentTop);
        }
        return this.areEqualInHierarchy(inside, outside);
    }

    private boolean ignoreUninferredTypeArgument(AnnotatedTypeMirror type) {
        AnnotatedTypeMirror.AnnotatedWildcardType insideWc;
        return type.atypeFactory.ignoreUninferredTypeArguments && type.getKind() == TypeKind.WILDCARD && (insideWc = (AnnotatedTypeMirror.AnnotatedWildcardType)type).isUninferredTypeArgument();
    }

    @Override
    public Boolean visitArray_Array(AnnotatedTypeMirror.AnnotatedArrayType subtype, AnnotatedTypeMirror.AnnotatedArrayType supertype, Void p) {
        return this.isPrimarySubtype(subtype, supertype) && (this.invariantArrayComponents ? this.areEqualInHierarchy(subtype.getComponentType(), supertype.getComponentType()) : this.isSubtype(subtype.getComponentType(), supertype.getComponentType(), this.currentTop));
    }

    @Override
    public Boolean visitArray_Declared(AnnotatedTypeMirror.AnnotatedArrayType subtype, AnnotatedTypeMirror.AnnotatedDeclaredType supertype, Void p) {
        return this.isPrimarySubtype(subtype, supertype);
    }

    @Override
    public Boolean visitArray_Null(AnnotatedTypeMirror.AnnotatedArrayType subtype, AnnotatedTypeMirror.AnnotatedNullType supertype, Void p) {
        return this.isPrimarySubtype(subtype, supertype);
    }

    @Override
    public Boolean visitArray_Intersection(AnnotatedTypeMirror.AnnotatedArrayType subtype, AnnotatedTypeMirror.AnnotatedIntersectionType supertype, Void p) {
        return this.isSubtype(DefaultTypeHierarchy.castedAsSuper(subtype, supertype), supertype, this.currentTop);
    }

    @Override
    public Boolean visitArray_Wildcard(AnnotatedTypeMirror.AnnotatedArrayType subtype, AnnotatedTypeMirror.AnnotatedWildcardType supertype, Void p) {
        return this.visitWildcardSupertype(subtype, supertype);
    }

    @Override
    public Boolean visitDeclared_Array(AnnotatedTypeMirror.AnnotatedDeclaredType subtype, AnnotatedTypeMirror.AnnotatedArrayType supertype, Void p) {
        return this.isPrimarySubtype(subtype, supertype);
    }

    @Override
    public Boolean visitDeclared_Declared(AnnotatedTypeMirror.AnnotatedDeclaredType subtype, AnnotatedTypeMirror.AnnotatedDeclaredType supertype, Void p) {
        AnnotatedTypeMirror.AnnotatedDeclaredType subtypeAsSuper = DefaultTypeHierarchy.castedAsSuper(subtype, supertype);
        if (!this.isPrimarySubtype(subtypeAsSuper, supertype)) {
            return false;
        }
        if (this.visitHistory.contains(subtypeAsSuper, supertype, this.currentTop)) {
            return true;
        }
        Boolean result = this.visitTypeArgs(subtypeAsSuper, supertype, subtype.wasRaw(), supertype.wasRaw());
        this.visitHistory.add(subtypeAsSuper, supertype, this.currentTop, result);
        return result;
    }

    public Boolean visitTypeArgs(AnnotatedTypeMirror.AnnotatedDeclaredType subtype, AnnotatedTypeMirror.AnnotatedDeclaredType supertype, boolean subtypeRaw, boolean supertypeRaw) {
        boolean ignoreTypeArgs;
        boolean bl = ignoreTypeArgs = this.ignoreRawTypes && (subtypeRaw || supertypeRaw);
        if (ignoreTypeArgs) {
            return true;
        }
        List<AnnotatedTypeMirror> subtypeTypeArgs = subtype.getTypeArguments();
        List<AnnotatedTypeMirror> supertypeTypeArgs = supertype.getTypeArguments();
        if (subtypeTypeArgs.size() != supertypeTypeArgs.size()) {
            return false;
        }
        if (subtypeTypeArgs.isEmpty()) {
            return true;
        }
        TypeElement supertypeElem = (TypeElement)supertype.getUnderlyingType().asElement();
        List<Integer> covariantArgIndexes = null;
        AnnotationMirror covam = supertype.atypeFactory.getDeclAnnotation(supertypeElem, Covariant.class);
        if (covam != null) {
            covariantArgIndexes = AnnotationUtils.getElementValueArray(covam, "value", Integer.class, false);
        }
        for (int i = 0; i < supertypeTypeArgs.size(); ++i) {
            boolean covariant;
            AnnotatedTypeMirror superTypeArg = supertypeTypeArgs.get(i);
            AnnotatedTypeMirror subTypeArg = subtypeTypeArgs.get(i);
            Boolean result = this.isContainedBy(subTypeArg, superTypeArg, covariant = covariantArgIndexes != null && covariantArgIndexes.contains(i));
            if (result.booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitDeclared_Intersection(AnnotatedTypeMirror.AnnotatedDeclaredType subtype, AnnotatedTypeMirror.AnnotatedIntersectionType supertype, Void p) {
        return this.visitIntersectionSupertype(subtype, supertype);
    }

    @Override
    public Boolean visitDeclared_Null(AnnotatedTypeMirror.AnnotatedDeclaredType subtype, AnnotatedTypeMirror.AnnotatedNullType supertype, Void p) {
        return this.isPrimarySubtype(subtype, supertype);
    }

    @Override
    public Boolean visitDeclared_Primitive(AnnotatedTypeMirror.AnnotatedDeclaredType subtype, AnnotatedTypeMirror.AnnotatedPrimitiveType supertype, Void p) {
        AnnotatedTypeMirror.AnnotatedPrimitiveType subAsSuper = DefaultTypeHierarchy.castedAsSuper(subtype, supertype);
        if (subAsSuper == null) {
            return this.isPrimarySubtype(subtype, supertype);
        }
        return this.isPrimarySubtype(subAsSuper, supertype);
    }

    @Override
    public Boolean visitDeclared_Typevar(AnnotatedTypeMirror.AnnotatedDeclaredType subtype, AnnotatedTypeMirror.AnnotatedTypeVariable supertype, Void p) {
        return this.visitTypevarSupertype(subtype, supertype);
    }

    @Override
    public Boolean visitDeclared_Union(AnnotatedTypeMirror.AnnotatedDeclaredType subtype, AnnotatedTypeMirror.AnnotatedUnionType supertype, Void p) {
        Types types = this.checker.getTypeUtils();
        for (AnnotatedTypeMirror.AnnotatedDeclaredType supertypeAltern : supertype.getAlternatives()) {
            if (!TypesUtils.isErasedSubtype(subtype.getUnderlyingType(), supertypeAltern.getUnderlyingType(), types) || !this.isSubtype(subtype, supertypeAltern, this.currentTop)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visitDeclared_Wildcard(AnnotatedTypeMirror.AnnotatedDeclaredType subtype, AnnotatedTypeMirror.AnnotatedWildcardType supertype, Void p) {
        return this.visitWildcardSupertype(subtype, supertype);
    }

    @Override
    public Boolean visitIntersection_Declared(AnnotatedTypeMirror.AnnotatedIntersectionType subtype, AnnotatedTypeMirror.AnnotatedDeclaredType supertype, Void p) {
        Types types = this.checker.getTypeUtils();
        for (AnnotatedTypeMirror.AnnotatedDeclaredType subtypeI : subtype.directSuperTypes()) {
            if (!TypesUtils.isErasedSubtype(subtypeI.getUnderlyingType(), supertype.getUnderlyingType(), types) || !this.isSubtype(subtypeI, supertype, this.currentTop)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visitIntersection_Primitive(AnnotatedTypeMirror.AnnotatedIntersectionType subtype, AnnotatedTypeMirror.AnnotatedPrimitiveType supertype, Void p) {
        for (AnnotatedTypeMirror.AnnotatedDeclaredType subtypeI : subtype.directSuperTypes()) {
            if (!TypesUtils.isBoxedPrimitive(subtypeI.getUnderlyingType()) || !this.isSubtype(subtypeI, supertype, this.currentTop)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visitIntersection_Intersection(AnnotatedTypeMirror.AnnotatedIntersectionType subtype, AnnotatedTypeMirror.AnnotatedIntersectionType supertype, Void p) {
        Types types = this.checker.getTypeUtils();
        for (AnnotatedTypeMirror.AnnotatedDeclaredType subtypeI : subtype.directSuperTypes()) {
            for (AnnotatedTypeMirror.AnnotatedDeclaredType supertypeI : supertype.directSuperTypes()) {
                if (!TypesUtils.isErasedSubtype(subtypeI.getUnderlyingType(), supertypeI.getUnderlyingType(), types) || this.isSubtype(subtypeI, supertypeI, this.currentTop)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Boolean visitIntersection_Null(AnnotatedTypeMirror.AnnotatedIntersectionType subtype, AnnotatedTypeMirror.AnnotatedNullType supertype, Void p) {
        for (AnnotatedTypeMirror.AnnotatedDeclaredType subtypeI : subtype.directSuperTypes()) {
            if (!this.isPrimarySubtype(subtypeI, supertype)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visitIntersection_Typevar(AnnotatedTypeMirror.AnnotatedIntersectionType subtype, AnnotatedTypeMirror.AnnotatedTypeVariable supertype, Void p) {
        Types types = this.checker.getTypeUtils();
        for (AnnotatedTypeMirror.AnnotatedDeclaredType subtypeI : subtype.directSuperTypes()) {
            if (!TypesUtils.isErasedSubtype(subtypeI.getUnderlyingType(), supertype.getUnderlyingType(), types) || !this.isSubtype(subtypeI, supertype, this.currentTop)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visitNull_Array(AnnotatedTypeMirror.AnnotatedNullType subtype, AnnotatedTypeMirror.AnnotatedArrayType supertype, Void p) {
        return this.isPrimarySubtype(subtype, supertype);
    }

    @Override
    public Boolean visitNull_Declared(AnnotatedTypeMirror.AnnotatedNullType subtype, AnnotatedTypeMirror.AnnotatedDeclaredType supertype, Void p) {
        return this.isPrimarySubtype(subtype, supertype);
    }

    @Override
    public Boolean visitNull_Typevar(AnnotatedTypeMirror.AnnotatedNullType subtype, AnnotatedTypeMirror.AnnotatedTypeVariable supertype, Void p) {
        return this.visitTypevarSupertype(subtype, supertype);
    }

    @Override
    public Boolean visitNull_Wildcard(AnnotatedTypeMirror.AnnotatedNullType subtype, AnnotatedTypeMirror.AnnotatedWildcardType supertype, Void p) {
        return this.visitWildcardSupertype(subtype, supertype);
    }

    @Override
    public Boolean visitNull_Null(AnnotatedTypeMirror.AnnotatedNullType subtype, AnnotatedTypeMirror.AnnotatedNullType supertype, Void p) {
        return this.isPrimarySubtype(subtype, supertype);
    }

    @Override
    public Boolean visitNull_Union(AnnotatedTypeMirror.AnnotatedNullType subtype, AnnotatedTypeMirror.AnnotatedUnionType supertype, Void p) {
        for (AnnotatedTypeMirror.AnnotatedDeclaredType supertypeAltern : supertype.getAlternatives()) {
            if (!this.isSubtype(subtype, supertypeAltern, this.currentTop)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visitNull_Intersection(AnnotatedTypeMirror.AnnotatedNullType subtype, AnnotatedTypeMirror.AnnotatedIntersectionType supertype, Void p) {
        return this.isPrimarySubtype(subtype, supertype);
    }

    @Override
    public Boolean visitNull_Primitive(AnnotatedTypeMirror.AnnotatedNullType subtype, AnnotatedTypeMirror.AnnotatedPrimitiveType supertype, Void p) {
        return this.isPrimarySubtype(subtype, supertype);
    }

    @Override
    public Boolean visitPrimitive_Declared(AnnotatedTypeMirror.AnnotatedPrimitiveType subtype, AnnotatedTypeMirror.AnnotatedDeclaredType supertype, Void p) {
        AnnotatedTypeMirror.AnnotatedDeclaredType subAsSuper = DefaultTypeHierarchy.castedAsSuper(subtype, supertype);
        if (subAsSuper == null) {
            return this.isPrimarySubtype(subtype, supertype);
        }
        return this.isPrimarySubtype(subAsSuper, supertype);
    }

    @Override
    public Boolean visitPrimitive_Primitive(AnnotatedTypeMirror.AnnotatedPrimitiveType subtype, AnnotatedTypeMirror.AnnotatedPrimitiveType supertype, Void p) {
        return this.isPrimarySubtype(subtype, supertype);
    }

    @Override
    public Boolean visitPrimitive_Intersection(AnnotatedTypeMirror.AnnotatedPrimitiveType subtype, AnnotatedTypeMirror.AnnotatedIntersectionType supertype, Void p) {
        return this.visitIntersectionSupertype(subtype, supertype);
    }

    @Override
    public Boolean visitPrimitive_Typevar(AnnotatedTypeMirror.AnnotatedPrimitiveType subtype, AnnotatedTypeMirror.AnnotatedTypeVariable supertype, Void p) {
        return AtmCombo.accept(subtype, supertype.getUpperBound(), null, this);
    }

    @Override
    public Boolean visitPrimitive_Wildcard(AnnotatedTypeMirror.AnnotatedPrimitiveType subtype, AnnotatedTypeMirror.AnnotatedWildcardType supertype, Void p) {
        if (supertype.atypeFactory.ignoreUninferredTypeArguments && supertype.isUninferredTypeArgument()) {
            return true;
        }
        return this.isPrimarySubtype(subtype, supertype.getSuperBound());
    }

    @Override
    public Boolean visitUnion_Declared(AnnotatedTypeMirror.AnnotatedUnionType subtype, AnnotatedTypeMirror.AnnotatedDeclaredType supertype, Void p) {
        return this.visitUnionSubtype(subtype, supertype);
    }

    @Override
    public Boolean visitUnion_Intersection(AnnotatedTypeMirror.AnnotatedUnionType subtype, AnnotatedTypeMirror.AnnotatedIntersectionType supertype, Void p) {
        return this.visitUnionSubtype(subtype, supertype);
    }

    @Override
    public Boolean visitUnion_Union(AnnotatedTypeMirror.AnnotatedUnionType subtype, AnnotatedTypeMirror.AnnotatedUnionType supertype, Void p) {
        return this.visitUnionSubtype(subtype, supertype);
    }

    @Override
    public Boolean visitUnion_Wildcard(AnnotatedTypeMirror.AnnotatedUnionType subtype, AnnotatedTypeMirror.AnnotatedWildcardType supertype, Void p) {
        return this.visitWildcardSupertype(subtype, supertype);
    }

    @Override
    public Boolean visitTypevar_Declared(AnnotatedTypeMirror.AnnotatedTypeVariable subtype, AnnotatedTypeMirror.AnnotatedDeclaredType supertype, Void p) {
        return this.visitTypevarSubtype(subtype, supertype);
    }

    @Override
    public Boolean visitTypevar_Intersection(AnnotatedTypeMirror.AnnotatedTypeVariable subtype, AnnotatedTypeMirror.AnnotatedIntersectionType supertype, Void p) {
        return this.visitIntersectionSupertype(subtype, supertype);
    }

    @Override
    public Boolean visitTypevar_Primitive(AnnotatedTypeMirror.AnnotatedTypeVariable subtype, AnnotatedTypeMirror.AnnotatedPrimitiveType supertype, Void p) {
        return this.visitTypevarSubtype(subtype, supertype);
    }

    @Override
    public Boolean visitTypevar_Typevar(AnnotatedTypeMirror.AnnotatedTypeVariable subtype, AnnotatedTypeMirror.AnnotatedTypeVariable supertype, Void p) {
        if (AnnotatedTypes.haveSameDeclaration(this.checker.getTypeUtils(), subtype, supertype)) {
            boolean supertypeHasAnno;
            boolean subtypeHasAnno = subtype.getAnnotationInHierarchy(this.currentTop) != null;
            boolean bl = supertypeHasAnno = supertype.getAnnotationInHierarchy(this.currentTop) != null;
            if (subtypeHasAnno && supertypeHasAnno) {
                return this.isPrimarySubtype(subtype, supertype, true);
            }
            if (!subtypeHasAnno && !supertypeHasAnno && this.areEqualInHierarchy(subtype, supertype)) {
                return true;
            }
            if (subtype.getUpperBound().getKind() == TypeKind.INTERSECTION) {
                return (Boolean)this.visit(subtype.getUpperBound(), supertype.getLowerBound(), null);
            }
        }
        if (AnnotatedTypes.areCorrespondingTypeVariables(this.checker.getProcessingEnvironment().getElementUtils(), subtype, supertype) && this.areEqualInHierarchy(subtype, supertype)) {
            return true;
        }
        return this.visitTypevarSubtype(subtype, supertype);
    }

    @Override
    public Boolean visitTypevar_Null(AnnotatedTypeMirror.AnnotatedTypeVariable subtype, AnnotatedTypeMirror.AnnotatedNullType supertype, Void p) {
        return this.visitTypevarSubtype(subtype, supertype);
    }

    @Override
    public Boolean visitTypevar_Wildcard(AnnotatedTypeMirror.AnnotatedTypeVariable subtype, AnnotatedTypeMirror.AnnotatedWildcardType supertype, Void p) {
        return this.visitWildcardSupertype(subtype, supertype);
    }

    @Override
    public Boolean visitWildcard_Array(AnnotatedTypeMirror.AnnotatedWildcardType subtype, AnnotatedTypeMirror.AnnotatedArrayType supertype, Void p) {
        return this.visitWildcardSubtype(subtype, supertype);
    }

    @Override
    public Boolean visitWildcard_Declared(AnnotatedTypeMirror.AnnotatedWildcardType subtype, AnnotatedTypeMirror.AnnotatedDeclaredType supertype, Void p) {
        if (subtype.isUninferredTypeArgument()) {
            if (subtype.atypeFactory.ignoreUninferredTypeArguments) {
                return true;
            }
            if (supertype.getTypeArguments().isEmpty()) {
                AnnotationMirror subtypeAnno = subtype.getEffectiveAnnotationInHierarchy(this.currentTop);
                AnnotationMirror supertypeAnno = supertype.getAnnotationInHierarchy(this.currentTop);
                return this.isAnnoSubtype(subtypeAnno, supertypeAnno, false);
            }
        }
        return this.visitWildcardSubtype(subtype, supertype);
    }

    @Override
    public Boolean visitWildcard_Intersection(AnnotatedTypeMirror.AnnotatedWildcardType subtype, AnnotatedTypeMirror.AnnotatedIntersectionType supertype, Void p) {
        return this.visitWildcardSubtype(subtype, supertype);
    }

    @Override
    public Boolean visitWildcard_Primitive(AnnotatedTypeMirror.AnnotatedWildcardType subtype, AnnotatedTypeMirror.AnnotatedPrimitiveType supertype, Void p) {
        if (subtype.isUninferredTypeArgument()) {
            AnnotationMirror subtypeAnno = subtype.getEffectiveAnnotationInHierarchy(this.currentTop);
            AnnotationMirror supertypeAnno = supertype.getAnnotationInHierarchy(this.currentTop);
            return this.isAnnoSubtype(subtypeAnno, supertypeAnno, false);
        }
        return this.visitWildcardSubtype(subtype, supertype);
    }

    @Override
    public Boolean visitWildcard_Typevar(AnnotatedTypeMirror.AnnotatedWildcardType subtype, AnnotatedTypeMirror.AnnotatedTypeVariable supertype, Void p) {
        return this.visitWildcardSubtype(subtype, supertype);
    }

    @Override
    public Boolean visitWildcard_Wildcard(AnnotatedTypeMirror.AnnotatedWildcardType subtype, AnnotatedTypeMirror.AnnotatedWildcardType supertype, Void p) {
        return this.visitWildcardSubtype(subtype, supertype);
    }

    protected boolean visitIntersectionSupertype(AnnotatedTypeMirror subtype, AnnotatedTypeMirror.AnnotatedIntersectionType supertype) {
        if (this.visitHistory.contains(subtype, supertype, this.currentTop)) {
            return true;
        }
        Boolean result = this.isSubtypeOfAll(subtype, supertype.directSuperTypes());
        this.visitHistory.add(subtype, supertype, this.currentTop, result);
        return result;
    }

    protected boolean visitTypevarSupertype(AnnotatedTypeMirror subtype, AnnotatedTypeMirror.AnnotatedTypeVariable supertype) {
        return this.checkAndSubtype(subtype, supertype.getLowerBound());
    }

    protected boolean visitTypevarSubtype(AnnotatedTypeMirror.AnnotatedTypeVariable subtype, AnnotatedTypeMirror supertype) {
        AnnotatedTypeMirror upperBound = subtype.getUpperBound();
        if (TypesUtils.isBoxedPrimitive(upperBound.getUnderlyingType()) && supertype instanceof AnnotatedTypeMirror.AnnotatedPrimitiveType) {
            upperBound = supertype.atypeFactory.getUnboxedType((AnnotatedTypeMirror.AnnotatedDeclaredType)upperBound);
        }
        if (supertype.getKind() == TypeKind.DECLARED && TypesUtils.getTypeElement(supertype.getUnderlyingType()).getKind() == ElementKind.INTERFACE) {
            while (upperBound.getKind() == TypeKind.TYPEVAR || upperBound.getKind() == TypeKind.WILDCARD) {
                if (upperBound.getKind() == TypeKind.TYPEVAR) {
                    upperBound = ((AnnotatedTypeMirror.AnnotatedTypeVariable)upperBound).getUpperBound();
                }
                if (upperBound.getKind() != TypeKind.WILDCARD) continue;
                upperBound = ((AnnotatedTypeMirror.AnnotatedWildcardType)upperBound).getExtendsBound();
            }
            if (upperBound.getKind() == TypeKind.INTERSECTION) {
                Types types = this.checker.getTypeUtils();
                for (AnnotatedTypeMirror annotatedTypeMirror : ((AnnotatedTypeMirror.AnnotatedIntersectionType)upperBound).directSuperTypes()) {
                    if (!TypesUtils.isErasedSubtype(annotatedTypeMirror.getUnderlyingType(), supertype.getUnderlyingType(), types) || !this.isPrimarySubtype(annotatedTypeMirror, supertype)) continue;
                    return true;
                }
                return false;
            }
            return this.isPrimarySubtype(upperBound, supertype);
        }
        return this.checkAndSubtype(upperBound, supertype);
    }

    protected Boolean visitUnionSubtype(AnnotatedTypeMirror.AnnotatedUnionType subtype, AnnotatedTypeMirror supertype) {
        return this.areAllSubtypes(subtype.getAlternatives(), supertype);
    }

    protected boolean visitWildcardSupertype(AnnotatedTypeMirror subtype, AnnotatedTypeMirror.AnnotatedWildcardType supertype) {
        if (supertype.isUninferredTypeArgument()) {
            return supertype.atypeFactory.ignoreUninferredTypeArguments;
        }
        return this.isSubtype(subtype, supertype.getSuperBound(), this.currentTop);
    }

    protected boolean visitWildcardSubtype(AnnotatedTypeMirror.AnnotatedWildcardType subtype, AnnotatedTypeMirror supertype) {
        TypeVariable atv;
        if (subtype.isUninferredTypeArgument()) {
            return subtype.atypeFactory.ignoreUninferredTypeArguments;
        }
        TypeMirror superTypeMirror = supertype.getUnderlyingType();
        if (supertype.getKind() == TypeKind.TYPEVAR && TypesUtils.isCaptured(atv = (TypeVariable)supertype.getUnderlyingType())) {
            superTypeMirror = TypesUtils.getCapturedWildcard(atv);
        }
        if (superTypeMirror.getKind() == TypeKind.WILDCARD) {
            boolean supertypeHasAnno;
            boolean subtypeHasAnno = subtype.getAnnotationInHierarchy(this.currentTop) != null;
            boolean bl = supertypeHasAnno = supertype.getAnnotationInHierarchy(this.currentTop) != null;
            if (subtypeHasAnno && supertypeHasAnno) {
                return this.isPrimarySubtype(subtype, supertype, true);
            }
            if (!subtypeHasAnno && !supertypeHasAnno && this.areEqualInHierarchy(subtype, supertype)) {
                return true;
            }
        }
        return this.isSubtype(subtype.getExtendsBound(), supertype, this.currentTop);
    }

    public static <T extends AnnotatedTypeMirror> T castedAsSuper(AnnotatedTypeMirror subtype, T supertype) {
        Types types = subtype.atypeFactory.getProcessingEnv().getTypeUtils();
        Elements elements = subtype.atypeFactory.getProcessingEnv().getElementUtils();
        if (subtype.getKind() == TypeKind.NULL) {
            AnnotatedTypeMirror copy = supertype.deepCopy();
            copy.replaceAnnotations(subtype.getAnnotations());
            return (T)copy;
        }
        T asSuperType = AnnotatedTypes.asSuper(subtype.atypeFactory, subtype, supertype);
        DefaultTypeHierarchy.fixUpRawTypes(subtype, asSuperType, supertype, types);
        if (asSuperType != null && AnnotatedTypes.isEnum(asSuperType) && AnnotatedTypes.isDeclarationOfJavaLangEnum(types, elements, supertype)) {
            AnnotatedTypeMirror.AnnotatedDeclaredType resultAtd = ((AnnotatedTypeMirror.AnnotatedDeclaredType)supertype).deepCopy();
            resultAtd.clearAnnotations();
            resultAtd.addAnnotations(asSuperType.getAnnotations());
            AnnotatedTypeMirror.AnnotatedDeclaredType asSuperAdt = (AnnotatedTypeMirror.AnnotatedDeclaredType)asSuperType;
            if (!resultAtd.getTypeArguments().isEmpty() && !asSuperAdt.getTypeArguments().isEmpty()) {
                AnnotatedTypeMirror sourceTypeArg = asSuperAdt.getTypeArguments().get(0);
                AnnotatedTypeMirror resultTypeArg = resultAtd.getTypeArguments().get(0);
                resultTypeArg.clearAnnotations();
                if (resultTypeArg.getKind() == TypeKind.TYPEVAR) {
                    AnnotatedTypeMirror.AnnotatedTypeVariable resultTypeArgTV = (AnnotatedTypeMirror.AnnotatedTypeVariable)resultTypeArg;
                    resultTypeArgTV.getUpperBound().addAnnotations(sourceTypeArg.getAnnotations());
                } else {
                    resultTypeArg.addAnnotations(sourceTypeArg.getAnnotations());
                }
                return (T)resultAtd;
            }
        }
        return asSuperType;
    }

    private static void fixUpRawTypes(AnnotatedTypeMirror originalSubtype, AnnotatedTypeMirror asSuperType, AnnotatedTypeMirror supertype, Types types) {
        if (asSuperType != null && asSuperType.getKind() == TypeKind.DECLARED && originalSubtype.getKind() == TypeKind.DECLARED) {
            Set<Pair<Integer, Integer>> typeArgMap;
            AnnotatedTypeMirror.AnnotatedDeclaredType declaredAsSuper = (AnnotatedTypeMirror.AnnotatedDeclaredType)asSuperType;
            AnnotatedTypeMirror.AnnotatedDeclaredType declaredSubtype = (AnnotatedTypeMirror.AnnotatedDeclaredType)originalSubtype;
            if (declaredAsSuper.wasRaw() && declaredAsSuper.getTypeArguments().isEmpty() && !declaredSubtype.getTypeArguments().isEmpty() && (typeArgMap = TypeArgumentMapper.mapTypeArgumentIndices((TypeElement)declaredSubtype.getUnderlyingType().asElement(), (TypeElement)declaredAsSuper.getUnderlyingType().asElement(), types)).size() == declaredSubtype.getTypeArguments().size()) {
                ArrayList<AnnotatedTypeMirror> newTypeArgs = new ArrayList<AnnotatedTypeMirror>();
                ArrayList<Pair<Integer, Integer>> orderedByDestination = new ArrayList<Pair<Integer, Integer>>(typeArgMap);
                Collections.sort(orderedByDestination, new Comparator<Pair<Integer, Integer>>(){

                    @Override
                    public int compare(Pair<Integer, Integer> o1, Pair<Integer, Integer> o2) {
                        return (Integer)o1.second - (Integer)o2.second;
                    }
                });
                List<AnnotatedTypeMirror> subTypeArgs = declaredSubtype.getTypeArguments();
                if (typeArgMap.size() == ((AnnotatedTypeMirror.AnnotatedDeclaredType)supertype).getTypeArguments().size()) {
                    for (Pair pair : orderedByDestination) {
                        newTypeArgs.add(subTypeArgs.get((Integer)pair.first).deepCopy());
                    }
                }
                declaredAsSuper.setTypeArguments(newTypeArgs);
            }
        }
    }
}

