/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.regex;

import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import org.checkerframework.checker.regex.RegexAnnotatedTypeFactory;
import org.checkerframework.dataflow.analysis.ConditionalTransferResult;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.RegularTransferResult;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.node.ClassNameNode;
import org.checkerframework.dataflow.cfg.node.GreaterThanNode;
import org.checkerframework.dataflow.cfg.node.GreaterThanOrEqualNode;
import org.checkerframework.dataflow.cfg.node.IntegerLiteralNode;
import org.checkerframework.dataflow.cfg.node.LessThanNode;
import org.checkerframework.dataflow.cfg.node.LessThanOrEqualNode;
import org.checkerframework.dataflow.cfg.node.MethodAccessNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.util.NodeUtils;
import org.checkerframework.framework.flow.CFAbstractAnalysis;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFTransfer;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.TreeUtils;

public class RegexTransfer
extends CFTransfer {
    private static final String IS_REGEX_METHOD_NAME = "isRegex";
    private static final String AS_REGEX_METHOD_NAME = "asRegex";
    private final ExecutableElement matchResultgroupCount;

    public RegexTransfer(CFAbstractAnalysis<CFValue, CFStore, CFTransfer> analysis) {
        super(analysis);
        this.matchResultgroupCount = TreeUtils.getMethod("java.util.regex.MatchResult", "groupCount", 0, analysis.getTypeFactory().getProcessingEnv());
    }

    @Override
    public TransferResult<CFValue, CFStore> visitMethodInvocation(MethodInvocationNode n, TransferInput<CFValue, CFStore> in) {
        ClassNameNode cnn;
        String receiverName;
        TransferResult<CFValue, CFStore> result = super.visitMethodInvocation(n, in);
        MethodAccessNode target = n.getTarget();
        ExecutableElement method = target.getMethod();
        Node receiver = target.getReceiver();
        if (receiver instanceof ClassNameNode && this.isRegexUtil(receiverName = (cnn = (ClassNameNode)receiver).getElement().toString())) {
            result = this.handleRegexUtil(n, method, result);
        }
        return result;
    }

    private TransferResult<CFValue, CFStore> handleRegexUtil(MethodInvocationNode n, ExecutableElement method, TransferResult<CFValue, CFStore> result) {
        RegexAnnotatedTypeFactory factory = (RegexAnnotatedTypeFactory)this.analysis.getTypeFactory();
        if (ElementUtils.matchesElement(method, IS_REGEX_METHOD_NAME, String.class, Integer.TYPE)) {
            int groupCount;
            CFStore thenStore = result.getRegularStore();
            CFStore elseStore = (CFStore)thenStore.copy();
            ConditionalTransferResult<CFValue, CFStore> newResult = new ConditionalTransferResult<CFValue, CFStore>(result.getResultValue(), thenStore, elseStore);
            FlowExpressions.Receiver firstParam = FlowExpressions.internalReprOf(factory.getContext().getAnnotationProvider(), n.getArgument(0));
            Node count = n.getArgument(1);
            if (count instanceof IntegerLiteralNode) {
                IntegerLiteralNode iln = (IntegerLiteralNode)count;
                groupCount = iln.getValue();
            } else {
                groupCount = 0;
            }
            AnnotationMirror regexAnnotation = factory.createRegexAnnotation(groupCount);
            thenStore.insertValue(firstParam, regexAnnotation);
            return newResult;
        }
        if (ElementUtils.matchesElement(method, AS_REGEX_METHOD_NAME, String.class, Integer.TYPE)) {
            int groupCount;
            Node count = n.getArgument(1);
            if (count instanceof IntegerLiteralNode) {
                IntegerLiteralNode iln = (IntegerLiteralNode)count;
                groupCount = iln.getValue();
            } else {
                groupCount = 0;
            }
            AnnotationMirror regexAnnotation = factory.createRegexAnnotation(groupCount);
            CFValue newResultValue = (CFValue)this.analysis.createSingleAnnotationValue(regexAnnotation, result.getResultValue().getUnderlyingType());
            return new RegularTransferResult<CFValue, CFStore>(newResultValue, result.getRegularStore());
        }
        return result;
    }

    @Override
    public TransferResult<CFValue, CFStore> visitLessThan(LessThanNode n, TransferInput<CFValue, CFStore> in) {
        TransferResult res = (TransferResult)super.visitLessThan(n, in);
        return this.handleMatcherGroupCount(n.getRightOperand(), n.getLeftOperand(), false, res);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitLessThanOrEqual(LessThanOrEqualNode n, TransferInput<CFValue, CFStore> in) {
        TransferResult res = (TransferResult)super.visitLessThanOrEqual(n, in);
        return this.handleMatcherGroupCount(n.getRightOperand(), n.getLeftOperand(), true, res);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitGreaterThan(GreaterThanNode n, TransferInput<CFValue, CFStore> in) {
        TransferResult res = (TransferResult)super.visitGreaterThan(n, in);
        return this.handleMatcherGroupCount(n.getLeftOperand(), n.getRightOperand(), false, res);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitGreaterThanOrEqual(GreaterThanOrEqualNode n, TransferInput<CFValue, CFStore> in) {
        TransferResult res = (TransferResult)super.visitGreaterThanOrEqual(n, in);
        return this.handleMatcherGroupCount(n.getLeftOperand(), n.getRightOperand(), true, res);
    }

    private TransferResult<CFValue, CFStore> handleMatcherGroupCount(Node possibleMatcher, Node possibleConstant, boolean isAlsoEqual, TransferResult<CFValue, CFStore> resultIn) {
        if (!(possibleMatcher instanceof MethodInvocationNode)) {
            return resultIn;
        }
        if (!(possibleConstant instanceof IntegerLiteralNode)) {
            return resultIn;
        }
        if (!NodeUtils.isMethodInvocation(possibleMatcher, this.matchResultgroupCount, this.analysis.getTypeFactory().getProcessingEnv())) {
            return resultIn;
        }
        MethodAccessNode methodAccessNode = ((MethodInvocationNode)possibleMatcher).getTarget();
        Node receiver = methodAccessNode.getReceiver();
        FlowExpressions.Receiver matcherReceiver = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), receiver);
        IntegerLiteralNode iln = (IntegerLiteralNode)possibleConstant;
        int groupCount = isAlsoEqual ? iln.getValue() : iln.getValue() + 1;
        CFStore thenStore = resultIn.getRegularStore();
        CFStore elseStore = (CFStore)thenStore.copy();
        ConditionalTransferResult<CFValue, CFStore> newResult = new ConditionalTransferResult<CFValue, CFStore>(resultIn.getResultValue(), thenStore, elseStore);
        RegexAnnotatedTypeFactory factory = (RegexAnnotatedTypeFactory)this.analysis.getTypeFactory();
        AnnotationMirror regexAnnotation = factory.createRegexAnnotation(groupCount);
        thenStore.insertValue(matcherReceiver, regexAnnotation);
        return newResult;
    }

    private boolean isRegexUtil(String receiver) {
        return receiver.equals("RegexUtil") || receiver.endsWith(".RegexUtil");
    }
}

