/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.searchindex;

import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.index.IndexAbstractTransfer;
import org.checkerframework.checker.index.IndexUtil;
import org.checkerframework.checker.index.qual.SearchIndexFor;
import org.checkerframework.checker.index.searchindex.SearchIndexAnnotatedTypeFactory;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.framework.flow.CFAnalysis;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFValue;

public class SearchIndexTransfer
extends IndexAbstractTransfer {
    private SearchIndexAnnotatedTypeFactory aTypeFactory;

    public SearchIndexTransfer(CFAnalysis analysis) {
        super(analysis);
        this.aTypeFactory = (SearchIndexAnnotatedTypeFactory)analysis.getTypeFactory();
    }

    private void refineSearchIndexToNegativeIndexFor(Node left, Node right, CFStore store, int valueToCompareTo) {
        AnnotationMirror rightSI;
        assert (valueToCompareTo == 0 || valueToCompareTo == -1);
        Long leftValue = IndexUtil.getExactValue(left.getTree(), this.aTypeFactory.getValueAnnotatedTypeFactory());
        if (leftValue != null && leftValue == (long)valueToCompareTo && (rightSI = this.aTypeFactory.getAnnotationMirror(right.getTree(), SearchIndexFor.class)) != null) {
            List<String> arrays = IndexUtil.getValueOfAnnotationWithStringArgument(rightSI);
            AnnotationMirror nif = this.aTypeFactory.createNegativeIndexFor(arrays);
            store.insertValue(FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), right), nif);
        }
    }

    @Override
    protected void refineGT(Node left, AnnotationMirror leftAnno, Node right, AnnotationMirror rightAnno, CFStore store, TransferInput<CFValue, CFStore> in) {
        this.refineSearchIndexToNegativeIndexFor(left, right, store, 0);
    }

    @Override
    protected void refineGTE(Node left, AnnotationMirror leftAnno, Node right, AnnotationMirror rightAnno, CFStore store, TransferInput<CFValue, CFStore> in) {
        this.refineSearchIndexToNegativeIndexFor(left, right, store, -1);
    }
}

