/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.samelen;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import java.util.Collections;
import java.util.SequencedCollection;
import java.util.TreeSet;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.compilermsgs.qual.CompilerMessageKey;
import org.checkerframework.checker.index.IndexUtil;
import org.checkerframework.checker.index.qual.PolySameLen;
import org.checkerframework.checker.index.qual.SameLen;
import org.checkerframework.checker.index.samelen.SameLenAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.TreeUtils;

public class SameLenVisitor
extends BaseTypeVisitor<SameLenAnnotatedTypeFactory> {
    public SameLenVisitor(BaseTypeChecker checker) {
        super(checker);
    }

    @Override
    protected void commonAssignmentCheck(AnnotatedTypeMirror varType, AnnotatedTypeMirror valueType, Tree valueTree, @CompilerMessageKey String errorKey) {
        FlowExpressions.Receiver rhs;
        if (IndexUtil.isSequenceType(valueType.getUnderlyingType()) && TreeUtils.isExpressionTree(valueTree) && (!valueType.hasAnnotation(PolySameLen.class) || !varType.hasAnnotation(PolySameLen.class)) && (rhs = FlowExpressions.internalReprOf((AnnotationProvider)this.atypeFactory, (ExpressionTree)valueTree)) != null && SameLenAnnotatedTypeFactory.mayAppearInSameLen(rhs)) {
            SequencedCollection<String> exprs;
            String rhsExpr = rhs.toString();
            AnnotationMirror am = valueType.getAnnotation(SameLen.class);
            if (am == null) {
                exprs = Collections.singletonList(rhsExpr);
            } else {
                exprs = new TreeSet<String>(IndexUtil.getValueOfAnnotationWithStringArgument(am));
                exprs.add(rhsExpr);
            }
            AnnotationMirror newSameLen = ((SameLenAnnotatedTypeFactory)this.atypeFactory).createSameLen(exprs);
            valueType.replaceAnnotation(newSameLen);
        }
        super.commonAssignmentCheck(varType, valueType, valueTree, errorKey);
    }
}

