/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.model.AnnotationProxyMaker;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.lang.model.AnnotatedConstruct;

public abstract class AnnoConstruct
implements AnnotatedConstruct {
    private static final Class<? extends Annotation> REPEATABLE_CLASS = AnnoConstruct.initRepeatable();
    private static final Method VALUE_ELEMENT_METHOD = AnnoConstruct.initValueElementMethod();

    public abstract List<? extends Attribute.Compound> getAnnotationMirrors();

    protected <A extends Annotation> Attribute.Compound getAttribute(Class<A> annoType) {
        String name = annoType.getName();
        for (Attribute.Compound anno : this.getAnnotationMirrors()) {
            if (!name.equals(anno.type.tsym.flatName().toString())) continue;
            return anno;
        }
        return null;
    }

    protected <A extends Annotation> A[] getInheritedAnnotations(Class<A> annoType) {
        return (Annotation[])Array.newInstance(annoType, 0);
    }

    @Override
    public <A extends Annotation> A[] getAnnotationsByType(Class<A> annoType) {
        if (!annoType.isAnnotation()) {
            throw new IllegalArgumentException("Not an annotation type: " + annoType);
        }
        Class<? extends Annotation> containerType = AnnoConstruct.getContainer(annoType);
        if (containerType == null) {
            A res = this.getAnnotation(annoType);
            int size = res == null ? 0 : 1;
            Annotation[] arr = (Annotation[])Array.newInstance(annoType, size);
            if (res != null) {
                arr[0] = res;
            }
            return arr;
        }
        String annoTypeName = annoType.getName();
        String containerTypeName = containerType.getName();
        int directIndex = -1;
        int containerIndex = -1;
        Attribute.Compound direct = null;
        Attribute.Compound container = null;
        int index = -1;
        for (Attribute.Compound attribute : this.getAnnotationMirrors()) {
            ++index;
            if (attribute.type.tsym.flatName().contentEquals(annoTypeName)) {
                directIndex = index;
                direct = attribute;
                continue;
            }
            if (containerTypeName == null || !attribute.type.tsym.flatName().contentEquals(containerTypeName)) continue;
            containerIndex = index;
            container = attribute;
        }
        if (direct == null && container == null && annoType.isAnnotationPresent(Inherited.class)) {
            return this.getInheritedAnnotations(annoType);
        }
        Attribute.Compound[] contained = this.unpackContained(container);
        if (direct == null && contained.length == 0 && annoType.isAnnotationPresent(Inherited.class)) {
            return this.getInheritedAnnotations(annoType);
        }
        int size = (direct == null ? 0 : 1) + contained.length;
        Annotation[] arr = (Annotation[])Array.newInstance(annoType, size);
        int insert = -1;
        int length = arr.length;
        if (directIndex >= 0 && containerIndex >= 0) {
            if (directIndex < containerIndex) {
                arr[0] = AnnotationProxyMaker.generateAnnotation(direct, annoType);
                insert = 1;
            } else {
                arr[arr.length - 1] = AnnotationProxyMaker.generateAnnotation(direct, annoType);
                insert = 0;
                --length;
            }
        } else {
            if (directIndex >= 0) {
                arr[0] = AnnotationProxyMaker.generateAnnotation(direct, annoType);
                return arr;
            }
            insert = 0;
        }
        int i = 0;
        while (i + insert < length) {
            arr[insert + i] = AnnotationProxyMaker.generateAnnotation(contained[i], annoType);
            ++i;
        }
        return arr;
    }

    private Attribute.Compound[] unpackContained(Attribute.Compound container) {
        Attribute[] contained0 = null;
        if (container != null) {
            contained0 = AnnoConstruct.unpackAttributes(container);
        }
        ListBuffer<Attribute.Compound> compounds = new ListBuffer<Attribute.Compound>();
        if (contained0 != null) {
            for (Attribute a : contained0) {
                if (!(a instanceof Attribute.Compound)) continue;
                compounds = compounds.append((Attribute.Compound)a);
            }
        }
        return compounds.toArray(new Attribute.Compound[compounds.size()]);
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annoType) {
        if (!annoType.isAnnotation()) {
            throw new IllegalArgumentException("Not an annotation type: " + annoType);
        }
        Attribute.Compound c = this.getAttribute(annoType);
        return c == null ? null : (A)AnnotationProxyMaker.generateAnnotation(c, annoType);
    }

    private static Class<? extends Annotation> initRepeatable() {
        try {
            return Class.forName("java.lang.annotation.Repeatable").asSubclass(Annotation.class);
        }
        catch (ClassNotFoundException | SecurityException e) {
            return null;
        }
    }

    private static Method initValueElementMethod() {
        if (REPEATABLE_CLASS == null) {
            return null;
        }
        Method m3 = null;
        try {
            m3 = REPEATABLE_CLASS.getMethod("value", new Class[0]);
            if (m3 != null) {
                m3.setAccessible(true);
            }
            return m3;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Class<? extends Annotation> getContainer(Class<? extends Annotation> annoType) {
        Annotation repeatable;
        if (REPEATABLE_CLASS != null && VALUE_ELEMENT_METHOD != null && (repeatable = annoType.getAnnotation(REPEATABLE_CLASS)) != null) {
            try {
                Class containerType = (Class)VALUE_ELEMENT_METHOD.invoke((Object)repeatable, new Object[0]);
                if (containerType == null) {
                    return null;
                }
                return containerType;
            }
            catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
                return null;
            }
        }
        return null;
    }

    private static Attribute[] unpackAttributes(Attribute.Compound container) {
        return ((Attribute.Array)container.member((Name)container.type.tsym.name.table.names.value)).values;
    }
}

