/*
 * Decompiled with CFR 0.152.
 */
package annotator.scanner;

import annotator.scanner.CastScanner;
import annotator.scanner.InstanceOfScanner;
import annotator.scanner.LambdaScanner;
import annotator.scanner.LocalVariableScanner;
import annotator.scanner.MethodCallScanner;
import annotator.scanner.NewScanner;
import com.sun.tools.javac.util.Pair;
import org.checkerframework.org.objectweb.asmx.ClassReader;
import org.checkerframework.org.objectweb.asmx.ClassWriter;
import org.checkerframework.org.objectweb.asmx.Handle;
import org.checkerframework.org.objectweb.asmx.Label;
import org.checkerframework.org.objectweb.asmx.MethodAdapter;
import org.checkerframework.org.objectweb.asmx.MethodVisitor;
import scenelib.annotations.io.classfile.CodeOffsetAdapter;

public class MethodOffsetClassVisitor
extends ClassWriter {
    CodeOffsetAdapter coa;
    MethodVisitor mcoa;
    private String methodName = "LocalVariableVisitor: DEFAULT_METHOD";

    public MethodOffsetClassVisitor(ClassReader classReader) {
        super(true, false);
        this.coa = new CodeOffsetAdapter(classReader);
    }

    @Override
    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        this.methodName = string + string2.substring(0, string2.indexOf(")") + 1);
        this.mcoa = this.coa.visitMethod(n, string, string2, string3, stringArray);
        return new MethodOffsetMethodVisitor(super.visitMethod(n, string, string2, string3, stringArray));
    }

    private class MethodOffsetMethodVisitor
    extends MethodAdapter {
        private Label lastLabel;

        public MethodOffsetMethodVisitor(MethodVisitor methodVisitor) {
            super(methodVisitor);
            this.lastLabel = null;
        }

        private int labelOffset() {
            try {
                return this.lastLabel.getOffset();
            }
            catch (Exception exception) {
                return 0;
            }
        }

        @Override
        public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n) {
            super.visitLocalVariable(string, string2, string3, label, label2, n);
            LocalVariableScanner.addToMethodNameIndexMap(Pair.of(MethodOffsetClassVisitor.this.methodName, Pair.of(n, label.getOffset())), string);
            LocalVariableScanner.addToMethodNameCounter(MethodOffsetClassVisitor.this.methodName, string, label.getOffset());
            MethodOffsetClassVisitor.this.mcoa.visitLocalVariable(string, string2, string3, label, label2, n);
        }

        @Override
        public void visitLabel(Label label) {
            super.visitLabel(label);
            this.lastLabel = label;
            MethodOffsetClassVisitor.this.mcoa.visitLabel(label);
        }

        @Override
        public void visitTypeInsn(int n, String string) {
            super.visitTypeInsn(n, string);
            switch (n) {
                case 192: {
                    CastScanner.addCastToMethod(MethodOffsetClassVisitor.this.methodName, MethodOffsetClassVisitor.this.coa.getMethodCodeOffset());
                    break;
                }
                case 187: 
                case 189: {
                    NewScanner.addNewToMethod(MethodOffsetClassVisitor.this.methodName, this.labelOffset());
                    break;
                }
                case 193: {
                    InstanceOfScanner.addInstanceOfToMethod(MethodOffsetClassVisitor.this.methodName, this.labelOffset() + 1);
                }
            }
            MethodOffsetClassVisitor.this.mcoa.visitTypeInsn(n, string);
        }

        @Override
        public void visitMultiANewArrayInsn(String string, int n) {
            super.visitMultiANewArrayInsn(string, n);
            NewScanner.addNewToMethod(MethodOffsetClassVisitor.this.methodName, this.labelOffset());
            MethodOffsetClassVisitor.this.mcoa.visitMultiANewArrayInsn(string, n);
        }

        @Override
        public void visitIntInsn(int n, int n2) {
            super.visitIntInsn(n, n2);
            if (n == 188) {
                NewScanner.addNewToMethod(MethodOffsetClassVisitor.this.methodName, this.labelOffset());
            }
            MethodOffsetClassVisitor.this.mcoa.visitIntInsn(n, n2);
        }

        @Override
        public void visitMethodInsn(int n, String string, String string2, String string3) {
            super.visitMethodInsn(n, string, string2, string3);
            switch (n) {
                case 182: 
                case 184: 
                case 185: {
                    MethodCallScanner.addMethodCallToMethod(MethodOffsetClassVisitor.this.methodName, this.labelOffset());
                    break;
                }
            }
            MethodOffsetClassVisitor.this.mcoa.visitMethodInsn(n, string, string2, string3);
        }

        @Override
        public void visitInvokeDynamicInsn(String string, String string2, Handle handle, Object ... objectArray) {
            super.visitInvokeDynamicInsn(string, string2, handle, objectArray);
            LambdaScanner.addLambdaExpressionToMethod(MethodOffsetClassVisitor.this.methodName, this.labelOffset());
            MethodOffsetClassVisitor.this.mcoa.visitInvokeDynamicInsn(string, string2, handle, objectArray);
        }

        @Override
        public void visitCode() {
            super.visitCode();
            MethodOffsetClassVisitor.this.mcoa.visitCode();
        }

        @Override
        public void visitInsn(int n) {
            super.visitInsn(n);
            MethodOffsetClassVisitor.this.mcoa.visitInsn(n);
        }

        @Override
        public void visitVarInsn(int n, int n2) {
            super.visitVarInsn(n, n2);
            MethodOffsetClassVisitor.this.mcoa.visitVarInsn(n, n2);
        }

        @Override
        public void visitFieldInsn(int n, String string, String string2, String string3) {
            super.visitFieldInsn(n, string, string2, string3);
            MethodOffsetClassVisitor.this.mcoa.visitFieldInsn(n, string, string2, string3);
        }

        @Override
        public void visitJumpInsn(int n, Label label) {
            super.visitJumpInsn(n, label);
            MethodOffsetClassVisitor.this.mcoa.visitJumpInsn(n, label);
        }

        @Override
        public void visitLdcInsn(Object object) {
            super.visitLdcInsn(object);
            MethodOffsetClassVisitor.this.mcoa.visitLdcInsn(object);
        }

        @Override
        public void visitIincInsn(int n, int n2) {
            super.visitIincInsn(n, n2);
            MethodOffsetClassVisitor.this.mcoa.visitIincInsn(n, n2);
        }

        @Override
        public void visitTableSwitchInsn(int n, int n2, Label label, Label[] labelArray) {
            super.visitTableSwitchInsn(n, n2, label, labelArray);
            MethodOffsetClassVisitor.this.mcoa.visitTableSwitchInsn(n, n2, label, labelArray);
        }

        @Override
        public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
            super.visitLookupSwitchInsn(label, nArray, labelArray);
            MethodOffsetClassVisitor.this.mcoa.visitLookupSwitchInsn(label, nArray, labelArray);
        }

        @Override
        public void visitEnd() {
            super.visitEnd();
            MethodOffsetClassVisitor.this.mcoa.visitEnd();
        }
    }
}

