/*
 * Decompiled with CFR 0.152.
 */
package annotator.scanner;

import annotator.scanner.CommonScanner;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MemberReferenceScanner
extends CommonScanner {
    private int index = -1;
    private boolean done = false;
    private final Tree tree;
    private static Map<String, List<Integer>> methodNameToMemberReferenceOffsets = new HashMap<String, List<Integer>>();

    public static int indexOfMemberReferenceTree(TreePath treePath, Tree tree) {
        TreePath treePath2 = MemberReferenceScanner.findCountingContext(treePath);
        if (treePath2 == null) {
            return -1;
        }
        MemberReferenceScanner memberReferenceScanner = new MemberReferenceScanner(tree);
        memberReferenceScanner.scan(treePath2, null);
        return memberReferenceScanner.index;
    }

    private MemberReferenceScanner(Tree tree) {
        this.tree = tree;
    }

    @Override
    public Void visitMemberReference(MemberReferenceTree memberReferenceTree, Void void_) {
        if (!this.done) {
            ++this.index;
        }
        if (this.tree == memberReferenceTree) {
            this.done = true;
        }
        return (Void)super.visitMemberReference(memberReferenceTree, void_);
    }

    public static void addMemberReferenceToMethod(String string, Integer n) {
        List<Integer> list = methodNameToMemberReferenceOffsets.get(string);
        if (list == null) {
            list = new ArrayList<Integer>();
            methodNameToMemberReferenceOffsets.put(string, list);
        }
        list.add(n);
    }

    public static Integer getMemberReferenceIndex(String string, Integer n) {
        List<Integer> list = methodNameToMemberReferenceOffsets.get(string);
        if (list == null) {
            return -1;
        }
        return list.indexOf(n);
    }
}

