/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criterion;
import annotator.scanner.LocalVariableScanner;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.util.Pair;
import java.util.List;
import java.util.Objects;
import scenelib.annotations.el.LocalLocation;

public class LocalVariableCriterion
implements Criterion {
    private final String fullMethodName;
    private final LocalLocation loc;

    public LocalVariableCriterion(String string, LocalLocation localLocation) {
        this.fullMethodName = string.substring(0, string.indexOf(")") + 1);
        this.loc = localLocation;
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath, Tree tree) {
        if (treePath == null) {
            return false;
        }
        assert (treePath.getLeaf() == tree);
        return this.isSatisfiedBy(treePath);
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 == null) {
            return false;
        }
        Tree tree = treePath2.getLeaf();
        Tree tree2 = treePath.getLeaf();
        if (tree instanceof VariableTree) {
            if (treePath2.getParentPath().getLeaf() instanceof MethodTree) {
                return false;
            }
            VariableTree variableTree = (VariableTree)tree;
            if (tree2.equals(variableTree.getInitializer())) {
                return false;
            }
            String string = variableTree.getName().toString();
            if (Objects.equals(this.loc.varName, string)) {
                int n = LocalVariableScanner.indexOfVarTree(treePath, variableTree, string);
                return this.loc.varIndex == n;
            }
            Pair<String, Pair<Integer, Integer>> pair = Pair.of(this.fullMethodName, Pair.of(this.loc.index, this.loc.scopeStart));
            String string2 = LocalVariableScanner.getFromMethodNameIndexMap(pair);
            if (string2 != null && string.equals(string2)) {
                List<Integer> list = LocalVariableScanner.getFromMethodNameCounter(this.fullMethodName, string2);
                Integer n = list.indexOf(this.loc.scopeStart);
                int n2 = LocalVariableScanner.indexOfVarTree(treePath, tree, string2);
                if (n2 == n) {
                    return true;
                }
            }
            return false;
        }
        if (tree instanceof MethodTree) {
            return false;
        }
        return this.isSatisfiedBy(treePath2);
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.LOCAL_VARIABLE;
    }

    public String toString() {
        return "LocalVariableCriterion: in: " + this.fullMethodName + " loc: " + this.loc;
    }
}

