/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.Main;
import annotator.find.AnnotationInsertion;
import annotator.find.Criteria;
import annotator.find.GenericArrayLocationCriterion;
import annotator.find.TreeFinder;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.checkerframework.org.plumelib.util.Pair;
import scenelib.annotations.io.ASTPath;
import scenelib.type.ArrayType;
import scenelib.type.BoundedType;
import scenelib.type.DeclaredType;
import scenelib.type.Type;

public abstract class Insertion {
    private final Criteria criteria;
    private final boolean separateLine;
    private boolean inserted;
    protected Set<String> packageNames;
    protected static Set<String> alwaysQualify = new LinkedHashSet<String>();

    public Insertion(Criteria criteria, boolean bl) {
        this.criteria = criteria;
        this.separateLine = bl;
        this.packageNames = new LinkedHashSet<String>();
        this.inserted = false;
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    public String getText() {
        return this.getText(false, false, true, 0, '\u0000');
    }

    public String getText(boolean bl, boolean bl2, boolean bl3, int n, char c) {
        String string = this.getText(bl, bl2);
        if (!string.isEmpty()) {
            if (this.addLeadingSpace(bl3, n, c)) {
                string = " " + string;
            }
            if (this.addTrailingSpace(bl3)) {
                string = string + " ";
            }
        }
        return string;
    }

    protected abstract String getText(boolean var1, boolean var2);

    protected boolean addLeadingSpace(boolean bl, int n, char c) {
        return !bl && n != 0 && !Character.isWhitespace(c) && c != '(' && c != '<';
    }

    protected boolean addTrailingSpace(boolean bl) {
        return !bl;
    }

    public Set<String> getPackageNames() {
        return this.packageNames;
    }

    public static Set<String> getAlwaysQualify() {
        return alwaysQualify;
    }

    public static void setAlwaysQualify(Set<String> set) {
        alwaysQualify = set;
    }

    public boolean isSeparateLine() {
        return this.separateLine;
    }

    public boolean isInserted() {
        return this.inserted;
    }

    public void setInserted(boolean bl) {
        if (Main.temporaryDebug) {
            System.out.printf("setInserted(%s) (previously %s) for %s%n", bl, this.inserted, this);
            new Error().printStackTrace();
        }
        this.inserted = bl;
    }

    public String toString() {
        return String.format("(nl=%b) @ %s", this.separateLine, this.criteria);
    }

    public abstract Kind getKind();

    public static Pair<String, String> removePackage(String string) {
        String string2;
        int n;
        int n2 = string.indexOf("(");
        if (n2 == -1) {
            n2 = string.length();
        }
        if ((n = string.lastIndexOf(".", n2)) != -1 && !alwaysQualify.contains(string2 = string.substring(n + 1))) {
            String string3 = string.substring(0, n2);
            if (string3.startsWith("@")) {
                return Pair.of(string3.substring(1), "@" + string2);
            }
            return Pair.of(string3, string2);
        }
        return Pair.of(null, string);
    }

    public String typeToString(Type type, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        switch (type.getKind()) {
            case DECLARED: {
                DeclaredType declaredType;
                DeclaredType declaredType2 = (DeclaredType)type;
                String string = declaredType2.getName();
                int n = string.lastIndexOf(46) + 1;
                if (bl2) {
                    string = string.substring(n);
                } else if (n > 0) {
                    stringBuilder.append(string.substring(0, n));
                    string = string.substring(n);
                }
                this.writeAnnotations(type, stringBuilder, bl, bl2);
                stringBuilder.append(string);
                if (declaredType2.isWildcard()) break;
                List<Type> list = declaredType2.getTypeParameters();
                if (!list.isEmpty()) {
                    stringBuilder.append('<');
                    stringBuilder.append(this.typeToString(list.get(0), bl, bl2));
                    for (int i = 1; i < list.size(); ++i) {
                        stringBuilder.append(", ");
                        stringBuilder.append(this.typeToString(list.get(i), bl, bl2));
                    }
                    stringBuilder.append('>');
                }
                if ((declaredType = declaredType2.getInnerType()) == null) break;
                stringBuilder.append('.');
                stringBuilder.append(this.typeToString(declaredType, bl, bl2));
                break;
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)type;
                stringBuilder.append(this.typeToString(arrayType.getComponentType(), bl, bl2));
                if (!arrayType.getAnnotations().isEmpty()) {
                    stringBuilder.append(' ');
                }
                this.writeAnnotations(type, stringBuilder, bl, bl2);
                stringBuilder.append("[]");
                break;
            }
            case BOUNDED: {
                BoundedType boundedType = (BoundedType)type;
                stringBuilder.append(this.typeToString(boundedType.getName(), bl, bl2));
                stringBuilder.append(' ');
                stringBuilder.append((Object)boundedType.getBoundKind());
                stringBuilder.append(' ');
                stringBuilder.append(this.typeToString(boundedType.getBound(), bl, bl2));
                break;
            }
            default: {
                throw new RuntimeException("Illegal kind: " + (Object)((Object)type.getKind()));
            }
        }
        return stringBuilder.toString().trim();
    }

    private void writeAnnotations(Type type, StringBuilder stringBuilder, boolean bl, boolean bl2) {
        for (String string : type.getAnnotations()) {
            AnnotationInsertion annotationInsertion = new AnnotationInsertion(string);
            stringBuilder.append(annotationInsertion.getText(bl, bl2));
            stringBuilder.append(" ");
            if (!bl2) continue;
            this.packageNames.addAll(annotationInsertion.getPackageNames());
        }
    }

    public static void decorateType(List<Insertion> list, Type type) {
        Insertion.decorateType(list, type, null);
    }

    public static void decorateType(List<Insertion> list, Type type, ASTPath aSTPath) {
        for (Insertion insertion : list) {
            insertion.setInserted(true);
            try {
                Iterable<TypeAnnotationPosition.TypePathEntry> iterable;
                if (insertion.getKind() != Kind.ANNOTATION) {
                    throw new RuntimeException("Expected 'ANNOTATION' insertion kind, got '" + (Object)((Object)insertion.getKind()) + "'.");
                }
                GenericArrayLocationCriterion genericArrayLocationCriterion = insertion.getCriteria().getGenericArrayLocation();
                String string = ((AnnotationInsertion)insertion).getAnnotation();
                if (genericArrayLocationCriterion == null) {
                    iterable = insertion.getCriteria().getASTPath();
                    if (aSTPath != null && iterable != null) {
                        Insertion.decorateType(iterable, string, type, aSTPath);
                        continue;
                    }
                    throw new RuntimeException("Missing type path.");
                }
                iterable = genericArrayLocationCriterion.getLocation();
                Type type2 = type;
                for (TypeAnnotationPosition.TypePathEntry typePathEntry : iterable) {
                    switch (typePathEntry.tag) {
                        case ARRAY: {
                            if (type2.getKind() == Type.Kind.ARRAY) {
                                type2 = ((ArrayType)type2).getComponentType();
                                break;
                            }
                            throw new RuntimeException("Incorrect type path.");
                        }
                        case INNER_TYPE: {
                            Type type3;
                            if (type2.getKind() == Type.Kind.DECLARED) {
                                type3 = (DeclaredType)type2;
                                if (((DeclaredType)type3).getInnerType() == null) {
                                    throw new RuntimeException("Incorrect type path: expected inner type but none exists.");
                                }
                                type2 = ((DeclaredType)type3).getInnerType();
                                break;
                            }
                            throw new RuntimeException("Incorrect type path.");
                        }
                        case WILDCARD: {
                            Type type3;
                            if (type2.getKind() == Type.Kind.BOUNDED) {
                                type3 = (BoundedType)type2;
                                if (((BoundedType)type3).getBound() == null) {
                                    throw new RuntimeException("Incorrect type path: expected type bound but none exists.");
                                }
                                type2 = ((BoundedType)type3).getBound();
                                break;
                            }
                            throw new RuntimeException("Incorrect type path.");
                        }
                        case TYPE_ARGUMENT: {
                            Type type3;
                            if (type2.getKind() == Type.Kind.DECLARED) {
                                type3 = (DeclaredType)type2;
                                if (0 <= typePathEntry.arg && typePathEntry.arg < ((DeclaredType)type3).getTypeParameters().size()) {
                                    type2 = ((DeclaredType)type3).getTypeParameter(typePathEntry.arg);
                                    break;
                                }
                                throw new RuntimeException("Incorrect type argument index: " + typePathEntry.arg);
                            }
                            throw new RuntimeException("Incorrect type path.");
                        }
                        default: {
                            throw new RuntimeException("Illegal TypePathEntryKind: " + (Object)((Object)typePathEntry.tag));
                        }
                    }
                }
                if (type2.getKind() == Type.Kind.BOUNDED) {
                    type2 = ((BoundedType)type2).getName();
                }
                type2.addAnnotation(string);
            }
            catch (Throwable throwable) {
                TreeFinder.reportInsertionError(insertion, throwable);
            }
        }
    }

    private static void decorateType(ASTPath aSTPath, String string, Type type, ASTPath aSTPath2) {
        Iterator<ASTPath.ASTEntry> iterator = aSTPath.iterator();
        Iterator<ASTPath.ASTEntry> iterator2 = aSTPath2.iterator();
        while (iterator2.hasNext()) {
            if (iterator.hasNext() && iterator2.next().equals(iterator.next())) continue;
            throw new RuntimeException("Incorrect AST path.");
        }
        while (iterator.hasNext()) {
            ASTPath.ASTEntry aSTEntry = iterator.next();
            Tree.Kind kind = aSTEntry.getTreeKind();
            switch (kind) {
                case ARRAY_TYPE: {
                    if (type.getKind() == Type.Kind.ARRAY) {
                        type = ((ArrayType)type).getComponentType();
                        break;
                    }
                    throw new RuntimeException("Incorrect type path.");
                }
                case MEMBER_SELECT: {
                    Type type2;
                    if (type.getKind() == Type.Kind.DECLARED) {
                        type2 = (DeclaredType)type;
                        if (((DeclaredType)type2).getInnerType() == null) {
                            throw new RuntimeException("Incorrect type path: expected inner type but none exists.");
                        }
                        type = ((DeclaredType)type2).getInnerType();
                        break;
                    }
                    throw new RuntimeException("Incorrect type path.");
                }
                case PARAMETERIZED_TYPE: {
                    if (type.getKind() == Type.Kind.DECLARED) {
                        int n = aSTEntry.getArgument();
                        DeclaredType declaredType = (DeclaredType)type;
                        if (0 <= n && n < declaredType.getTypeParameters().size()) {
                            type = declaredType.getTypeParameter(n);
                            break;
                        }
                        throw new RuntimeException("Incorrect type argument index: " + n);
                    }
                    throw new RuntimeException("Incorrect type path.");
                }
                case UNBOUNDED_WILDCARD: {
                    Type type2;
                    if (type.getKind() == Type.Kind.BOUNDED) {
                        type2 = (BoundedType)type;
                        if (((BoundedType)type2).getBound() == null) {
                            throw new RuntimeException("Incorrect type path: expected type bound but none exists.");
                        }
                        type = ((BoundedType)type2).getBound();
                        break;
                    }
                    throw new RuntimeException("Incorrect type path.");
                }
                default: {
                    throw new RuntimeException("Illegal TreeKind: " + (Object)((Object)kind));
                }
            }
        }
        if (type.getKind() == Type.Kind.BOUNDED) {
            type = ((BoundedType)type).getName();
        }
        type.addAnnotation(string);
    }

    public static enum Kind {
        ANNOTATION,
        CAST,
        CONSTRUCTOR,
        METHOD,
        NEW,
        RECEIVER,
        CLOSE_PARENTHESIS;

    }
}

