/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.Main;
import annotator.find.Criteria;
import annotator.find.Criterion;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;

final class InPackageCriterion
implements Criterion {
    private final String name;

    InPackageCriterion(String string) {
        this.name = string;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.IN_PACKAGE;
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath, Tree tree) {
        if (treePath == null) {
            return false;
        }
        assert (treePath.getLeaf() == tree);
        return this.isSatisfiedBy(treePath);
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        Criteria.dbug.debug("InPackageCriterion.isSatisfiedBy(%s); this=%s", Main.leafString(treePath), this.toString());
        do {
            Tree tree;
            if ((tree = treePath.getLeaf()).getKind() != Tree.Kind.COMPILATION_UNIT) continue;
            CompilationUnitTree compilationUnitTree = (CompilationUnitTree)tree;
            ExpressionTree expressionTree = compilationUnitTree.getPackageName();
            if (expressionTree == null) {
                return this.name == null || this.name.equals("");
            }
            String string = expressionTree.toString();
            return this.name != null && this.name.equals(string);
        } while ((treePath = treePath.getParentPath()) != null && treePath.getLeaf() != null);
        Criteria.dbug.debug("InPackageCriterion.isSatisfiedBy => false", new Object[0]);
        return false;
    }

    public String toString() {
        return "in package '" + this.name + "'";
    }
}

