/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criterion;
import annotator.scanner.CommonScanner;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.tree.JCTree;
import java.util.List;
import scenelib.annotations.el.TypeIndexLocation;

public class ExtImplsLocationCriterion
implements Criterion {
    private final String classname;
    private final Integer index;

    public ExtImplsLocationCriterion(String string, TypeIndexLocation typeIndexLocation) {
        this.classname = string;
        this.index = typeIndexLocation.typeIndex;
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath, Tree tree) {
        if (treePath == null) {
            return false;
        }
        assert (treePath.getLeaf() == tree);
        return this.isSatisfiedBy(treePath);
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        Tree tree = treePath.getLeaf();
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 == null) {
            return false;
        }
        Tree tree2 = treePath2.getLeaf();
        if (tree2 == null) {
            return false;
        }
        boolean bl = false;
        if (this.index == -1 && tree.getKind() == Tree.Kind.CLASS) {
            return ((JCTree.JCClassDecl)tree).getExtendsClause() == null;
        }
        if (CommonScanner.hasClassKind(tree2)) {
            ClassTree classTree = (ClassTree)tree2;
            if (this.index == -1) {
                Tree tree3 = classTree.getExtendsClause();
                if (tree3 == tree) {
                    bl = true;
                }
            } else {
                List<? extends Tree> list = classTree.getImplementsClause();
                if (this.index < list.size() && list.get(this.index) == tree) {
                    bl = true;
                }
            }
        }
        if (!bl) {
            return this.isSatisfiedBy(treePath2);
        }
        return true;
    }

    public Integer getIndex() {
        return this.index;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.EXTIMPLS_LOCATION;
    }

    public String toString() {
        return "ExtImplsLocationCriterion: class " + this.classname + " at type index: " + this.index;
    }
}

