/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criteria;
import annotator.find.Criterion;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import scenelib.annotations.el.BoundLocation;

public class ClassBoundCriterion
implements Criterion {
    private final String className;
    public final BoundLocation boundLoc;
    private final Criterion notInMethodCriterion;
    private final Criterion boundLocCriterion;

    public ClassBoundCriterion(String string, BoundLocation boundLocation) {
        this.className = string;
        this.boundLoc = boundLocation;
        this.notInMethodCriterion = Criteria.notInMethod();
        this.boundLocCriterion = Criteria.atBoundLocation(boundLocation);
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath, Tree tree) {
        if (treePath == null) {
            return false;
        }
        assert (treePath.getLeaf() == tree);
        return this.isSatisfiedBy(treePath);
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        return this.boundLocCriterion.isSatisfiedBy(treePath) && this.notInMethodCriterion.isSatisfiedBy(treePath);
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.CLASS_BOUND;
    }

    public String toString() {
        return "ClassBoundCriterion: for " + this.className + " at " + this.boundLoc;
    }
}

