/*
 * Decompiled with CFR 0.152.
 */
package scenelib.annotations.util.coll;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import scenelib.annotations.util.coll.KeyedSet;
import scenelib.annotations.util.coll.Keyer;

public class LinkedHashKeyedSet<K, V>
extends AbstractSet<V>
implements KeyedSet<K, V> {
    private final Keyer<? extends K, ? super V> keyer;
    private final Map<K, V> theMap = new LinkedHashMap();
    final Collection<V> theValues = this.theMap.values();

    public LinkedHashKeyedSet(Keyer<? extends K, ? super V> keyer) {
        this.keyer = keyer;
    }

    @Override
    public int size() {
        return this.theValues.size();
    }

    @Override
    public boolean contains(Object o) {
        return this.theValues.contains(o);
    }

    @Override
    public Iterator<V> iterator() {
        return new KeyedSetIterator();
    }

    @Override
    public Object[] toArray() {
        return this.theValues.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.theValues.toArray(a);
    }

    private boolean checkAdd(int behavior, V old) {
        switch (behavior) {
            case 1: {
                this.remove(old);
                return true;
            }
            case -1: {
                return false;
            }
            case 0: {
                throw new IllegalStateException();
            }
        }
        throw new IllegalArgumentException();
    }

    private static boolean eq(Object x, Object y) {
        return x == y || x != null && x.equals(y);
    }

    @Override
    public V add(V o, int conflictBehavior, int equalBehavior) {
        K key = this.keyer.getKeyFor(o);
        V old = this.theMap.get(key);
        if (old == null || (LinkedHashKeyedSet.eq(o, old) ? this.checkAdd(equalBehavior, old) : this.checkAdd(conflictBehavior, old))) {
            this.theMap.put(key, o);
        }
        return old;
    }

    @Override
    public boolean add(V o) {
        return this.add(o, 0, -1) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.theValues.remove(o);
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        boolean changed = false;
        for (V o : c) {
            changed |= this.add(o);
        }
        return changed;
    }

    @Override
    public void clear() {
        this.theValues.clear();
    }

    @Override
    public Keyer<? extends K, ? super V> getKeyer() {
        return this.keyer;
    }

    @Override
    public V replace(V v) {
        return this.theMap.put(this.keyer.getKeyFor(v), v);
    }

    @Override
    public V lookup(K k) {
        return this.theMap.get(k);
    }

    private class KeyedSetIterator
    implements Iterator<V> {
        private final Iterator<V> itr;

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public V next() {
            return this.itr.next();
        }

        @Override
        public void remove() {
            this.itr.remove();
        }

        KeyedSetIterator() {
            this.itr = LinkedHashKeyedSet.this.theValues.iterator();
        }
    }
}

