/*
 * Decompiled with CFR 0.152.
 */
package scenelib.annotations.el;

import scenelib.annotations.util.Hasher;

public final class RelativeLocation
implements Comparable<RelativeLocation> {
    public final int offset;
    public final int index;
    public final int type_index;

    private RelativeLocation(int offset, int index, int type_index) {
        this.offset = offset;
        this.index = index;
        this.type_index = type_index;
    }

    public static RelativeLocation createOffset(int offset, int type_index) {
        return new RelativeLocation(offset, -1, type_index);
    }

    public static RelativeLocation createIndex(int index, int type_index) {
        return new RelativeLocation(-1, index, type_index);
    }

    public boolean isBytecodeOffset() {
        return this.offset > -1;
    }

    public String getLocationString() {
        if (this.isBytecodeOffset()) {
            return "#" + this.offset;
        }
        return "*" + this.index;
    }

    @Override
    public int compareTo(RelativeLocation l) {
        int c = Integer.compare(this.offset, l.offset);
        if (c == 0 && (c = Integer.compare(this.index, l.index)) == 0) {
            c = Integer.compare(this.type_index, l.type_index);
        }
        return c;
    }

    public boolean equals(RelativeLocation l) {
        return this.compareTo(l) == 0;
    }

    public boolean equals(Object o) {
        return o instanceof RelativeLocation && this.equals((RelativeLocation)o);
    }

    public int hashCode() {
        Hasher h2 = new Hasher();
        h2.mash(this.offset);
        h2.mash(this.index);
        h2.mash(this.type_index);
        return h2.hash;
    }

    public String toString() {
        return "RelativeLocation(" + this.getLocationString() + ")";
    }
}

