/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.org.plumelib.bcelutil;

import java.io.File;
import java.io.PrintStream;
import java.util.Formatter;
import java.util.HashMap;
import org.checkerframework.checker.formatter.qual.FormatBottom;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.index.qual.SameLen;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.GuardedByBottom;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.BinaryName;
import org.checkerframework.checker.signature.qual.BinaryNameForNonArray;
import org.checkerframework.checker.signature.qual.ClassGetName;
import org.checkerframework.checker.signature.qual.InternalForm;
import org.checkerframework.checker.signature.qual.SignatureBottom;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.common.value.qual.MinLen;
import org.checkerframework.org.apache.bcel.Const;
import org.checkerframework.org.apache.bcel.classfile.Attribute;
import org.checkerframework.org.apache.bcel.classfile.Code;
import org.checkerframework.org.apache.bcel.classfile.Constant;
import org.checkerframework.org.apache.bcel.classfile.ConstantClass;
import org.checkerframework.org.apache.bcel.classfile.ConstantPool;
import org.checkerframework.org.apache.bcel.classfile.ConstantUtf8;
import org.checkerframework.org.apache.bcel.classfile.Field;
import org.checkerframework.org.apache.bcel.classfile.JavaClass;
import org.checkerframework.org.apache.bcel.classfile.Method;
import org.checkerframework.org.apache.bcel.generic.ArrayType;
import org.checkerframework.org.apache.bcel.generic.ClassGen;
import org.checkerframework.org.apache.bcel.generic.CodeExceptionGen;
import org.checkerframework.org.apache.bcel.generic.ConstantPoolGen;
import org.checkerframework.org.apache.bcel.generic.Instruction;
import org.checkerframework.org.apache.bcel.generic.InstructionHandle;
import org.checkerframework.org.apache.bcel.generic.InstructionList;
import org.checkerframework.org.apache.bcel.generic.InstructionTargeter;
import org.checkerframework.org.apache.bcel.generic.LineNumberGen;
import org.checkerframework.org.apache.bcel.generic.LocalVariableGen;
import org.checkerframework.org.apache.bcel.generic.MethodGen;
import org.checkerframework.org.apache.bcel.generic.ObjectType;
import org.checkerframework.org.apache.bcel.generic.RETURN;
import org.checkerframework.org.apache.bcel.generic.Type;
import org.checkerframework.org.plumelib.bcelutil.JvmUtil;

public final class BcelUtil {
    public static @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown boolean skipChecks = false;
    private static final @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown Type stringArray = Type.getType((String)"[Ljava.lang.String;");
    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown HashMap<@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown String, @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown Class<@LockPossiblyHeld @GuardedBy @LockPossiblyHeld @GuardedByBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownFormat @FormatBottom @SignatureUnknown @SignatureBottom ?>> primitiveClasses = new HashMap(8);

    private BcelUtil() {
        throw new Error("do not instantiate");
    }

    static void dumpMethodDeclarations(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown ClassGen gen) {
        System.out.printf("method signatures for class %s%n", gen.getClassName());
        for (Method m3 : gen.getMethods()) {
            System.out.printf("  %s%n", BcelUtil.getMethodDeclaration(m3));
        }
    }

    public static @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown String getMethodDeclaration(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown Method m3) {
        StringBuilder sb = new StringBuilder();
        Formatter f = new Formatter(sb);
        f.format("%s %s %s (", BcelUtil.getAccessFlags(m3), m3.getReturnType(), m3.getName());
        for (Type at : m3.getArgumentTypes()) {
            f.format("%s, ", at);
        }
        f.format(")", new Object[0]);
        return sb.toString().replace(", )", ")");
    }

    static @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown String getAccessFlags(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown Method m3) {
        int flags = m3.getAccessFlags();
        StringBuilder buf = new StringBuilder();
        int pow = 1;
        for (int i = 0; i <= 16384; ++i) {
            if ((flags & pow) != 0) {
                if (buf.length() > 0) {
                    buf.append(" ");
                }
                if (i < Const.ACCESS_NAMES_LENGTH) {
                    buf.append(Const.getAccessName((int)i));
                } else {
                    buf.append(String.format("ACC_BIT %x", pow));
                }
            }
            pow <<= 1;
        }
        return buf.toString();
    }

    public static @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown String getAttributeName(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown Attribute a) {
        ConstantPool pool = a.getConstantPool();
        int conIndex = a.getNameIndex();
        Constant c = pool.getConstant(conIndex);
        String attName = ((ConstantUtf8)c).getBytes();
        return attName;
    }

    public static @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown String getConstantStr(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown ConstantPool pool, @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown int index) {
        Constant c = pool.getConstant(index);
        assert (c != null) : "Bad index " + index + " into pool";
        if (c instanceof ConstantUtf8) {
            return ((ConstantUtf8)c).getBytes();
        }
        if (c instanceof ConstantClass) {
            ConstantClass cc = (ConstantClass)c;
            return cc.getBytes(pool) + " [" + cc.getNameIndex() + "]";
        }
        throw new Error("unexpected constant " + c + " class " + c.getClass());
    }

    public static @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown boolean isConstructor(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown MethodGen mg) {
        return mg.getName().equals("<init>") || mg.getName().equals("");
    }

    public static @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown boolean isConstructor(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown Method m3) {
        return m3.getName().equals("<init>") || m3.getName().equals("");
    }

    public static @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown boolean isClinit(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown MethodGen mg) {
        return mg.getName().equals("<clinit>");
    }

    public static @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown boolean isClinit(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown Method m3) {
        return m3.getName().equals("<clinit>");
    }

    public static @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown boolean inJdk(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown ClassGen gen) {
        return BcelUtil.inJdk(gen.getClassName());
    }

    public static @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown boolean inJdk(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @ClassGetName @UnknownFormat String classname) {
        return classname.startsWith("java.") || classname.startsWith("com.oracle.") || classname.startsWith("com.sun.") || classname.startsWith("javax.") || classname.startsWith("jdk.") || classname.startsWith("org.ietf.") || classname.startsWith("org.jcp.") || classname.startsWith("org.omg.") || classname.startsWith("org.w3c.") || classname.startsWith("org.xml.") || classname.startsWith("sun.") || classname.startsWith("sunw.");
    }

    public static @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown boolean inJdkInternalform(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @InternalForm @UnknownFormat String classname) {
        return classname.startsWith("java/") || classname.startsWith("com/oracle/") || classname.startsWith("com/sun/") || classname.startsWith("javax/") || classname.startsWith("jdk/") || classname.startsWith("org/ietj/") || classname.startsWith("org/jcp/") || classname.startsWith("org/omg/") || classname.startsWith("org/w3c/") || classname.startsWith("org/xml/") || classname.startsWith("sun/") || classname.startsWith("sunw/");
    }

    static void dumpMethods(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown ClassGen gen) {
        System.out.printf("Class %s methods:%n", gen.getClassName());
        for (Method m3 : gen.getMethods()) {
            System.out.printf("  %s%n", m3);
        }
    }

    public static void checkMgen(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown MethodGen mgen) {
        if (skipChecks) {
            return;
        }
        try {
            CodeExceptionGen[] exceptionHandlers;
            mgen.toString();
            mgen.getLineNumberTable(mgen.getConstantPool());
            InstructionList ilist = mgen.getInstructionList();
            if (ilist == null || ilist.getStart() == null) {
                return;
            }
            for (CodeExceptionGen gen : exceptionHandlers = mgen.getExceptionHandlers()) {
                assert (ilist.contains(gen.getStartPC())) : "exception handler " + gen + " has been forgotten in " + mgen.getClassName() + "." + mgen.getName();
            }
            MethodGen nmg = new MethodGen(mgen.getMethod(), mgen.getClassName(), mgen.getConstantPool());
            nmg.getLineNumberTable(mgen.getConstantPool());
        }
        catch (Throwable t) {
            System.out.printf("failure in method %s.%s%n", mgen.getClassName(), mgen.getName());
            t.printStackTrace();
            throw new Error(t);
        }
    }

    public static void checkMgens(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown ClassGen gen) {
        if (skipChecks) {
            return;
        }
        Method[] methods = gen.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            BcelUtil.checkMgen(new MethodGen(method, gen.getClassName(), gen.getConstantPool()));
        }
    }

    public static void addToStart(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown MethodGen mg, @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown InstructionList nl) {
        InstructionList il = mg.getInstructionList();
        InstructionHandle oldStart = il.getStart();
        InstructionHandle newStart = il.insert(nl);
        if (oldStart.hasTargeters()) {
            for (InstructionTargeter it : oldStart.getTargeters()) {
                if (!(it instanceof LineNumberGen) && !(it instanceof LocalVariableGen)) continue;
                it.updateTarget(oldStart, newStart);
            }
        }
        mg.setMaxStack();
        mg.setMaxLocals();
    }

    public static void dump(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown JavaClass jc, @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown String dumpDir) {
        BcelUtil.dump(jc, new File(dumpDir));
    }

    public static void dump(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown JavaClass jc, @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown File dumpDir) {
        try {
            dumpDir.mkdir();
            File path = new File(dumpDir, jc.getClassName() + ".bcel");
            PrintStream p = new PrintStream(path);
            p.printf("class %s extends %s%n", jc.getClassName(), jc.getSuperclassName());
            String[] inames = jc.getInterfaceNames();
            if (inames != null && inames.length > 0) {
                p.printf("   ", new Object[0]);
                for (String string : inames) {
                    p.printf("implements %s ", string);
                }
                p.printf("%n", new Object[0]);
            }
            p.printf("%nFields%n", new Object[0]);
            for (Field field : jc.getFields()) {
                p.printf("  %s%n", field);
            }
            p.printf("%nMethods%n", new Object[0]);
            for (Method method : jc.getMethods()) {
                p.printf("  %s%n", method);
            }
            if (!jc.isInterface()) {
                for (Method method : jc.getMethods()) {
                    p.printf("%nMethod %s%n", method);
                    Code code = method.getCode();
                    if (code == null) continue;
                    p.printf("  %s%n", code.toString().replace("\n", "\n  "));
                }
            }
            p.printf("Constant Pool:%n", new Object[0]);
            ConstantPool constantPool = jc.getConstantPool();
            Constant[] constants = constantPool.getConstantPool();
            for (int ii = 0; ii < constants.length; ++ii) {
                p.printf("  %d %s%n", ii, constants[ii]);
            }
            p.close();
        }
        catch (Exception e) {
            throw new Error("Unexpected error dumping javaclass", e);
        }
    }

    public static @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown String instructionDescr(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown InstructionList il, @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown ConstantPoolGen pool) {
        StringBuilder out = new StringBuilder();
        for (InstructionHandle handle : il) {
            out.append(handle.getInstruction().toString(pool.getConstantPool()) + "\n");
        }
        return out.toString();
    }

    public static @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown String localVarDescr(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown MethodGen mg) {
        StringBuilder out = new StringBuilder();
        out.append(String.format("Locals for %s [cnt %d]%n", mg, mg.getMaxLocals()));
        LocalVariableGen[] lvgs = mg.getLocalVariables();
        if (lvgs != null && lvgs.length > 0) {
            for (LocalVariableGen lvg : lvgs) {
                out.append(String.format("  %s [index %d]%n", lvg, lvg.getIndex()));
            }
        }
        return out.toString();
    }

    public static void addLineNumbers(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown MethodGen mg, @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown InstructionList il) {
        il.setPositions(true);
        for (InstructionHandle ih : il.getInstructionHandles()) {
            mg.addLineNumber(ih, 1000 + ih.getPosition());
        }
    }

    public static void setupInitLocals(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown MethodGen mg) {
        Type @SameLen(value={"argTypes", "mg.getArgumentTypes()"}) [] argTypes = mg.getArgumentTypes();
        String @SameLen(value={"argTypes", "argNames", "mg.getArgumentTypes()", "mg.getArgumentNames()"}) [] argNames = mg.getArgumentNames();
        mg.setMaxLocals(0);
        mg.removeLocalVariables();
        if (!mg.isStatic()) {
            mg.addLocalVariable("this", (Type)new ObjectType(mg.getClassName()), null, null);
        }
        for (int ii = 0; ii < argNames.length; ++ii) {
            mg.addLocalVariable(argNames[ii], argTypes[ii], null, null);
        }
        mg.setMaxLocals();
    }

    public static void emptyMethod(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown MethodGen mg) {
        mg.setInstructionList(new InstructionList((Instruction)new RETURN()));
        mg.removeExceptionHandlers();
        mg.removeLineNumbers();
        mg.removeLocalVariables();
        mg.setMaxLocals();
    }

    public static void removeLocalVariableTypeTables(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown MethodGen mg) {
        for (Attribute a : mg.getCodeAttributes()) {
            if (!BcelUtil.isLocalVariableTypeTable(a, mg.getConstantPool())) continue;
            mg.removeCodeAttribute(a);
        }
    }

    public static @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown boolean isLocalVariableTypeTable(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown Attribute a, @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown ConstantPoolGen pool) {
        return BcelUtil.getAttributeName(a, pool).equals("LocalVariableTypeTable");
    }

    public static @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown String getAttributeName(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown Attribute a, @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown ConstantPoolGen pool) {
        int conIndex = a.getNameIndex();
        Constant c = pool.getConstant(conIndex);
        String attName = ((ConstantUtf8)c).getBytes();
        return attName;
    }

    public static @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown boolean isMain(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown MethodGen mg) {
        Type[] argTypes = mg.getArgumentTypes();
        return mg.isStatic() && mg.getName().equals("main") && argTypes.length == 1 && argTypes[0].equals((Object)stringArray);
    }

    public static @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @ClassGetName @UnknownFormat String typeToClassgetname(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown Type type) {
        String signature = type.getSignature();
        return JvmUtil.fieldDescriptorToClassGetName(signature);
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown Class<@LockPossiblyHeld @GuardedBy @LockPossiblyHeld @GuardedByBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownFormat @FormatBottom @SignatureUnknown @SignatureBottom ?> typeToClass(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown Type type) {
        String classname = BcelUtil.typeToClassgetname(type);
        try {
            Class<?> c = BcelUtil.classForName(classname);
            return c;
        }
        catch (Exception e) {
            throw new RuntimeException("can't find class for " + classname, e);
        }
    }

    public static @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown Type @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown [] postpendToArray(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown Type @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown [] types, @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown Type newType) {
        Type[] newTypes = new Type[types.length + 1];
        System.arraycopy(types, 0, newTypes, 0, types.length);
        newTypes[types.length] = newType;
        Type[] newTypesCast = newTypes;
        return newTypesCast;
    }

    @Deprecated
    public static @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown Type @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown [] addType(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown Type @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown [] types, @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown Type newType) {
        return BcelUtil.postpendToArray(types, newType);
    }

    public static @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown Type @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown [] prependToArray(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown Type newType, @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown Type @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown [] types) {
        Type @MinLen(value=1) [] newTypes = new Type[types.length + 1];
        System.arraycopy(types, 0, newTypes, 1, types.length);
        newTypes[0] = newType;
        Type[] newTypesCast = newTypes;
        return newTypesCast;
    }

    @Deprecated
    public static @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown Type @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown [] insertType(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown Type newType, @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown Type @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown [] types) {
        return BcelUtil.prependToArray(newType, types);
    }

    public static @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown Type classnameToType(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @BinaryName @UnknownFormat String classname) {
        int arrayDepth = 0;
        while (classname.endsWith("[]")) {
            String sansArray;
            classname = sansArray = classname.substring(0, classname.length() - 2);
            ++arrayDepth;
        }
        @BinaryNameForNonArray String tmp = classname;
        classname = tmp.intern();
        Object t = null;
        t = classname == "int" ? Type.INT : (classname == "boolean" ? Type.BOOLEAN : (classname == "byte" ? Type.BYTE : (classname == "char" ? Type.CHAR : (classname == "double" ? Type.DOUBLE : (classname == "float" ? Type.FLOAT : (classname == "long" ? Type.LONG : (classname == "short" ? Type.SHORT : new ObjectType(classname))))))));
        if (arrayDepth > 0) {
            t = new ArrayType((Type)t, arrayDepth);
        }
        return t;
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown Class<@LockPossiblyHeld @GuardedBy @LockPossiblyHeld @GuardedByBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownFormat @FormatBottom @SignatureUnknown @SignatureBottom ?> classForName(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @ClassGetName @UnknownFormat String className) throws @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown ClassNotFoundException {
        Class<?> result = primitiveClasses.get(className);
        if (result != null) {
            return result;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            int pos = className.lastIndexOf(46);
            if (pos < 0) {
                throw e;
            }
            @ClassGetName String innerName = className.substring(0, pos) + "$" + className.substring(pos + 1);
            try {
                return Class.forName(innerName);
            }
            catch (ClassNotFoundException ee) {
                throw e;
            }
        }
    }

    static {
        primitiveClasses.put("boolean", Boolean.TYPE);
        primitiveClasses.put("byte", Byte.TYPE);
        primitiveClasses.put("char", Character.TYPE);
        primitiveClasses.put("double", Double.TYPE);
        primitiveClasses.put("float", Float.TYPE);
        primitiveClasses.put("int", Integer.TYPE);
        primitiveClasses.put("long", Long.TYPE);
        primitiveClasses.put("short", Short.TYPE);
    }
}

