/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.typeinference.solver;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeVariable;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.AnnotationMirrorMap;
import org.checkerframework.framework.util.AnnotationMirrorSet;
import org.checkerframework.framework.util.typeinference.TypeArgInferenceUtil;
import org.checkerframework.framework.util.typeinference.solver.ConstraintMap;
import org.checkerframework.framework.util.typeinference.solver.InferenceResult;
import org.checkerframework.framework.util.typeinference.solver.InferredValue;
import org.checkerframework.framework.util.typeinference.solver.TargetConstraints;
import org.checkerframework.javacutil.BugInCF;

public class EqualitiesSolver {
    private boolean dirty = false;

    public InferenceResult solveEqualities(Set<TypeVariable> targets, ConstraintMap constraintMap, AnnotatedTypeFactory typeFactory) {
        InferenceResult solution = new InferenceResult();
        do {
            this.dirty = false;
            for (TypeVariable target : targets) {
                TargetConstraints.Equalities equalities;
                InferredValue inferred;
                if (solution.containsKey(target) || (inferred = this.mergeConstraints(target, equalities = constraintMap.getConstraints((TypeVariable)target).equalities, solution, constraintMap, typeFactory)) == null) continue;
                if (inferred instanceof InferredValue.InferredType) {
                    this.rewriteWithInferredType(target, ((InferredValue.InferredType)inferred).type, constraintMap);
                } else {
                    this.rewriteWithInferredTarget(target, ((InferredValue.InferredTarget)inferred).target, constraintMap, typeFactory);
                }
                solution.put(target, inferred);
            }
        } while (this.dirty);
        solution.resolveChainedTargets();
        return solution;
    }

    private void rewriteWithInferredType(TypeVariable target, AnnotatedTypeMirror type, ConstraintMap constraints) {
        AnnotationMirrorSet otherHierarchies;
        AnnotatedTypeMirror copy;
        LinkedHashMap<AnnotatedTypeMirror, AnnotationMirrorSet> toIterate;
        AnnotationMirrorSet hierarchies;
        TargetConstraints record;
        TargetConstraints targetRecord = constraints.getConstraints(target);
        Map<TypeVariable, AnnotationMirrorSet> equivalentTargets = targetRecord.equalities.targets;
        for (Map.Entry<TypeVariable, AnnotationMirrorSet> eqEntry : equivalentTargets.entrySet()) {
            constraints.addTypeEqualities(eqEntry.getKey(), type, eqEntry.getValue());
        }
        for (TypeVariable otherTarget : constraints.getTargets()) {
            if (otherTarget == target) continue;
            record = constraints.getConstraints(otherTarget);
            hierarchies = record.equalities.targets.get(target);
            if (hierarchies != null) {
                record.equalities.targets.remove(target);
                constraints.addTypeEqualities(otherTarget, type, hierarchies);
            }
            toIterate = new LinkedHashMap<AnnotatedTypeMirror, AnnotationMirrorSet>(record.equalities.types);
            record.equalities.types.clear();
            for (AnnotatedTypeMirror otherType : toIterate.keySet()) {
                copy = TypeArgInferenceUtil.substitute(target, type, otherType);
                otherHierarchies = (AnnotationMirrorSet)toIterate.get(otherType);
                record.equalities.types.put(copy, otherHierarchies);
            }
        }
        for (TypeVariable otherTarget : constraints.getTargets()) {
            if (otherTarget == target) continue;
            record = constraints.getConstraints(otherTarget);
            hierarchies = record.supertypes.targets.get(target);
            if (hierarchies != null) {
                record.supertypes.targets.remove(target);
                constraints.addTypeEqualities(otherTarget, type, hierarchies);
            }
            toIterate = new LinkedHashMap<AnnotatedTypeMirror, AnnotationMirrorSet>(record.supertypes.types);
            record.supertypes.types.clear();
            for (AnnotatedTypeMirror otherType : toIterate.keySet()) {
                copy = TypeArgInferenceUtil.substitute(target, type, otherType);
                otherHierarchies = (AnnotationMirrorSet)toIterate.get(otherType);
                record.supertypes.types.put(copy, otherHierarchies);
            }
        }
        targetRecord.equalities.clear();
        targetRecord.supertypes.clear();
    }

    private void rewriteWithInferredTarget(TypeVariable target, TypeVariable inferredTarget, ConstraintMap constraints, AnnotatedTypeFactory typeFactory) {
        AnnotationMirrorSet otherHierarchies;
        AnnotatedTypeMirror copy;
        LinkedHashMap<AnnotatedTypeMirror, AnnotationMirrorSet> toIterate;
        AnnotationMirrorSet hierarchies;
        TargetConstraints record;
        TargetConstraints targetRecord = constraints.getConstraints(target);
        Map<AnnotatedTypeMirror, AnnotationMirrorSet> equivalentTypes = targetRecord.equalities.types;
        Map<AnnotatedTypeMirror, AnnotationMirrorSet> supertypes = targetRecord.supertypes.types;
        for (Map.Entry<AnnotatedTypeMirror, AnnotationMirrorSet> eqEntry : equivalentTypes.entrySet()) {
            constraints.addTypeEqualities(inferredTarget, eqEntry.getKey(), eqEntry.getValue());
        }
        for (Map.Entry<AnnotatedTypeMirror, AnnotationMirrorSet> superEntry : supertypes.entrySet()) {
            constraints.addTypeSupertype(inferredTarget, superEntry.getKey(), superEntry.getValue());
        }
        for (TypeVariable otherTarget : constraints.getTargets()) {
            if (otherTarget == target || otherTarget == inferredTarget) continue;
            record = constraints.getConstraints(otherTarget);
            hierarchies = record.equalities.targets.get(target);
            if (hierarchies != null) {
                record.equalities.targets.remove(target);
                constraints.addTargetEquality(otherTarget, inferredTarget, hierarchies);
            }
            toIterate = new LinkedHashMap<AnnotatedTypeMirror, AnnotationMirrorSet>(record.equalities.types);
            record.equalities.types.clear();
            for (AnnotatedTypeMirror otherType : toIterate.keySet()) {
                copy = TypeArgInferenceUtil.substitute(target, this.createAnnotatedTypeVar(target, typeFactory), otherType);
                otherHierarchies = (AnnotationMirrorSet)toIterate.get(otherType);
                record.equalities.types.put(copy, otherHierarchies);
            }
        }
        for (TypeVariable otherTarget : constraints.getTargets()) {
            if (otherTarget == target || otherTarget == inferredTarget) continue;
            record = constraints.getConstraints(otherTarget);
            hierarchies = record.supertypes.targets.get(target);
            if (hierarchies != null) {
                record.supertypes.targets.remove(target);
                constraints.addTargetSupertype(otherTarget, inferredTarget, hierarchies);
            }
            toIterate = new LinkedHashMap<AnnotatedTypeMirror, AnnotationMirrorSet>(record.supertypes.types);
            record.supertypes.types.clear();
            for (AnnotatedTypeMirror otherType : toIterate.keySet()) {
                copy = TypeArgInferenceUtil.substitute(target, this.createAnnotatedTypeVar(target, typeFactory), otherType);
                otherHierarchies = (AnnotationMirrorSet)toIterate.get(otherType);
                record.supertypes.types.put(copy, otherHierarchies);
            }
        }
        targetRecord.equalities.clear();
        targetRecord.supertypes.clear();
    }

    private AnnotatedTypeMirror.AnnotatedTypeVariable createAnnotatedTypeVar(TypeVariable typeVariable, AnnotatedTypeFactory typeFactory) {
        return (AnnotatedTypeMirror.AnnotatedTypeVariable)typeFactory.getAnnotatedType(typeVariable.asElement());
    }

    private InferredValue.InferredType mergeTypesAndPrimaries(Map<AnnotatedTypeMirror, AnnotationMirrorSet> typesToHierarchies, AnnotationMirrorMap<AnnotationMirror> primaries, AnnotationMirrorSet tops) {
        AnnotationMirrorSet missingAnnos = new AnnotationMirrorSet(tops);
        Iterator<Map.Entry<AnnotatedTypeMirror, AnnotationMirrorSet>> entryIterator = typesToHierarchies.entrySet().iterator();
        if (!entryIterator.hasNext()) {
            throw new BugInCF("Merging a list of empty types.");
        }
        Map.Entry<AnnotatedTypeMirror, AnnotationMirrorSet> head = entryIterator.next();
        AnnotatedTypeMirror mergedType = head.getKey();
        missingAnnos.removeAll(head.getValue());
        while (entryIterator.hasNext() && !missingAnnos.isEmpty()) {
            Map.Entry<AnnotatedTypeMirror, AnnotationMirrorSet> current = entryIterator.next();
            AnnotatedTypeMirror currentType = (AnnotatedTypeMirror)current.getKey();
            AnnotationMirrorSet currentHierarchies = (AnnotationMirrorSet)current.getValue();
            AnnotationMirrorSet found = new AnnotationMirrorSet();
            for (AnnotationMirror top : missingAnnos) {
                if (!currentHierarchies.contains(top)) continue;
                AnnotationMirror newAnno = currentType.getAnnotationInHierarchy(top);
                if (newAnno != null) {
                    mergedType.replaceAnnotation(newAnno);
                    found.add(top);
                    continue;
                }
                if (mergedType.getKind() == TypeKind.TYPEVAR && currentType.getUnderlyingType().equals(mergedType.getUnderlyingType())) {
                    found.add(top);
                    continue;
                }
                throw new BugInCF("Missing annotation.\n\nmergedType=" + mergedType + "\ncurrentType=" + currentType);
            }
            missingAnnos.removeAll(found);
        }
        for (AnnotationMirror top : missingAnnos) {
            AnnotationMirror anno = primaries.get(top);
            if (anno == null) continue;
            mergedType.replaceAnnotation(anno);
        }
        typesToHierarchies.clear();
        if (missingAnnos.isEmpty()) {
            return new InferredValue.InferredType(mergedType);
        }
        AnnotationMirrorSet hierarchies = new AnnotationMirrorSet(tops);
        hierarchies.removeAll(missingAnnos);
        typesToHierarchies.put(mergedType, hierarchies);
        return null;
    }

    public InferredValue mergeConstraints(TypeVariable target, TargetConstraints.Equalities equalities, InferenceResult solution, ConstraintMap constraintMap, AnnotatedTypeFactory typeFactory) {
        AnnotationMirrorSet tops = new AnnotationMirrorSet(typeFactory.getQualifierHierarchy().getTopAnnotations());
        InferredValue inferred = null;
        if (!equalities.types.isEmpty()) {
            inferred = this.mergeTypesAndPrimaries(equalities.types, equalities.primaries, tops);
        }
        if (inferred != null) {
            return inferred;
        }
        this.dirty |= this.updateTargetsWithPartiallyInferredType(equalities, constraintMap, typeFactory);
        inferred = this.findEqualTarget(equalities, tops);
        if (inferred == null && equalities.types.size() == 1) {
            AnnotatedTypeMirror type = equalities.types.keySet().iterator().next();
            inferred = new InferredValue.InferredType(type);
        }
        return inferred;
    }

    public boolean updateTargetsWithPartiallyInferredType(TargetConstraints.Equalities equalities, ConstraintMap constraintMap, AnnotatedTypeFactory typeFactory) {
        boolean updated = false;
        if (!equalities.types.isEmpty()) {
            if (equalities.types.size() != 1) {
                throw new BugInCF("Equalities should have at most 1 constraint.");
            }
            Map.Entry<AnnotatedTypeMirror, AnnotationMirrorSet> remainingTypeEquality = equalities.types.entrySet().iterator().next();
            AnnotatedTypeMirror remainingType = remainingTypeEquality.getKey();
            AnnotationMirrorSet remainingHierarchies = remainingTypeEquality.getValue();
            for (Map.Entry<TypeVariable, AnnotationMirrorSet> targetToHierarchies : equalities.targets.entrySet()) {
                TypeVariable equalTarget = targetToHierarchies.getKey();
                AnnotationMirrorSet hierarchies = targetToHierarchies.getValue();
                AnnotationMirrorSet equalTypeHierarchies = new AnnotationMirrorSet(remainingHierarchies);
                equalTypeHierarchies.retainAll(hierarchies);
                Map<AnnotatedTypeMirror, AnnotationMirrorSet> otherTargetsEqualTypes = constraintMap.getConstraints((TypeVariable)equalTarget).equalities.types;
                AnnotationMirrorSet equalHierarchies = otherTargetsEqualTypes.get(remainingType);
                if (equalHierarchies == null) {
                    equalHierarchies = new AnnotationMirrorSet(equalTypeHierarchies);
                    otherTargetsEqualTypes.put(remainingType, equalHierarchies);
                    updated = true;
                    continue;
                }
                int size = equalHierarchies.size();
                equalHierarchies.addAll(equalTypeHierarchies);
                updated = size == equalHierarchies.size();
            }
        }
        return updated;
    }

    public InferredValue.InferredTarget findEqualTarget(TargetConstraints.Equalities equalities, AnnotationMirrorSet tops) {
        for (Map.Entry<TypeVariable, AnnotationMirrorSet> targetToHierarchies : equalities.targets.entrySet()) {
            boolean targetIsEqualInAllHierarchies;
            TypeVariable equalTarget = targetToHierarchies.getKey();
            AnnotationMirrorSet hierarchies = targetToHierarchies.getValue();
            boolean bl = targetIsEqualInAllHierarchies = hierarchies.size() == tops.size();
            if (targetIsEqualInAllHierarchies) {
                return new InferredValue.InferredTarget(equalTarget, new AnnotationMirrorSet());
            }
            AnnotationMirrorSet requiredPrimaries = new AnnotationMirrorSet(equalities.primaries.keySet());
            requiredPrimaries.removeAll(hierarchies);
            boolean typeWithPrimariesIsEqual = requiredPrimaries.size() + hierarchies.size() == tops.size();
            if (!typeWithPrimariesIsEqual) continue;
            return new InferredValue.InferredTarget(equalTarget, requiredPrimaries);
        }
        return null;
    }
}

