/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type.poly;

import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Elements;
import org.checkerframework.framework.qual.PolyAll;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.poly.QualifierPolymorphism;
import org.checkerframework.framework.type.visitor.AnnotatedTypeScanner;
import org.checkerframework.framework.type.visitor.EquivalentAtmComboScanner;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.framework.util.AnnotationMirrorMap;
import org.checkerframework.framework.util.AnnotationMirrorSet;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.TreeUtils;

public abstract class AbstractQualifierPolymorphism
implements QualifierPolymorphism {
    protected final AnnotatedTypeFactory atypeFactory;
    protected final AnnotationMirrorMap<AnnotationMirror> polyQuals;
    protected final AnnotationMirrorSet topQuals;
    protected final QualifierHierarchy qualhierarchy;
    protected final AnnotationMirror POLYALL;
    private PolyCollector collector;
    private Completer completer;
    private AnnotatedTypeScanner<Void, AnnotationMirrorMap<AnnotationMirrorSet>> replacer;

    public AbstractQualifierPolymorphism(ProcessingEnvironment env, AnnotatedTypeFactory factory) {
        this.atypeFactory = factory;
        this.qualhierarchy = factory.getQualifierHierarchy();
        this.topQuals = new AnnotationMirrorSet(this.qualhierarchy.getTopAnnotations());
        Elements elements = env.getElementUtils();
        this.POLYALL = AnnotationBuilder.fromClass(elements, PolyAll.class);
        this.polyQuals = new AnnotationMirrorMap();
        this.collector = new PolyCollector();
        this.completer = new Completer();
        this.replacer = new Replacer();
    }

    protected void reset() {
        this.completer.reset();
        this.replacer.reset();
        this.collector.reset();
    }

    @Override
    public void annotate(MethodInvocationTree tree, AnnotatedTypeMirror.AnnotatedExecutableType type) {
        if (this.polyQuals.isEmpty()) {
            return;
        }
        if (TreeUtils.isEnumSuper(tree)) {
            return;
        }
        List<AnnotatedTypeMirror> parameters = AnnotatedTypes.expandVarArgs(this.atypeFactory, type, tree.getArguments());
        List<AnnotatedTypeMirror> arguments = AnnotatedTypes.getAnnotatedTypes(this.atypeFactory, parameters, tree.getArguments());
        AnnotationMirrorMap<AnnotationMirrorSet> matchingMapping = this.collector.visit(arguments, parameters);
        if (type.getReceiverType() != null && !TreeUtils.isSuperCall(tree) && !TreeUtils.isThisCall(tree)) {
            matchingMapping = this.collector.reduce(matchingMapping, this.collector.visit(this.atypeFactory.getReceiverType(tree), type.getReceiverType()));
        }
        if (matchingMapping != null && !matchingMapping.isEmpty()) {
            this.replacer.visit(type, matchingMapping);
        } else {
            this.completer.visit(type);
        }
        this.reset();
    }

    @Override
    public void annotate(NewClassTree tree, AnnotatedTypeMirror.AnnotatedExecutableType type) {
        if (this.polyQuals.isEmpty()) {
            return;
        }
        List<AnnotatedTypeMirror> requiredArgs = AnnotatedTypes.expandVarArgs(this.atypeFactory, type, tree.getArguments());
        List<AnnotatedTypeMirror> arguments = AnnotatedTypes.getAnnotatedTypes(this.atypeFactory, requiredArgs, tree.getArguments());
        AnnotationMirrorMap matchingMapping = this.collector.visit(arguments, requiredArgs);
        if (matchingMapping != null && !matchingMapping.isEmpty()) {
            this.replacer.visit(type, matchingMapping);
        } else {
            this.completer.visit(type);
        }
        this.reset();
    }

    @Override
    public void annotate(AnnotatedTypeMirror.AnnotatedExecutableType functionalInterface, AnnotatedTypeMirror.AnnotatedExecutableType memberReference) {
        AnnotationMirrorMap matchingMapping;
        for (AnnotationMirror type : functionalInterface.getReturnType().getAnnotations()) {
            if (!QualifierPolymorphism.isPolymorphicQualified(type)) continue;
            return;
        }
        List<AnnotatedTypeMirror> args = functionalInterface.getParameterTypes();
        List<AnnotatedTypeMirror> requiredArgs = memberReference.getParameterTypes();
        if (args.size() == requiredArgs.size() + 1) {
            ArrayList<AnnotatedTypeMirror> newRequiredArgs = new ArrayList<AnnotatedTypeMirror>();
            newRequiredArgs.add(memberReference.getReceiverType());
            newRequiredArgs.addAll(requiredArgs);
            requiredArgs = newRequiredArgs;
        }
        if (memberReference.isVarArgs() && !functionalInterface.isVarArgs()) {
            requiredArgs = AnnotatedTypes.expandVarArgsFromTypes(memberReference, args);
        }
        if ((matchingMapping = this.collector.visit(args, requiredArgs)) != null && !matchingMapping.isEmpty()) {
            this.replacer.visit(memberReference, matchingMapping);
        } else {
            this.completer.visit(memberReference);
        }
        this.reset();
    }

    protected abstract AnnotationMirrorSet combine(AnnotationMirror var1, AnnotationMirrorSet var2, AnnotationMirrorSet var3);

    protected abstract void replace(AnnotatedTypeMirror var1, AnnotationMirrorMap<AnnotationMirrorSet> var2);

    private class PolyCollector
    extends EquivalentAtmComboScanner<AnnotationMirrorMap<AnnotationMirrorSet>, Void> {
        private final List<AnnotatedTypeMirror> visitedType2 = new ArrayList<AnnotatedTypeMirror>();

        private PolyCollector() {
        }

        private boolean visited(AnnotatedTypeMirror atm) {
            for (AnnotatedTypeMirror atmVisit : this.visitedType2) {
                if (atmVisit != atm) continue;
                return true;
            }
            this.visitedType2.add(atm);
            return false;
        }

        @Override
        protected AnnotationMirrorMap<AnnotationMirrorSet> scanWithNull(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2, Void aVoid) {
            return new AnnotationMirrorMap<AnnotationMirrorSet>();
        }

        @Override
        public AnnotationMirrorMap<AnnotationMirrorSet> reduce(AnnotationMirrorMap<AnnotationMirrorSet> r1, AnnotationMirrorMap<AnnotationMirrorSet> r2) {
            if (r1 == null || r1.isEmpty()) {
                return r2;
            }
            if (r2 == null || r2.isEmpty()) {
                return r1;
            }
            AnnotationMirrorMap<AnnotationMirrorSet> res = new AnnotationMirrorMap<AnnotationMirrorSet>();
            AnnotationMirrorSet r2remain = new AnnotationMirrorSet();
            r2remain.addAll((Collection<? extends AnnotationMirror>)r2.keySet());
            for (Map.Entry<AnnotationMirror, AnnotationMirrorSet> entry : r1.entrySet()) {
                AnnotationMirror polyQual = entry.getKey();
                AnnotationMirrorSet a1Annos = entry.getValue();
                AnnotationMirrorSet a2Annos = r2.get(polyQual);
                if (a2Annos != null && !a2Annos.isEmpty()) {
                    r2remain.remove(polyQual);
                }
                res.put(polyQual, AbstractQualifierPolymorphism.this.combine(polyQual, a1Annos, a2Annos));
            }
            for (AnnotationMirror key2 : r2remain) {
                res.put(key2, r2.get(key2));
            }
            return res;
        }

        private AnnotationMirrorMap<AnnotationMirrorSet> visit(Iterable<? extends AnnotatedTypeMirror> types, Iterable<? extends AnnotatedTypeMirror> polyTypes) {
            AnnotationMirrorMap<AnnotationMirrorSet> result = new AnnotationMirrorMap<AnnotationMirrorSet>();
            Iterator<? extends AnnotatedTypeMirror> itert = types.iterator();
            Iterator<? extends AnnotatedTypeMirror> itera = polyTypes.iterator();
            while (itert.hasNext() && itera.hasNext()) {
                AnnotatedTypeMirror type = itert.next();
                AnnotatedTypeMirror actualType = itera.next();
                result = this.reduce(result, this.visit(type, actualType));
            }
            return result;
        }

        private AnnotationMirrorMap<AnnotationMirrorSet> visit(AnnotatedTypeMirror type, AnnotatedTypeMirror polyType) {
            if (type.getKind() == TypeKind.NULL) {
                return this.mapQualifierToPoly(type, polyType);
            }
            if (type.getKind() == TypeKind.WILDCARD) {
                AnnotatedTypeMirror.AnnotatedWildcardType wildcardType = (AnnotatedTypeMirror.AnnotatedWildcardType)type;
                if (wildcardType.isUninferredTypeArgument()) {
                    return this.mapQualifierToPoly(wildcardType.getExtendsBound(), polyType);
                }
                switch (polyType.getKind()) {
                    case WILDCARD: {
                        AnnotatedTypeMirror asSuper = AnnotatedTypes.asSuper(AbstractQualifierPolymorphism.this.atypeFactory, wildcardType, polyType);
                        return (AnnotationMirrorMap)this.visit(asSuper, polyType, null);
                    }
                    case TYPEVAR: {
                        return this.mapQualifierToPoly(wildcardType.getExtendsBound(), polyType);
                    }
                }
                return this.mapQualifierToPoly(wildcardType.getExtendsBound(), polyType);
            }
            AnnotatedTypeMirror asSuper = AnnotatedTypes.asSuper(AbstractQualifierPolymorphism.this.atypeFactory, type, polyType);
            return (AnnotationMirrorMap)this.visit(asSuper, polyType, null);
        }

        private AnnotationMirrorMap<AnnotationMirrorSet> mapQualifierToPoly(AnnotatedTypeMirror type, AnnotatedTypeMirror actualType) {
            AnnotationMirrorMap<AnnotationMirrorSet> result = new AnnotationMirrorMap<AnnotationMirrorSet>();
            for (Map.Entry<AnnotationMirror, AnnotationMirror> kv : AbstractQualifierPolymorphism.this.polyQuals.entrySet()) {
                AnnotationMirror typeQual;
                AnnotationMirror top = kv.getValue();
                AnnotationMirror poly = kv.getKey();
                if (top == null && actualType.hasAnnotation(AbstractQualifierPolymorphism.this.POLYALL)) {
                    result.put(poly, new AnnotationMirrorSet(type.getAnnotations()));
                    continue;
                }
                if (!actualType.hasAnnotation(poly) || (typeQual = type.getAnnotationInHierarchy(top)) == null) continue;
                result.put(poly, AnnotationMirrorSet.singleElementSet(typeQual));
            }
            return result;
        }

        @Override
        protected String defaultErrorMessage(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2, Void aVoid) {
            return String.format("AbstractQualifierPolymorphism: Unexpected combination: type1: %s (%s) type2: %s (%s).", new Object[]{type1, type1.getKind(), type2, type2.getKind()});
        }

        @Override
        public AnnotationMirrorMap<AnnotationMirrorSet> visitArray_Array(AnnotatedTypeMirror.AnnotatedArrayType type1, AnnotatedTypeMirror.AnnotatedArrayType type2, Void aVoid) {
            AnnotationMirrorMap<AnnotationMirrorSet> result = this.mapQualifierToPoly(type1, type2);
            return this.reduce(result, (AnnotationMirrorMap)super.visitArray_Array(type1, type2, aVoid));
        }

        @Override
        public AnnotationMirrorMap<AnnotationMirrorSet> visitDeclared_Array(AnnotatedTypeMirror.AnnotatedDeclaredType type1, AnnotatedTypeMirror.AnnotatedArrayType type2, Void aVoid) {
            return this.mapQualifierToPoly(type1, type2);
        }

        @Override
        public AnnotationMirrorMap<AnnotationMirrorSet> visitDeclared_Declared(AnnotatedTypeMirror.AnnotatedDeclaredType type1, AnnotatedTypeMirror.AnnotatedDeclaredType type2, Void aVoid) {
            if (this.visited(type2)) {
                return new AnnotationMirrorMap<AnnotationMirrorSet>();
            }
            AnnotationMirrorMap<AnnotationMirrorSet> result = this.mapQualifierToPoly(type1, type2);
            Iterator<AnnotatedTypeMirror> type2Args = type2.getTypeArguments().iterator();
            for (AnnotatedTypeMirror type1Arg : type1.getTypeArguments()) {
                AnnotatedTypeMirror type2Arg = type2Args.next();
                result = this.reduce(result, this.visit(type1Arg, type2Arg));
            }
            return result;
        }

        @Override
        public AnnotationMirrorMap<AnnotationMirrorSet> visitIntersection_Intersection(AnnotatedTypeMirror.AnnotatedIntersectionType type1, AnnotatedTypeMirror.AnnotatedIntersectionType type2, Void aVoid) {
            AnnotationMirrorMap<AnnotationMirrorSet> result = this.mapQualifierToPoly(type1, type2);
            return this.reduce(result, (AnnotationMirrorMap)super.visitIntersection_Intersection(type1, type2, aVoid));
        }

        @Override
        public AnnotationMirrorMap<AnnotationMirrorSet> visitNull_Null(AnnotatedTypeMirror.AnnotatedNullType type1, AnnotatedTypeMirror.AnnotatedNullType type2, Void aVoid) {
            return this.mapQualifierToPoly(type1, type2);
        }

        @Override
        public AnnotationMirrorMap<AnnotationMirrorSet> visitPrimitive_Primitive(AnnotatedTypeMirror.AnnotatedPrimitiveType type1, AnnotatedTypeMirror.AnnotatedPrimitiveType type2, Void aVoid) {
            return this.mapQualifierToPoly(type1, type2);
        }

        @Override
        public AnnotationMirrorMap<AnnotationMirrorSet> visitTypevar_Typevar(AnnotatedTypeMirror.AnnotatedTypeVariable type1, AnnotatedTypeMirror.AnnotatedTypeVariable type2, Void aVoid) {
            if (this.visited(type2)) {
                return new AnnotationMirrorMap<AnnotationMirrorSet>();
            }
            AnnotationMirrorMap<AnnotationMirrorSet> result = this.mapQualifierToPoly(type1, type2);
            return this.reduce(result, (AnnotationMirrorMap)super.visitTypevar_Typevar(type1, type2, aVoid));
        }

        @Override
        public AnnotationMirrorMap<AnnotationMirrorSet> visitUnion_Union(AnnotatedTypeMirror.AnnotatedUnionType type1, AnnotatedTypeMirror.AnnotatedUnionType type2, Void aVoid) {
            AnnotationMirrorMap<AnnotationMirrorSet> result = this.mapQualifierToPoly(type1, type2);
            return this.reduce(result, (AnnotationMirrorMap)super.visitUnion_Union(type1, type2, aVoid));
        }

        @Override
        public AnnotationMirrorMap<AnnotationMirrorSet> visitWildcard_Wildcard(AnnotatedTypeMirror.AnnotatedWildcardType type1, AnnotatedTypeMirror.AnnotatedWildcardType type2, Void aVoid) {
            if (this.visited(type2)) {
                return new AnnotationMirrorMap<AnnotationMirrorSet>();
            }
            AnnotationMirrorMap<AnnotationMirrorSet> result = this.mapQualifierToPoly(type1, type2);
            return this.reduce(result, (AnnotationMirrorMap)super.visitWildcard_Wildcard(type1, type2, aVoid));
        }

        public void reset() {
            this.visitedType2.clear();
            this.visited.clear();
        }
    }

    class Completer
    extends AnnotatedTypeScanner<Void, Void> {
        Completer() {
        }

        @Override
        protected Void scan(AnnotatedTypeMirror type, Void p) {
            for (Map.Entry<AnnotationMirror, AnnotationMirror> pqentry : AbstractQualifierPolymorphism.this.polyQuals.entrySet()) {
                AnnotationMirror top = pqentry.getValue();
                AnnotationMirror poly = pqentry.getKey();
                if (!type.hasAnnotation(poly)) continue;
                type.removeAnnotation(poly);
                if (top == null) {
                    type.addMissingAnnotations(AbstractQualifierPolymorphism.this.topQuals);
                    continue;
                }
                if (type.getKind() == TypeKind.TYPEVAR || type.getKind() == TypeKind.WILDCARD) continue;
                type.addAnnotation(top);
            }
            return (Void)super.scan(type, p);
        }
    }

    class Replacer
    extends AnnotatedTypeScanner<Void, AnnotationMirrorMap<AnnotationMirrorSet>> {
        Replacer() {
        }

        @Override
        public Void scan(AnnotatedTypeMirror type, AnnotationMirrorMap<AnnotationMirrorSet> replacements) {
            AbstractQualifierPolymorphism.this.replace(type, replacements);
            return (Void)super.scan(type, replacements);
        }
    }
}

