/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.source;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.checkerframework.framework.source.SourceChecker;
import org.checkerframework.javacutil.TreeUtils;

public abstract class SourceVisitor<R, P>
extends TreePathScanner<R, P> {
    protected final Trees trees;
    protected final Elements elements;
    protected final Types types;
    protected CompilationUnitTree root;
    public final List<Tree> treesWithSuppressWarnings;
    private final boolean warnUnneededSuppressions;
    Tree lastVisited;

    public SourceVisitor(SourceChecker checker) {
        ProcessingEnvironment env = checker.getProcessingEnvironment();
        this.trees = Trees.instance(env);
        this.elements = env.getElementUtils();
        this.types = env.getTypeUtils();
        this.treesWithSuppressWarnings = new ArrayList<Tree>();
        this.warnUnneededSuppressions = checker.hasOption("warnUnneededSuppressions");
    }

    public void setRoot(CompilationUnitTree root) {
        this.root = root;
    }

    public void visit(TreePath path) {
        this.lastVisited = path.getLeaf();
        this.scan(path, null);
    }

    @Override
    public R scan(Tree tree, P p) {
        this.lastVisited = tree;
        return super.scan(tree, p);
    }

    @Override
    public R visitClass(ClassTree classTree, P p) {
        this.storeSuppressWarningsAnno(classTree);
        return super.visitClass(classTree, p);
    }

    @Override
    public R visitVariable(VariableTree variableTree, P p) {
        this.storeSuppressWarningsAnno(variableTree);
        return super.visitVariable(variableTree, p);
    }

    @Override
    public R visitMethod(MethodTree node, P p) {
        this.storeSuppressWarningsAnno(node);
        return super.visitMethod(node, p);
    }

    private void storeSuppressWarningsAnno(Tree tree) {
        if (!this.warnUnneededSuppressions) {
            return;
        }
        Element elt = TreeUtils.elementFromTree(tree);
        if (elt.getAnnotation(SuppressWarnings.class) != null) {
            this.treesWithSuppressWarnings.add(tree);
        }
    }
}

