/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.Tree;
import org.checkerframework.dataflow.cfg.node.BinaryOperationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.dataflow.util.HashCodeUtils;

public class LeftShiftNode
extends BinaryOperationNode {
    public LeftShiftNode(BinaryTree tree, Node left, Node right) {
        super(tree, left, right);
        assert (tree.getKind() == Tree.Kind.LEFT_SHIFT);
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitLeftShift(this, p);
    }

    public String toString() {
        return "(" + this.getLeftOperand() + " << " + this.getRightOperand() + ")";
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof LeftShiftNode)) {
            return false;
        }
        LeftShiftNode other = (LeftShiftNode)obj;
        return this.getLeftOperand().equals(other.getLeftOperand()) && this.getRightOperand().equals(other.getRightOperand());
    }

    public int hashCode() {
        return HashCodeUtils.hash(this.getLeftOperand(), this.getRightOperand());
    }
}

