/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import java.util.Iterator;

public class GraphUtils {
    public static <D, N extends TarjanNode<D>> List<? extends List<? extends N>> tarjan(Iterable<? extends N> nodes) {
        Tarjan tarjan = new Tarjan();
        return tarjan.findSCC(nodes);
    }

    public static <D> String toDot(Iterable<? extends TarjanNode<D>> nodes, String name, String header) {
        StringBuilder buf = new StringBuilder();
        buf.append(String.format("digraph %s {\n", name));
        buf.append(String.format("label = \"%s\";\n", header));
        for (TarjanNode<D> n : nodes) {
            buf.append(String.format("%s [label = \"%s\"];\n", n.hashCode(), n.toString()));
        }
        for (TarjanNode<D> from : nodes) {
            for (DependencyKind dk : from.getSupportedDependencyKinds()) {
                for (TarjanNode<D> to : from.getDependenciesByKind(dk)) {
                    buf.append(String.format("%s -> %s [label = \" %s \" style = %s ];\n", from.hashCode(), to.hashCode(), from.getDependencyName(to, dk), dk.getDotStyle()));
                }
            }
        }
        buf.append("}\n");
        return buf.toString();
    }

    private static class Tarjan<D, N extends TarjanNode<D>> {
        int index = 0;
        ListBuffer<List<N>> sccs = new ListBuffer();
        ListBuffer<N> stack = new ListBuffer();

        private Tarjan() {
        }

        private List<? extends List<? extends N>> findSCC(Iterable<? extends N> nodes) {
            for (TarjanNode node : nodes) {
                if (node.index != -1) continue;
                this.findSCC(node);
            }
            return this.sccs.toList();
        }

        private void findSCC(N v) {
            this.visitNode(v);
            Iterator iterator = ((TarjanNode)v).getAllDependencies().iterator();
            while (iterator.hasNext()) {
                TarjanNode tn;
                TarjanNode n = tn = iterator.next();
                if (n.index == -1) {
                    this.findSCC(n);
                    ((TarjanNode)v).lowlink = Math.min(((TarjanNode)v).lowlink, n.lowlink);
                    continue;
                }
                if (!this.stack.contains(n)) continue;
                ((TarjanNode)v).lowlink = Math.min(((TarjanNode)v).lowlink, n.index);
            }
            if (((TarjanNode)v).lowlink == ((TarjanNode)v).index) {
                this.addSCC(v);
            }
        }

        private void visitNode(N n) {
            ((TarjanNode)n).index = this.index;
            ((TarjanNode)n).lowlink = this.index++;
            this.stack.prepend(n);
            ((TarjanNode)n).active = true;
        }

        private void addSCC(N v) {
            TarjanNode n;
            ListBuffer<TarjanNode> cycle = new ListBuffer<TarjanNode>();
            do {
                n = (TarjanNode)this.stack.remove();
                n.active = false;
                cycle.add(n);
            } while (n != v);
            this.sccs.add(cycle.toList());
        }
    }

    public static abstract class TarjanNode<D>
    extends Node<D>
    implements Comparable<TarjanNode<D>> {
        int index = -1;
        int lowlink;
        boolean active;

        public TarjanNode(D data) {
            super(data);
        }

        @Override
        public abstract Iterable<? extends TarjanNode<D>> getAllDependencies();

        public abstract Iterable<? extends TarjanNode<D>> getDependenciesByKind(DependencyKind var1);

        @Override
        public int compareTo(TarjanNode<D> o) {
            return this.index < o.index ? -1 : (this.index == o.index ? 0 : 1);
        }
    }

    public static abstract class Node<D> {
        public final D data;

        public Node(D data) {
            this.data = data;
        }

        public abstract DependencyKind[] getSupportedDependencyKinds();

        public abstract Iterable<? extends Node<D>> getAllDependencies();

        public abstract String getDependencyName(Node<D> var1, DependencyKind var2);

        public String toString() {
            return this.data.toString();
        }
    }

    public static interface DependencyKind {
        public String getDotStyle();
    }
}

