/*
 * Decompiled with CFR 0.152.
 */
package annotator.scanner;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;

public class CommonScanner
extends TreePathScanner<Void, Void> {
    public static boolean hasClassKind(Tree tree) {
        Tree.Kind kind = tree.getKind();
        return kind == Tree.Kind.CLASS || kind == Tree.Kind.INTERFACE || kind == Tree.Kind.ENUM || kind == Tree.Kind.ANNOTATION_TYPE;
    }

    public static TreePath findCountingContext(TreePath treePath) {
        while (treePath != null) {
            if (treePath.getLeaf().getKind() == Tree.Kind.METHOD || CommonScanner.isFieldInit(treePath) || CommonScanner.isInitBlock(treePath)) {
                return treePath;
            }
            treePath = treePath.getParentPath();
        }
        return treePath;
    }

    public static TreePath findEnclosingClass(TreePath treePath) {
        while (!CommonScanner.hasClassKind(treePath.getLeaf()) || treePath.getParentPath().getLeaf().getKind() == Tree.Kind.NEW_CLASS) {
            if ((treePath = treePath.getParentPath()) != null) continue;
            return null;
        }
        return treePath;
    }

    public static TreePath findEnclosingMethod(TreePath treePath) {
        while (treePath.getLeaf().getKind() != Tree.Kind.METHOD) {
            if ((treePath = treePath.getParentPath()) != null) continue;
            return null;
        }
        return treePath;
    }

    public static boolean isFieldInit(TreePath treePath) {
        return treePath.getLeaf().getKind() == Tree.Kind.VARIABLE && treePath.getParentPath() != null && CommonScanner.hasClassKind(treePath.getParentPath().getLeaf());
    }

    public static TreePath findEnclosingFieldInit(TreePath treePath) {
        while (!CommonScanner.isFieldInit(treePath)) {
            if ((treePath = treePath.getParentPath()) != null) continue;
            return null;
        }
        return treePath;
    }

    public static boolean isInitBlock(TreePath treePath, boolean bl) {
        return CommonScanner.isInitBlock(treePath) && ((BlockTree)treePath.getLeaf()).isStatic() == bl;
    }

    public static boolean isInitBlock(TreePath treePath) {
        return treePath.getParentPath() != null && CommonScanner.hasClassKind(treePath.getParentPath().getLeaf()) && treePath.getLeaf().getKind() == Tree.Kind.BLOCK;
    }

    public static TreePath findEnclosingInitBlock(TreePath treePath, boolean bl) {
        while (!CommonScanner.isInitBlock(treePath, bl)) {
            if ((treePath = treePath.getParentPath()) != null) continue;
            return null;
        }
        return treePath;
    }

    public static boolean isStaticInit(TreePath treePath) {
        return CommonScanner.isInitBlock(treePath, true);
    }

    public static TreePath findEnclosingStaticInit(TreePath treePath) {
        while (!CommonScanner.isStaticInit(treePath)) {
            if ((treePath = treePath.getParentPath()) != null) continue;
            return null;
        }
        return treePath;
    }

    public static boolean isInstanceInit(TreePath treePath) {
        return CommonScanner.isInitBlock(treePath, false);
    }

    public static TreePath findEnclosingInstanceInit(TreePath treePath) {
        while (!CommonScanner.isInstanceInit(treePath)) {
            if ((treePath = treePath.getParentPath()) != null) continue;
            return null;
        }
        return treePath;
    }

    @Override
    public Void visitClass(ClassTree classTree, Void void_) {
        return void_;
    }
}

