/*
 * Decompiled with CFR 0.152.
 */
package annotator.scanner;

import annotator.scanner.CommonScanner;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CastScanner
extends CommonScanner {
    private int index = -1;
    private boolean done = false;
    private final Tree tree;
    private static String prevMethodName = null;
    private static int prevOffset = -1;
    private static int nestLevels = 0;
    private static Map<String, List<Integer>> methodNameToCastOffsets = new HashMap<String, List<Integer>>();

    public static int indexOfCastTree(TreePath treePath, Tree tree) {
        TreePath treePath2 = CastScanner.findCountingContext(treePath);
        if (treePath2 == null) {
            return -1;
        }
        CastScanner castScanner = new CastScanner(tree);
        castScanner.scan(treePath2, null);
        return castScanner.index;
    }

    private CastScanner(Tree tree) {
        this.tree = tree;
    }

    @Override
    public Void visitTypeCast(TypeCastTree typeCastTree, Void void_) {
        if (!this.done) {
            ++this.index;
        }
        if (this.tree == typeCastTree) {
            this.done = true;
            return void_;
        }
        return (Void)super.visitTypeCast(typeCastTree, void_);
    }

    public static void addCastToMethod(String string, Integer n) {
        List<Integer> list = methodNameToCastOffsets.get(string);
        if (list == null) {
            list = new ArrayList<Integer>();
            methodNameToCastOffsets.put(string, list);
        }
        if (string.equals(prevMethodName) && n - prevOffset == 3) {
            list.add(list.size() - ++nestLevels, n);
        } else {
            nestLevels = 0;
            list.add(n);
        }
        prevMethodName = string;
        prevOffset = n;
    }

    public static Integer getMethodCastIndex(String string, Integer n) {
        List<Integer> list = methodNameToCastOffsets.get(string);
        if (list == null) {
            return -1;
        }
        return list.indexOf(n);
    }
}

