/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criterion;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.tree.JCTree;
import java.util.List;
import scenelib.annotations.el.RelativeLocation;

public class TypeArgumentCriterion
implements Criterion {
    private final String methodName;
    private final RelativeLocation loc;

    public TypeArgumentCriterion(String string, RelativeLocation relativeLocation) {
        this.methodName = string;
        this.loc = relativeLocation;
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath, Tree tree) {
        if (treePath == null) {
            return false;
        }
        assert (treePath.getLeaf() == tree);
        return this.isSatisfiedBy(treePath);
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath) {
        List list;
        if (treePath == null || treePath.getParentPath() == null) {
            return false;
        }
        TreePath treePath2 = treePath.getParentPath();
        Tree tree = treePath2.getLeaf();
        switch (tree.getKind()) {
            case MEMBER_REFERENCE: {
                list = ((JCTree.JCMemberReference)tree).getTypeArguments();
                break;
            }
            case METHOD_INVOCATION: {
                list = ((JCTree.JCMethodInvocation)tree).getTypeArguments();
                break;
            }
            default: {
                return this.isSatisfiedBy(treePath2);
            }
        }
        return list != null && this.loc.index >= 0 && this.loc.index < list.size() && list.get(this.loc.index) == treePath.getLeaf();
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.TYPE_ARGUMENT;
    }

    public String toString() {
        return "TypeArgumentCriterion: in method: " + this.methodName + " location: " + this.loc;
    }
}

