/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criterion;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import scenelib.annotations.io.ASTPath;

final class NotInMethodCriterion
implements Criterion {
    NotInMethodCriterion() {
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.NOT_IN_METHOD;
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath, Tree tree) {
        if (treePath == null) {
            return false;
        }
        assert (treePath.getLeaf() == tree);
        return this.isSatisfiedBy(treePath);
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath) {
        do {
            Tree.Kind kind;
            if ((kind = treePath.getLeaf().getKind()) == Tree.Kind.METHOD) {
                return false;
            }
            if (!ASTPath.isClassEquiv(kind)) continue;
            return true;
        } while ((treePath = treePath.getParentPath()) != null && treePath.getLeaf() != null);
        return true;
    }

    public String toString() {
        return "not in method";
    }
}

