/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criterion;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.util.List;
import scenelib.annotations.el.BoundLocation;

public class BoundLocationCriterion
implements Criterion {
    private Criterion parentCriterion;
    private final int boundIndex;
    private final int paramIndex;

    public BoundLocationCriterion(BoundLocation boundLocation) {
        this(boundLocation.boundIndex, boundLocation.paramIndex);
    }

    private BoundLocationCriterion(int n, int n2) {
        this.boundIndex = n;
        this.paramIndex = n2;
        if (n != -1) {
            this.parentCriterion = new BoundLocationCriterion(-1, n2);
        } else if (n2 != -1) {
            this.parentCriterion = null;
        }
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath, Tree tree) {
        if (treePath == null) {
            return false;
        }
        assert (treePath.getLeaf() == tree);
        return this.isSatisfiedBy(treePath);
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        Tree tree = treePath.getLeaf();
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 == null) {
            return false;
        }
        Tree tree2 = treePath2.getLeaf();
        if (tree2 == null) {
            return false;
        }
        boolean bl = false;
        if (this.boundIndex != -1) {
            if (tree2 instanceof TypeParameterTree) {
                List<? extends Tree> list = ((TypeParameterTree)tree2).getBounds();
                int n = this.boundIndex;
                if (!list.isEmpty() && this.isInterface((JCTree.JCExpression)list.get(0))) {
                    --n;
                }
                if (n < 0 || n < list.size() && list.get(n) == tree) {
                    bl = this.parentCriterion.isSatisfiedBy(treePath2);
                }
            } else if (this.boundIndex == 0 && tree instanceof TypeParameterTree) {
                List<? extends Tree> list = ((TypeParameterTree)tree).getBounds();
                if (list.isEmpty() || this.isInterface((JCTree.JCExpression)list.get(0))) {
                    bl = this.parentCriterion.isSatisfiedBy(treePath);
                } else {
                    Type type = ((JCTree.JCExpression)list.get((int)0)).type;
                    if (type != null && type.tsym != null && type.tsym.isInterface()) {
                        bl = this.parentCriterion.isSatisfiedBy(treePath2);
                    }
                }
            }
        } else if (this.paramIndex != -1 && (tree2 instanceof MethodTree || tree2 instanceof ClassTree)) {
            List<? extends TypeParameterTree> list = null;
            if (tree2 instanceof MethodTree) {
                list = ((MethodTree)tree2).getTypeParameters();
            } else if (tree2 instanceof ClassTree) {
                list = ((ClassTree)tree2).getTypeParameters();
            }
            if (this.paramIndex < list.size() && list.get(this.paramIndex) == tree) {
                bl = true;
            }
        }
        if (!bl) {
            return this.isSatisfiedBy(treePath2);
        }
        return true;
    }

    private boolean isInterface(JCTree.JCExpression jCExpression) {
        Type type = jCExpression.type;
        return type != null && type.tsym != null && type.tsym.isInterface();
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.BOUND_LOCATION;
    }

    public String toString() {
        return "BoundCriterion: at param index: " + this.paramIndex + " at bound index: " + this.boundIndex;
    }
}

