/*
 * Decompiled with CFR 0.152.
 */
package scenelib.annotations.io;

import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.org.plumelib.util.FileIOException;
import scenelib.annotations.Annotation;
import scenelib.annotations.AnnotationBuilder;
import scenelib.annotations.AnnotationFactory;
import scenelib.annotations.Annotations;
import scenelib.annotations.el.AClass;
import scenelib.annotations.el.AElement;
import scenelib.annotations.el.AMethod;
import scenelib.annotations.el.AScene;
import scenelib.annotations.el.ATypeElement;
import scenelib.annotations.el.InnerTypeLocation;
import scenelib.annotations.el.LocalLocation;
import scenelib.annotations.el.RelativeLocation;
import scenelib.annotations.io.IOUtils;
import scenelib.annotations.io.ParseException;

public final class JavapParser {
    private static final String SECTION_TITLE_PREFIX = "  ";
    private static final String SECTION_DATA_PREFIX = "   ";
    private static final String CONST_POOL_DATA_PREFIX = "const #";
    private final AScene scene;
    private final BufferedReader bin;
    private String line;
    private int lineNo = 0;
    private static final String annotationHead = "//Annotation L";
    private static final String tagHead = "type = ";
    private static final String paramIdxHead = "parameter = ";
    private static final String offsetHead = "offset = ";
    private static final String typeIndexHead = "type_index = ";
    private static final Pattern localLocRegex = Pattern.compile("^\\s*start_pc = (\\d+), length = (\\d+), index = (\\d+)$");
    private static final String itlnHead = "location = ";

    private void nextLine() throws IOException {
        do {
            this.line = this.bin.readLine();
            ++this.lineNo;
        } while (this.line != null && this.line.equals(""));
    }

    private void trim(String prefix) {
        if (this.line.startsWith(prefix)) {
            this.line = this.line.substring(prefix.length());
        }
    }

    private boolean inMember() {
        return this.line.startsWith(SECTION_TITLE_PREFIX);
    }

    private boolean inData() {
        return this.line.startsWith(SECTION_DATA_PREFIX) || this.line.startsWith(CONST_POOL_DATA_PREFIX);
    }

    private String parseAnnotationHead() throws IOException, ParseException {
        String annoTypeName = this.line.substring(this.line.indexOf(annotationHead) + annotationHead.length(), this.line.length() - 1).replace('/', '.');
        this.nextLine();
        return annoTypeName;
    }

    private Annotation parseAnnotationBody(AnnotationBuilder ab, String indent) throws IOException, ParseException {
        String line2;
        String fieldIndent = indent + " ";
        while (this.line.startsWith(fieldIndent) && !(line2 = this.line.substring(fieldIndent.length())).startsWith("target") && !line2.startsWith("parameter")) {
            String fieldName = line2.substring(line2.indexOf("//") + "//".length());
            this.nextLine();
            char tag = this.line.charAt(this.line.indexOf(tagHead) + tagHead.length());
            switch (tag) {
                case '[': {
                    break;
                }
                case '@': {
                    break;
                }
                case 'c': {
                    break;
                }
            }
        }
        return ab.finish();
    }

    private int parseOffset() throws IOException, ParseException {
        int offset = Integer.parseInt(this.line.substring(this.line.indexOf(offsetHead) + offsetHead.length()));
        this.nextLine();
        return offset;
    }

    private int parseTypeIndex() throws IOException, ParseException {
        int typeIndex = Integer.parseInt(this.line.substring(this.line.indexOf(typeIndexHead) + typeIndexHead.length()));
        this.nextLine();
        return typeIndex;
    }

    private List<Integer> parseInnerTypeLocationNums() throws IOException, ParseException {
        String numsStr = this.line.substring(this.line.indexOf(itlnHead) + itlnHead.length());
        ArrayList<Integer> nums = new ArrayList<Integer>();
        while (true) {
            int comma;
            if ((comma = numsStr.indexOf(44)) == -1) break;
            nums.add(Integer.parseInt(numsStr.substring(0, comma)));
            numsStr = numsStr.substring(comma + 2);
        }
        nums.add(Integer.parseInt(numsStr));
        this.nextLine();
        return nums;
    }

    private AElement chooseSubElement(AElement member, AnnotationSection sec) throws IOException, ParseException {
        switch (sec.locMode) {
            case ORIGINAL: {
                return member;
            }
            case PARAMETER: {
                int paramIdx = Integer.parseInt(this.line.substring(this.line.indexOf(paramIdxHead) + paramIdxHead.length()));
                this.nextLine();
                return ((AMethod)member).parameters.vivify(paramIdx);
            }
            case EXTENDED: {
                ATypeElement subOuterType;
                String targetTypeName = this.line.substring(this.line.indexOf("//") + "//".length());
                TargetType tt = TargetType.valueOf(targetTypeName);
                if (tt == null) {
                    throw new RuntimeException("null target type");
                }
                TargetType targetType = tt;
                this.nextLine();
                switch (targetType) {
                    case FIELD: 
                    case METHOD_RETURN: {
                        subOuterType = (ATypeElement)member;
                        break;
                    }
                    case METHOD_RECEIVER: {
                        subOuterType = ((AMethod)member).receiver.type;
                        break;
                    }
                    case METHOD_FORMAL_PARAMETER: {
                        int paramIdx = Integer.parseInt(this.line.substring(this.line.indexOf(paramIdxHead) + paramIdxHead.length()));
                        this.nextLine();
                        subOuterType = ((AMethod)member).parameters.vivify((Integer)Integer.valueOf((int)paramIdx)).type;
                        break;
                    }
                    case LOCAL_VARIABLE: 
                    case RESOURCE_VARIABLE: {
                        Matcher m3 = localLocRegex.matcher(this.line);
                        m3.matches();
                        int index = Integer.parseInt(m3.group(1));
                        int scopeStart = Integer.parseInt(m3.group(2));
                        int scopeLength = Integer.parseInt(m3.group(3));
                        LocalLocation ll = new LocalLocation(index, scopeStart, scopeLength);
                        this.nextLine();
                        subOuterType = ((AMethod)member).body.locals.vivify((LocalLocation)ll).type;
                        break;
                    }
                    case CAST: {
                        int offset = this.parseOffset();
                        int typeIndex = this.parseTypeIndex();
                        subOuterType = (ATypeElement)((AMethod)member).body.typecasts.vivify(RelativeLocation.createOffset(offset, typeIndex));
                        break;
                    }
                    case INSTANCEOF: {
                        int offset = this.parseOffset();
                        subOuterType = (ATypeElement)((AMethod)member).body.instanceofs.vivify(RelativeLocation.createOffset(offset, 0));
                        break;
                    }
                    case NEW: {
                        int offset = this.parseOffset();
                        subOuterType = (ATypeElement)((AMethod)member).body.news.vivify(RelativeLocation.createOffset(offset, 0));
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                List<Integer> location = this.parseInnerTypeLocationNums();
                InnerTypeLocation itl = new InnerTypeLocation(TypeAnnotationPosition.getTypePathFromBinary(location));
                AElement subElement = subOuterType.innerTypes.vivify(itl);
                return subElement;
            }
        }
        throw new AssertionError();
    }

    private void parseAnnotationSection(AElement member, AnnotationSection sec) throws IOException, ParseException {
        while (this.inData()) {
            RetentionPolicy retention;
            String annoTypeName = this.parseAnnotationHead();
            AnnotationBuilder ab = AnnotationFactory.saf.beginAnnotation(annoTypeName, Annotations.getRetentionPolicyMetaAnnotationSet(retention = sec.retention));
            if (ab == null) {
                this.parseAnnotationBody(AnnotationFactory.saf.beginAnnotation(annoTypeName, Annotations.noAnnotations), SECTION_DATA_PREFIX);
                continue;
            }
            Annotation a = this.parseAnnotationBody(ab, SECTION_DATA_PREFIX);
            AElement annoMember = this.chooseSubElement(member, sec);
            annoMember.tlAnnotationsHere.add(a);
        }
    }

    private void parseMember(AElement member) throws IOException, ParseException {
        while (this.inMember()) {
            String secTitle = this.line.substring(2, this.line.indexOf(58));
            AnnotationSection sec0 = null;
            for (AnnotationSection s2 : AnnotationSection.values()) {
                if (!s2.secTitle.equals(secTitle)) continue;
                sec0 = s2;
            }
            if (sec0 != null) {
                AnnotationSection sec = sec0;
                this.nextLine();
                System.out.println("Got section " + secTitle);
                this.parseAnnotationSection(member, sec);
                continue;
            }
            System.out.println("Got unrecognized section " + secTitle);
            this.nextLine();
            while (this.inData()) {
                this.nextLine();
            }
        }
    }

    private void parseMethodBody(AElement clazz, String methodName) throws IOException, ParseException {
        String sig = this.line.substring("  Signature: ".length());
        this.nextLine();
        String methodKey = methodName + sig;
        System.out.println("Got method " + methodKey);
        this.parseMember(((AClass)clazz).methods.vivify(methodKey));
    }

    private void parseClass(AElement clazz) throws IOException, ParseException {
        this.parseMember(clazz);
        this.nextLine();
        while (!this.line.equals("}")) {
            int space;
            if (this.line.indexOf("static {}") >= 0) {
                this.nextLine();
                this.parseMethodBody(clazz, "<clinit>");
                continue;
            }
            int lparen = this.line.indexOf(40);
            if (lparen == -1) {
                space = this.line.lastIndexOf(32);
                String fieldName = this.line.substring(space + 1, this.line.length() - 1);
                this.nextLine();
                System.out.println("Got field " + fieldName);
                this.parseMember(((AClass)clazz).fields.vivify(fieldName));
                continue;
            }
            space = this.line.lastIndexOf(32, lparen);
            String methodName = this.line.substring(space + 1, lparen);
            this.nextLine();
            this.parseMethodBody(clazz, methodName);
        }
        this.nextLine();
    }

    private void parse() throws IOException, ParseException {
        try {
            this.nextLine();
            while (this.line != null) {
                this.nextLine();
                this.trim("public ");
                this.trim("protected ");
                this.trim("private ");
                this.trim("abstract ");
                this.trim("final ");
                this.trim("class ");
                this.trim("interface ");
                int nameEnd = this.line.indexOf(32);
                String className = nameEnd == -1 ? this.line : this.line.substring(0, this.line.indexOf(32));
                String pp = IOUtils.packagePart(className);
                String bp = IOUtils.basenamePart(className);
                this.nextLine();
                if (bp.equals("package-info")) {
                    this.parseClass(this.scene.packages.vivify(pp));
                    continue;
                }
                this.parseClass(this.scene.classes.vivify(className));
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Line " + this.lineNo, e);
        }
    }

    private JavapParser(Reader in, AScene scene) {
        this.bin = new BufferedReader(in);
        this.scene = scene;
    }

    public static void parse(Reader in, AScene scene) throws IOException, ParseException {
        new JavapParser(in, scene).parse();
    }

    public static void parse(String filename, AScene scene) throws IOException, FileIOException {
        LineNumberReader lnr = new LineNumberReader(new FileReader(filename));
        try {
            JavapParser.parse(lnr, scene);
        }
        catch (ParseException e) {
            throw new FileIOException(lnr, filename, (Throwable)e);
        }
    }

    private static enum AnnotationSection {
        RVA("RuntimeVisibleAnnotations", RetentionPolicy.RUNTIME, TargetMode.ORIGINAL),
        RIA("RuntimeInvisibleAnnotations", RetentionPolicy.CLASS, TargetMode.ORIGINAL),
        RVPA("RuntimeVisibleParameterAnnotations", RetentionPolicy.RUNTIME, TargetMode.PARAMETER),
        RIPA("RuntimeInvisibleParameterAnnotations", RetentionPolicy.CLASS, TargetMode.PARAMETER),
        RVEA("RuntimeVisibleTypeAnnotations", RetentionPolicy.RUNTIME, TargetMode.EXTENDED),
        RIEA("RuntimeInvisibleTypeAnnotations", RetentionPolicy.CLASS, TargetMode.EXTENDED);

        final String secTitle;
        final RetentionPolicy retention;
        final TargetMode locMode;

        private AnnotationSection(String secTitle, RetentionPolicy retention, TargetMode locMode) {
            this.secTitle = secTitle;
            this.retention = retention;
            this.locMode = locMode;
        }
    }

    private static enum TargetMode {
        ORIGINAL,
        PARAMETER,
        EXTENDED;

    }
}

