/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.visitor.AbstractAtmComboVisitor;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.javacutil.BugInCF;
import org.checkerframework.javacutil.TypesUtils;

class AtmLubVisitor
extends AbstractAtmComboVisitor<Void, AnnotatedTypeMirror> {
    private final AnnotatedTypeFactory atypeFactory;
    private final QualifierHierarchy qualifierHierarchy;
    private final List<AnnotatedTypeMirror> visited = new ArrayList<AnnotatedTypeMirror>();

    AtmLubVisitor(AnnotatedTypeFactory atypeFactory) {
        this.atypeFactory = atypeFactory;
        this.qualifierHierarchy = atypeFactory.getQualifierHierarchy();
    }

    AnnotatedTypeMirror lub(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2, TypeMirror lubJavaType) {
        AnnotatedTypeMirror lub = AnnotatedTypeMirror.createType(lubJavaType, this.atypeFactory, false);
        if (type1.getKind() == TypeKind.NULL) {
            return this.lubWithNull((AnnotatedTypeMirror.AnnotatedNullType)type1, type2, lub);
        }
        if (type2.getKind() == TypeKind.NULL) {
            return this.lubWithNull((AnnotatedTypeMirror.AnnotatedNullType)type2, type1, lub);
        }
        AnnotatedTypeMirror type1AsLub = AnnotatedTypes.asSuper(this.atypeFactory, type1, lub);
        AnnotatedTypeMirror type2AsLub = AnnotatedTypes.asSuper(this.atypeFactory, type2, lub);
        this.visit(type1AsLub, type2AsLub, lub);
        this.visited.clear();
        return lub;
    }

    private AnnotatedTypeMirror lubWithNull(AnnotatedTypeMirror.AnnotatedNullType nullType, AnnotatedTypeMirror otherType, AnnotatedTypeMirror lub) {
        AnnotatedTypeMirror otherAsLub = otherType.getKind() == TypeKind.NULL ? otherType.deepCopy() : AnnotatedTypes.asSuper(this.atypeFactory, otherType, lub);
        lub = otherAsLub.deepCopy();
        if (otherAsLub.getKind() != TypeKind.TYPEVAR && otherAsLub.getKind() != TypeKind.WILDCARD) {
            for (AnnotationMirror nullAnno : nullType.getAnnotations()) {
                AnnotationMirror otherAnno = otherAsLub.getAnnotationInHierarchy(nullAnno);
                AnnotationMirror lubAnno = this.qualifierHierarchy.leastUpperBound(nullAnno, otherAnno);
                lub.replaceAnnotation(lubAnno);
            }
            return lub;
        }
        Set<AnnotationMirror> lowerBounds = AnnotatedTypes.findEffectiveLowerBoundAnnotations(this.qualifierHierarchy, otherAsLub);
        for (AnnotationMirror lowerBound : lowerBounds) {
            AnnotationMirror nullAnno = nullType.getAnnotationInHierarchy(lowerBound);
            AnnotationMirror upperBound = otherAsLub.getEffectiveAnnotationInHierarchy(lowerBound);
            if (this.qualifierHierarchy.isSubtype(upperBound, nullAnno)) {
                lub.replaceAnnotation(nullAnno);
                continue;
            }
            if (!this.qualifierHierarchy.isSubtype(lowerBound, nullAnno) || this.qualifierHierarchy.isSubtype(nullAnno, lowerBound)) continue;
            lub.replaceAnnotation(upperBound);
        }
        return lub;
    }

    private void lubPrimaryAnnotations(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2, AnnotatedTypeMirror lub) {
        Set<AnnotationMirror> lubSet = type1.getAnnotations().isEmpty() ? type2.getAnnotations() : (type2.getAnnotations().isEmpty() ? type1.getAnnotations() : this.qualifierHierarchy.leastUpperBounds(type1.getAnnotations(), type2.getAnnotations()));
        lub.replaceAnnotations(lubSet);
    }

    private <T extends AnnotatedTypeMirror> T castLub(T type, AnnotatedTypeMirror lub) {
        if (type.getKind() != lub.getKind()) {
            throw new BugInCF("AtmLubVisitor: unexpected type. Found: %s Required %s", new Object[]{lub.getKind(), type.getKind()});
        }
        AnnotatedTypeMirror castedLub = lub;
        return (T)castedLub;
    }

    @Override
    public Void visitNull_Null(AnnotatedTypeMirror.AnnotatedNullType type1, AnnotatedTypeMirror.AnnotatedNullType type2, AnnotatedTypeMirror lub) {
        this.castLub(type1, lub);
        this.lubPrimaryAnnotations(type1, type2, lub);
        return null;
    }

    @Override
    public Void visitArray_Array(AnnotatedTypeMirror.AnnotatedArrayType type1, AnnotatedTypeMirror.AnnotatedArrayType type2, AnnotatedTypeMirror lub) {
        AnnotatedTypeMirror.AnnotatedArrayType lubArray = this.castLub(type1, lub);
        this.lubPrimaryAnnotations(type1, type2, lubArray);
        this.visit(type1.getComponentType(), type2.getComponentType(), lubArray.getComponentType());
        return null;
    }

    @Override
    public Void visitDeclared_Declared(AnnotatedTypeMirror.AnnotatedDeclaredType type1, AnnotatedTypeMirror.AnnotatedDeclaredType type2, AnnotatedTypeMirror lub) {
        AnnotatedTypeMirror.AnnotatedDeclaredType castedLub = this.castLub(type1, lub);
        this.lubPrimaryAnnotations(type1, type2, lub);
        ArrayList lubTypArgs = new ArrayList();
        for (int i = 0; i < type1.getTypeArguments().size(); ++i) {
            AnnotatedTypeMirror type1TypeArg = type1.getTypeArguments().get(i);
            AnnotatedTypeMirror type2TypeArg = type2.getTypeArguments().get(i);
            AnnotatedTypeMirror lubTypeArg = castedLub.getTypeArguments().get(i);
            this.lubTypeArgument(type1TypeArg, type2TypeArg, lubTypeArg);
        }
        if (lubTypArgs.size() > 0) {
            castedLub.setTypeArguments(lubTypArgs);
        }
        return null;
    }

    private void lubTypeArgument(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2, AnnotatedTypeMirror lub) {
        AnnotatedTypeMirror type1AsLub = AnnotatedTypes.asSuper(this.atypeFactory, type1, lub);
        AnnotatedTypeMirror type2AsLub = AnnotatedTypes.asSuper(this.atypeFactory, type2, lub);
        if (lub.getKind() == TypeKind.WILDCARD) {
            if (this.visited(lub)) {
                return;
            }
            AnnotatedTypeMirror.AnnotatedWildcardType type1Wildcard = (AnnotatedTypeMirror.AnnotatedWildcardType)type1AsLub;
            AnnotatedTypeMirror.AnnotatedWildcardType type2Wildcard = (AnnotatedTypeMirror.AnnotatedWildcardType)type2AsLub;
            AnnotatedTypeMirror.AnnotatedWildcardType lubWildcard = (AnnotatedTypeMirror.AnnotatedWildcardType)lub;
            if (type1Wildcard.isUninferredTypeArgument() || type2Wildcard.isUninferredTypeArgument()) {
                lubWildcard.setUninferredTypeArgument();
            }
            this.lubWildcard(type1Wildcard.getSuperBound(), type1Wildcard.getExtendsBound(), type2Wildcard.getSuperBound(), type2Wildcard.getExtendsBound(), lubWildcard.getSuperBound(), lubWildcard.getExtendsBound());
        } else if (lub.getKind() == TypeKind.TYPEVAR && TypesUtils.isCaptured((TypeVariable)lub.getUnderlyingType())) {
            if (this.visited(lub)) {
                return;
            }
            AnnotatedTypeMirror.AnnotatedTypeVariable type1typevar = (AnnotatedTypeMirror.AnnotatedTypeVariable)type1AsLub;
            AnnotatedTypeMirror.AnnotatedTypeVariable type2typevar = (AnnotatedTypeMirror.AnnotatedTypeVariable)type2AsLub;
            AnnotatedTypeMirror.AnnotatedTypeVariable lubTypevar = (AnnotatedTypeMirror.AnnotatedTypeVariable)lub;
            this.lubWildcard(type1typevar.getLowerBound(), type1typevar.getUpperBound(), type2typevar.getLowerBound(), type2typevar.getUpperBound(), lubTypevar.getLowerBound(), lubTypevar.getUpperBound());
        } else {
            this.visit(type1AsLub, type2AsLub, lub);
        }
    }

    private void lubWildcard(AnnotatedTypeMirror type1LowerBound, AnnotatedTypeMirror type1UpperBound, AnnotatedTypeMirror type2LowerBound, AnnotatedTypeMirror type2UpperBound, AnnotatedTypeMirror lubLowerBound, AnnotatedTypeMirror lubUpperBound) {
        this.visit(type1UpperBound, type2UpperBound, lubUpperBound);
        this.visit(type1LowerBound, type2LowerBound, lubLowerBound);
        for (AnnotationMirror annotationMirror : this.qualifierHierarchy.getTopAnnotations()) {
            AnnotationMirror glb = this.qualifierHierarchy.greatestLowerBound(type1LowerBound, type2LowerBound, type1LowerBound.getAnnotationInHierarchy(annotationMirror), type2LowerBound.getAnnotationInHierarchy(annotationMirror));
            if (glb == null) continue;
            lubLowerBound.replaceAnnotation(glb);
        }
    }

    @Override
    public Void visitPrimitive_Primitive(AnnotatedTypeMirror.AnnotatedPrimitiveType type1, AnnotatedTypeMirror.AnnotatedPrimitiveType type2, AnnotatedTypeMirror lub) {
        this.castLub(type1, lub);
        this.lubPrimaryAnnotations(type1, type2, lub);
        return null;
    }

    @Override
    public Void visitTypevar_Typevar(AnnotatedTypeMirror.AnnotatedTypeVariable type1, AnnotatedTypeMirror.AnnotatedTypeVariable type2, AnnotatedTypeMirror lub1) {
        if (this.visited(lub1)) {
            return null;
        }
        AnnotatedTypeMirror.AnnotatedTypeVariable lub = this.castLub(type1, lub1);
        this.visit(type1.getUpperBound(), type2.getUpperBound(), lub.getUpperBound());
        this.visit(type1.getLowerBound(), type2.getLowerBound(), lub.getLowerBound());
        this.lubPrimaryOnBoundedType(type1, type2, lub);
        return null;
    }

    @Override
    public Void visitWildcard_Wildcard(AnnotatedTypeMirror.AnnotatedWildcardType type1, AnnotatedTypeMirror.AnnotatedWildcardType type2, AnnotatedTypeMirror lub1) {
        if (this.visited(lub1)) {
            return null;
        }
        AnnotatedTypeMirror.AnnotatedWildcardType lub = this.castLub(type1, lub1);
        this.visit(type1.getExtendsBound(), type2.getExtendsBound(), lub.getExtendsBound());
        this.visit(type1.getSuperBound(), type2.getSuperBound(), lub.getSuperBound());
        this.lubPrimaryOnBoundedType(type1, type2, lub);
        return null;
    }

    private void lubPrimaryOnBoundedType(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2, AnnotatedTypeMirror lub) {
        Set<AnnotationMirror> type1LowerBoundAnnos = AnnotatedTypes.findEffectiveLowerBoundAnnotations(this.qualifierHierarchy, type1);
        Set<AnnotationMirror> type2LowerBoundAnnos = AnnotatedTypes.findEffectiveLowerBoundAnnotations(this.qualifierHierarchy, type2);
        for (AnnotationMirror lower1 : type1LowerBoundAnnos) {
            AnnotationMirror top = this.qualifierHierarchy.getTopAnnotation(lower1);
            AnnotationMirror lower2 = this.qualifierHierarchy.findAnnotationInHierarchy(type2LowerBoundAnnos, top);
            AnnotationMirror upper1 = type1.getEffectiveAnnotationInHierarchy(lower1);
            AnnotationMirror upper2 = type2.getEffectiveAnnotationInHierarchy(lower1);
            if (this.qualifierHierarchy.isSubtype(upper2, upper1) && this.qualifierHierarchy.isSubtype(upper1, upper2) && this.qualifierHierarchy.isSubtype(lower1, lower2) && this.qualifierHierarchy.isSubtype(lower2, lower1) || this.qualifierHierarchy.isSubtype(upper2, lower1) || this.qualifierHierarchy.isSubtype(upper1, lower2)) continue;
            lub.replaceAnnotation(this.qualifierHierarchy.leastUpperBound(upper1, upper2));
        }
    }

    @Override
    public Void visitIntersection_Intersection(AnnotatedTypeMirror.AnnotatedIntersectionType type1, AnnotatedTypeMirror.AnnotatedIntersectionType type2, AnnotatedTypeMirror lub) {
        AnnotatedTypeMirror.AnnotatedIntersectionType castedLub = this.castLub(type1, lub);
        this.lubPrimaryAnnotations(type1, type2, lub);
        for (int i = 0; i < lub.directSuperTypes().size(); ++i) {
            AnnotatedTypeMirror.AnnotatedDeclaredType lubST = castedLub.directSuperTypes().get(i);
            this.visit(type1.directSuperTypes().get(i), type2.directSuperTypes().get(i), lubST);
        }
        return null;
    }

    @Override
    public Void visitUnion_Union(AnnotatedTypeMirror.AnnotatedUnionType type1, AnnotatedTypeMirror.AnnotatedUnionType type2, AnnotatedTypeMirror lub) {
        AnnotatedTypeMirror.AnnotatedUnionType castedLub = this.castLub(type1, lub);
        this.lubPrimaryAnnotations(type1, type2, lub);
        for (int i = 0; i < castedLub.getAlternatives().size(); ++i) {
            AnnotatedTypeMirror.AnnotatedDeclaredType lubAltern = castedLub.getAlternatives().get(i);
            this.visit(type1.getAlternatives().get(i), type2.getAlternatives().get(i), lubAltern);
        }
        return null;
    }

    @Override
    protected String defaultErrorMessage(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2, AnnotatedTypeMirror lub) {
        return String.format("AtmLubVisitor: Unexpected combination: type1: %s type2: %s.\ntype1: %s\ntype2: %s\nlub: %s", new Object[]{type1.getKind(), type2.getKind(), type1, type2, lub});
    }

    private boolean visited(AnnotatedTypeMirror atm) {
        for (AnnotatedTypeMirror atmVisit : this.visited) {
            if (atmVisit != atm) continue;
            return true;
        }
        this.visited.add(atm);
        return false;
    }
}

