/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util;

import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.BugInCF;

enum AtmKind {
    ARRAY(AnnotatedTypeMirror.AnnotatedArrayType.class),
    DECLARED(AnnotatedTypeMirror.AnnotatedDeclaredType.class),
    EXECUTABLE(AnnotatedTypeMirror.AnnotatedExecutableType.class),
    INTERSECTION(AnnotatedTypeMirror.AnnotatedIntersectionType.class),
    NONE(AnnotatedTypeMirror.AnnotatedNoType.class),
    NULL(AnnotatedTypeMirror.AnnotatedNullType.class),
    PRIMITIVE(AnnotatedTypeMirror.AnnotatedPrimitiveType.class),
    TYPEVAR(AnnotatedTypeMirror.AnnotatedTypeVariable.class),
    UNION(AnnotatedTypeMirror.AnnotatedUnionType.class),
    WILDCARD(AnnotatedTypeMirror.AnnotatedWildcardType.class);

    public final Class<? extends AnnotatedTypeMirror> atmClass;

    private AtmKind(Class<? extends AnnotatedTypeMirror> atmClass) {
        this.atmClass = atmClass;
    }

    public static AtmKind valueOf(AnnotatedTypeMirror atm) {
        Class<?> argClass = atm.getClass();
        for (AtmKind atmKind : AtmKind.values()) {
            Class<? extends AnnotatedTypeMirror> kindClass = atmKind.atmClass;
            if (!argClass.equals(kindClass)) continue;
            return atmKind;
        }
        throw new BugInCF("Unhandled AnnotatedTypeMirror ( " + atm.getClass() + " )");
    }
}

