/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.util.count;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.TypeCastTree;
import java.util.List;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.framework.source.SourceChecker;
import org.checkerframework.framework.source.SourceVisitor;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.TreeUtils;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class JavaCodeStatistics
extends SourceChecker {
    int generics = 0;
    int arrayAccesses = 0;
    int typecasts = 0;
    String[] warningKeys = new String[]{"index", "lowerbound", "samelen", "searchindex", "substringindex", "upperbound"};
    int numberOfIndexWarningSuppressions = 0;

    @Override
    public void typeProcessingOver() {
        System.out.printf("Found %d generic type uses.\n", this.generics);
        System.out.printf("Found %d array accesses and creations.\n", this.arrayAccesses);
        System.out.printf("Found %d typecasts.\n", this.typecasts);
        System.out.printf("Found %d warning suppression annotations for the Index Checker.\n", this.numberOfIndexWarningSuppressions);
    }

    @Override
    protected SourceVisitor<?, ?> createSourceVisitor() {
        return new Visitor(this);
    }

    @Override
    public AnnotationProvider getAnnotationProvider() {
        throw new UnsupportedOperationException("getAnnotationProvider is not implemented for this class.");
    }

    class Visitor
    extends SourceVisitor<Void, Void> {
        public Visitor(JavaCodeStatistics l) {
            super(l);
        }

        @Override
        public Void visitAnnotation(AnnotationTree node, Void aVoid) {
            AnnotationMirror annotationMirror = TreeUtils.annotationFromAnnotationTree(node);
            if (AnnotationUtils.annotationName(annotationMirror).equals(SuppressWarnings.class.getCanonicalName())) {
                List<String> keys = AnnotationUtils.getElementValueArray(annotationMirror, "value", String.class, true);
                for (String foundKey : keys) {
                    for (String indexKey : JavaCodeStatistics.this.warningKeys) {
                        if (!foundKey.startsWith(indexKey)) continue;
                        ++JavaCodeStatistics.this.numberOfIndexWarningSuppressions;
                        return (Void)super.visitAnnotation(node, aVoid);
                    }
                }
            }
            return (Void)super.visitAnnotation(node, aVoid);
        }

        @Override
        public Void visitAssert(AssertTree tree, Void aVoid) {
            ExpressionTree detail = tree.getDetail();
            if (detail != null) {
                String msg = detail.toString();
                for (String indexKey : JavaCodeStatistics.this.warningKeys) {
                    String key = "@AssumeAssertion(" + indexKey;
                    if (!msg.contains(key)) continue;
                    ++JavaCodeStatistics.this.numberOfIndexWarningSuppressions;
                    return (Void)super.visitAssert(tree, aVoid);
                }
            }
            return (Void)super.visitAssert(tree, aVoid);
        }

        @Override
        public Void visitClass(ClassTree tree, Void p) {
            if (JavaCodeStatistics.this.shouldSkipDefs(tree)) {
                return null;
            }
            JavaCodeStatistics.this.generics += tree.getTypeParameters().size();
            return (Void)super.visitClass(tree, p);
        }

        @Override
        public Void visitNewArray(NewArrayTree node, Void aVoid) {
            JavaCodeStatistics.this.arrayAccesses += node.getDimensions().size();
            return (Void)super.visitNewArray(node, aVoid);
        }

        @Override
        public Void visitNewClass(NewClassTree node, Void aVoid) {
            if (TreeUtils.isDiamondTree(node)) {
                ++JavaCodeStatistics.this.generics;
            }
            JavaCodeStatistics.this.generics += node.getTypeArguments().size();
            return (Void)super.visitNewClass(node, aVoid);
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree node, Void aVoid) {
            JavaCodeStatistics.this.generics += node.getTypeArguments().size();
            return (Void)super.visitMethodInvocation(node, aVoid);
        }

        @Override
        public Void visitMethod(MethodTree node, Void aVoid) {
            JavaCodeStatistics.this.generics += node.getTypeParameters().size();
            return (Void)super.visitMethod(node, aVoid);
        }

        @Override
        public Void visitParameterizedType(ParameterizedTypeTree tree, Void p) {
            JavaCodeStatistics.this.generics += tree.getTypeArguments().size();
            return (Void)super.visitParameterizedType(tree, p);
        }

        @Override
        public Void visitArrayAccess(ArrayAccessTree node, Void aVoid) {
            ++JavaCodeStatistics.this.arrayAccesses;
            return (Void)super.visitArrayAccess(node, aVoid);
        }

        @Override
        public Void visitTypeCast(TypeCastTree node, Void aVoid) {
            ++JavaCodeStatistics.this.typecasts;
            return (Void)super.visitTypeCast(node, aVoid);
        }
    }
}

