/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.nullness;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import org.checkerframework.checker.nullness.NullnessAnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.TreeUtils;

public class SystemGetPropertyHandler {
    protected final ProcessingEnvironment env;
    protected final NullnessAnnotatedTypeFactory factory;
    protected final ExecutableElement systemGetProperty;
    Collection<String> systemProperties = new HashSet<String>(Arrays.asList("java.version", "java.vendor", "java.vendor.url", "java.home", "java.vm.specification.version", "java.vm.specification.vendor", "java.vm.specification.name", "java.vm.version", "java.vm.vendor", "java.vm.name", "java.specification.version", "java.specification.vendor", "java.specification.name", "java.class.version", "java.class.path", "java.library.path", "java.io.tmpdir", "java.compiler", "java.ext.dirs", "os.name", "os.arch", "os.version", "file.separator", "path.separator", "line.separator", "user.name", "user.home", "user.dir"));

    public SystemGetPropertyHandler(ProcessingEnvironment env, NullnessAnnotatedTypeFactory factory) {
        this.env = env;
        this.factory = factory;
        this.systemGetProperty = TreeUtils.getMethod(System.class.getName(), "getProperty", 1, env);
    }

    public void handle(MethodInvocationTree tree, AnnotatedTypeMirror.AnnotatedExecutableType method) {
        if (TreeUtils.isMethodInvocation(tree, this.systemGetProperty, this.env)) {
            String literal;
            List<? extends ExpressionTree> args = tree.getArguments();
            assert (args.size() == 1);
            ExpressionTree arg = args.get(0);
            if (arg.getKind() == Tree.Kind.STRING_LITERAL && this.systemProperties.contains(literal = (String)((LiteralTree)arg).getValue())) {
                AnnotatedTypeMirror type = method.getReturnType();
                type.replaceAnnotation(this.factory.NONNULL);
            }
        }
    }
}

