/*
 * Decompiled with CFR 0.152.
 */
package annotator.scanner;

import annotator.scanner.CommonScanner;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.org.plumelib.util.Pair;

public class NewScanner
extends CommonScanner {
    private static boolean debug = false;
    static Map<Pair<TreePath, Tree>, Integer> cache = new HashMap<Pair<TreePath, Tree>, Integer>();
    private int index = -1;
    private boolean done = false;
    private final Tree tree;
    private static Map<String, List<Integer>> methodNameToNewOffsets = new HashMap<String, List<Integer>>();

    public static int indexOfNewTree(TreePath treePath, Tree tree) {
        NewScanner.debug("indexOfNewTree: " + treePath.getLeaf());
        Pair<TreePath, Tree> pair = Pair.of(treePath, tree);
        if (cache.containsKey(pair)) {
            return cache.get(pair);
        }
        TreePath treePath2 = NewScanner.findCountingContext(treePath);
        if (treePath2 == null) {
            return -1;
        }
        NewScanner newScanner = new NewScanner(tree);
        newScanner.scan(treePath2, null);
        cache.put(pair, newScanner.index);
        return newScanner.index;
    }

    private NewScanner(Tree tree) {
        this.tree = tree;
    }

    @Override
    public Void visitNewClass(NewClassTree newClassTree, Void void_) {
        if (!this.done) {
            ++this.index;
        }
        if (this.tree == newClassTree) {
            this.done = true;
        }
        return (Void)super.visitNewClass(newClassTree, void_);
    }

    @Override
    public Void visitNewArray(NewArrayTree newArrayTree, Void void_) {
        if (!this.done) {
            ++this.index;
        }
        if (this.tree == newArrayTree) {
            this.done = true;
        }
        return (Void)super.visitNewArray(newArrayTree, void_);
    }

    public static void debug(String string) {
        if (debug) {
            System.out.println(string);
        }
    }

    public static void addNewToMethod(String string, Integer n) {
        NewScanner.debug("adding new to method: " + string + " offset: " + n);
        List<Integer> list = methodNameToNewOffsets.get(string);
        if (list == null) {
            list = new ArrayList<Integer>();
            methodNameToNewOffsets.put(string, list);
        }
        list.add(n);
    }

    public static Integer getMethodNewIndex(String string, Integer n) {
        List<Integer> list = methodNameToNewOffsets.get(string);
        if (list == null) {
            throw new RuntimeException("NewScanner.getMethodNewIndex() : did not find offsets for method: " + string);
        }
        Integer n2 = list.indexOf(n);
        if (n2 < 0) {
            throw new RuntimeException("NewScanner.getMethodNewIndex() : in method: " + string + " did not find offset: " + n);
        }
        return n2;
    }
}

