/*
 * Decompiled with CFR 0.152.
 */
package annotator.scanner;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;

public class LocalClassScanner
extends TreePathScanner<Void, Integer> {
    private int index = 1;
    private boolean found = false;
    private ClassTree localClass;

    public static int indexOfClassTree(TreePath treePath, ClassTree classTree) {
        int n = 0;
        boolean bl = false;
        while (treePath.getParentPath() != null && n < 1) {
            if (treePath.getLeaf() == classTree) {
                bl = true;
            }
            treePath = treePath.getParentPath();
            if (!bl || treePath.getLeaf().getKind() != Tree.Kind.CLASS) continue;
            ++n;
        }
        LocalClassScanner localClassScanner = new LocalClassScanner(classTree);
        localClassScanner.scan(treePath, Integer.valueOf(0));
        if (localClassScanner.found) {
            return localClassScanner.index;
        }
        return -1;
    }

    private LocalClassScanner(ClassTree classTree) {
        this.localClass = classTree;
    }

    @Override
    public Void visitBlock(BlockTree blockTree, Integer n) {
        if (n < 1) {
            for (StatementTree statementTree : blockTree.getStatements()) {
                if (this.found || statementTree.getKind() != Tree.Kind.CLASS) continue;
                ClassTree classTree = (ClassTree)statementTree;
                if (this.localClass == statementTree) {
                    this.found = true;
                    continue;
                }
                if (!classTree.getSimpleName().equals(this.localClass.getSimpleName())) continue;
                ++this.index;
            }
            super.visitBlock(blockTree, n + 1);
        }
        return null;
    }
}

