/*
 * Decompiled with CFR 0.152.
 */
package annotator.scanner;

import annotator.scanner.CommonScanner;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LambdaScanner
extends CommonScanner {
    private int index = -1;
    private boolean done = false;
    private final Tree tree;
    private static Map<String, List<Integer>> methodNameToLambdaExpressionOffsets = new HashMap<String, List<Integer>>();

    public static int indexOfLambdaExpressionTree(TreePath treePath, Tree tree) {
        TreePath treePath2 = LambdaScanner.findCountingContext(treePath);
        if (treePath2 == null) {
            return -1;
        }
        LambdaScanner lambdaScanner = new LambdaScanner(tree);
        lambdaScanner.scan(treePath2, null);
        return lambdaScanner.index;
    }

    private LambdaScanner(Tree tree) {
        this.tree = tree;
    }

    @Override
    public Void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree, Void void_) {
        if (!this.done) {
            ++this.index;
        }
        if (this.tree == lambdaExpressionTree) {
            this.done = true;
        }
        return (Void)super.visitLambdaExpression(lambdaExpressionTree, void_);
    }

    public static void addLambdaExpressionToMethod(String string, Integer n) {
        List<Integer> list = methodNameToLambdaExpressionOffsets.get(string);
        if (list == null) {
            list = new ArrayList<Integer>();
            methodNameToLambdaExpressionOffsets.put(string, list);
        }
        list.add(n);
    }

    public static Integer getMethodLambdaExpressionIndex(String string, Integer n) {
        List<Integer> list = methodNameToLambdaExpressionOffsets.get(string);
        if (list == null) {
            return -1;
        }
        return list.indexOf(n);
    }
}

