/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criteria;
import annotator.find.Insertion;
import java.util.List;
import scenelib.type.ArrayType;
import scenelib.type.BoundedType;
import scenelib.type.DeclaredType;
import scenelib.type.Type;

public abstract class TypedInsertion
extends Insertion {
    protected Type type;
    protected boolean annotationsOnly;
    protected List<Insertion> innerTypeInsertions;

    public TypedInsertion(Type type, Criteria criteria, List<Insertion> list) {
        this(type, criteria, false, list);
    }

    public TypedInsertion(Type type, Criteria criteria, boolean bl, List<Insertion> list) {
        super(criteria, bl);
        this.type = type;
        this.innerTypeInsertions = list;
        this.annotationsOnly = false;
    }

    public void setAnnotationsOnly(boolean bl) {
        this.annotationsOnly = bl;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public List<Insertion> getInnerTypeInsertions() {
        return this.innerTypeInsertions;
    }

    public DeclaredType getBaseType() {
        return TypedInsertion.getBaseType(this.type);
    }

    public static DeclaredType getBaseType(Type type) {
        switch (type.getKind()) {
            case DECLARED: {
                return (DeclaredType)type;
            }
            case BOUNDED: {
                return TypedInsertion.getBaseType(((BoundedType)type).getName());
            }
            case ARRAY: {
                return TypedInsertion.getBaseType(((ArrayType)type).getComponentType());
            }
        }
        return null;
    }
}

