/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criteria;
import annotator.find.Criterion;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import scenelib.annotations.el.BoundLocation;

public class MethodBoundCriterion
implements Criterion {
    private final String methodName;
    public final BoundLocation boundLoc;
    private final Criterion sigMethodCriterion;
    private final Criterion boundLocationCriterion;

    public MethodBoundCriterion(String string, BoundLocation boundLocation) {
        this.methodName = string;
        this.boundLoc = boundLocation;
        this.sigMethodCriterion = Criteria.inMethod(string);
        this.boundLocationCriterion = Criteria.atBoundLocation(boundLocation);
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath, Tree tree) {
        if (treePath == null) {
            return false;
        }
        assert (treePath.getLeaf() == tree);
        return this.isSatisfiedBy(treePath);
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath) {
        return this.sigMethodCriterion.isSatisfiedBy(treePath) && this.boundLocationCriterion.isSatisfiedBy(treePath);
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.METHOD_BOUND;
    }

    public String toString() {
        return "MethodBoundCriterion: method: " + this.methodName + " bound boundLoc: " + this.boundLoc;
    }
}

