/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criterion;
import annotator.scanner.MemberReferenceScanner;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import scenelib.annotations.el.RelativeLocation;

public class MemberReferenceCriterion
implements Criterion {
    private final String methodName;
    private final RelativeLocation loc;

    public MemberReferenceCriterion(String string, RelativeLocation relativeLocation) {
        this.methodName = string;
        this.loc = relativeLocation;
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath, Tree tree) {
        if (treePath == null) {
            return false;
        }
        assert (treePath.getLeaf() == tree);
        return this.isSatisfiedBy(treePath);
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        Tree tree = treePath.getLeaf();
        if (tree.getKind() == Tree.Kind.MEMBER_REFERENCE) {
            int n;
            int n2 = MemberReferenceScanner.indexOfMemberReferenceTree(treePath, tree);
            boolean bl = this.loc.isBytecodeOffset() ? n2 == (n = MemberReferenceScanner.getMemberReferenceIndex(this.methodName, this.loc.offset).intValue()) : n2 == this.loc.index;
            return bl;
        }
        boolean bl = this.isSatisfiedBy(treePath.getParentPath());
        return bl;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.METHOD_REFERENCE;
    }

    public String toString() {
        return "MemberReferenceCriterion: in method: " + this.methodName + " location: " + this.loc;
    }
}

