/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criteria;
import annotator.find.Criterion;
import annotator.scanner.LambdaScanner;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import scenelib.annotations.el.RelativeLocation;

public class LambdaCriterion
implements Criterion {
    private final String methodName;
    private final RelativeLocation loc;

    public LambdaCriterion(String string, RelativeLocation relativeLocation) {
        this.methodName = string;
        this.loc = relativeLocation;
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath, Tree tree) {
        if (treePath == null) {
            return false;
        }
        assert (treePath.getLeaf() == tree);
        return this.isSatisfiedBy(treePath);
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath) {
        if (treePath == null) {
            Criteria.dbug.debug("return null", new Object[0]);
            return false;
        }
        Tree tree = treePath.getLeaf();
        Criteria.dbug.debug("%n%s%n", this.toString());
        Criteria.dbug.debug("LambdaCriterion.isSatisfiedBy: %s%n", tree);
        Criteria.dbug.debug("leaf: %s%n", tree);
        Criteria.dbug.debug("kind: %s%n", new Object[]{tree.getKind()});
        Criteria.dbug.debug("class: %s%n", tree.getClass());
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 == null) {
            Criteria.dbug.debug("return: parent path null%n", new Object[0]);
            return false;
        }
        Tree tree2 = treePath2.getLeaf();
        if (tree2 == null) {
            Criteria.dbug.debug("return: parent null%n", new Object[0]);
            return false;
        }
        if (tree2.getKind() == Tree.Kind.LAMBDA_EXPRESSION) {
            boolean bl;
            int n = LambdaScanner.indexOfLambdaExpressionTree(treePath, tree2);
            Criteria.dbug.debug("return source: %d%n", n);
            if (this.loc.isBytecodeOffset()) {
                int n2 = LambdaScanner.getMethodLambdaExpressionIndex(this.methodName, this.loc.offset);
                Criteria.dbug.debug("return class: %d%n", n2);
                bl = n == n2;
            } else {
                bl = n == this.loc.index;
                Criteria.dbug.debug("return loc.index: %d%n", this.loc.index);
            }
            Criteria.dbug.debug("return new: %b%n", bl);
            return bl;
        }
        boolean bl = this.isSatisfiedBy(treePath.getParentPath());
        Criteria.dbug.debug("return parent: %b%n", bl);
        return bl;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.LAMBDA_EXPRESSION;
    }

    public String toString() {
        return "LambdaCriterion: at location: " + this.loc;
    }
}

