/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.Main;
import annotator.find.Criteria;
import annotator.find.Criterion;
import annotator.find.IsSigMethodCriterion;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import javax.lang.model.element.Modifier;

final class InMethodCriterion
implements Criterion {
    public final String name;
    private final IsSigMethodCriterion sigMethodCriterion;

    InMethodCriterion(String string) {
        this.name = string;
        this.sigMethodCriterion = new IsSigMethodCriterion(string);
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.IN_METHOD;
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath, Tree tree) {
        if (treePath == null) {
            return false;
        }
        assert (treePath.getLeaf() == tree);
        return this.isSatisfiedBy(treePath);
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath) {
        Criteria.dbug.debug("InMethodCriterion.isSatisfiedBy(%s); this=%s%n", Main.leafString(treePath), this.toString());
        boolean bl = false;
        boolean bl2 = false;
        do {
            if (treePath.getLeaf().getKind() == Tree.Kind.METHOD) {
                boolean bl3 = this.sigMethodCriterion.isSatisfiedBy(treePath);
                Criteria.dbug.debug("%s%n", "InMethodCriterion.isSatisfiedBy => b");
                return bl3;
            }
            if (treePath.getLeaf().getKind() != Tree.Kind.VARIABLE) continue;
            ModifiersTree modifiersTree = ((VariableTree)treePath.getLeaf()).getModifiers();
            bl = true;
            bl2 = modifiersTree.getFlags().contains((Object)Modifier.STATIC);
        } while ((treePath = treePath.getParentPath()) != null && treePath.getLeaf() != null);
        boolean bl4 = bl && (bl2 ? "<clinit>()V" : "<init>()V").equals(this.name);
        Criteria.dbug.debug("InMethodCriterion.isSatisfiedBy => %s%n", bl4);
        return bl4;
    }

    public String toString() {
        return "in method '" + this.name + "'";
    }
}

