/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criterion;
import annotator.scanner.AnonymousClassScanner;
import annotator.scanner.LocalClassScanner;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class InClassCriterion
implements Criterion {
    static boolean debug = false;
    public final String className;
    private final boolean exactMatch;
    static Pattern anonclassPattern = Pattern.compile("^([0-9]+)(\\$(.*))?$");
    static Pattern localClassPattern = Pattern.compile("^([0-9]+)([^$]+)(\\$(.*))?$");

    public InClassCriterion(String string, boolean bl) {
        this.className = string;
        this.exactMatch = bl;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.IN_CLASS;
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath, Tree tree) {
        if (treePath == null) {
            return false;
        }
        assert (treePath.getLeaf() == tree);
        return this.isSatisfiedBy(treePath);
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath) {
        return InClassCriterion.isSatisfiedBy(treePath, this.className, this.exactMatch);
    }

    public static boolean isSatisfiedBy(TreePath treePath, String string, boolean bl) {
        if (treePath == null) {
            return false;
        }
        String string2 = string;
        ArrayList<Tree> arrayList = new ArrayList<Tree>();
        for (Tree tree : treePath) {
            arrayList.add(tree);
        }
        Collections.reverse(arrayList);
        boolean bl2 = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object;
            String string3;
            Object object2;
            Object object3;
            Object object4;
            Tree tree = (Tree)arrayList.get(i);
            boolean bl3 = false;
            boolean bl4 = false;
            switch (tree.getKind()) {
                case COMPILATION_UNIT: {
                    InClassCriterion.debug("InClassCriterion.isSatisfiedBy:%n  cname=%s%n  tree=%s%n", string2, tree);
                    object4 = ((CompilationUnitTree)tree).getPackageName();
                    if (object4 == null) break;
                    object3 = object4.toString();
                    if (string2.startsWith((String)object3 + ".")) {
                        string2 = string2.substring(((String)object3).length() + 1);
                        break;
                    }
                    InClassCriterion.debug("false[COMPILATION_UNIT; bad declaredPackage = %s] InClassCriterion.isSatisfiedBy:%n  cname=%s%n  tree=%s%n", object3, string2, tree);
                    return false;
                }
                case CLASS: 
                case INTERFACE: 
                case ENUM: 
                case ANNOTATION_TYPE: {
                    if (i > 0 && ((Tree)arrayList.get(i - 1)).getKind() == Tree.Kind.NEW_CLASS) break;
                    InClassCriterion.debug("InClassCriterion.isSatisfiedBy:%n  cname=%s%n  tree=%s%n", string2, tree);
                    if (i > 0 && ((Tree)arrayList.get(i - 1)).getKind() == Tree.Kind.BLOCK) {
                        bl4 = true;
                        InClassCriterion.debug("found local class: InClassCriterion.isSatisfiedBy:%n  cname=%s%n  tree=%s%n", string2, tree);
                        break;
                    }
                    object3 = (ClassTree)tree;
                    object2 = object3.getSimpleName();
                    if (object2 == null || object2.length() == 0) {
                        InClassCriterion.debug("empty getSimpleName: InClassCriterion.isSatisfiedBy:%n  cname=%s%n  tree=%s%n", string2, tree);
                        bl3 = true;
                        break;
                    }
                    string3 = object2.toString();
                    if (string2.equals(string3)) {
                        if (bl) {
                            string2 = "";
                            break;
                        }
                        InClassCriterion.debug("true InClassCriterion.isSatisfiedBy:%n  cname=%s%n  tree=%s%n", string2, tree);
                        return true;
                    }
                    if (string2.startsWith(string3 + "$") || string2.startsWith(string3 + ".")) {
                        string2 = string2.substring(string3.length() + 1);
                        break;
                    }
                    if (string3.isEmpty()) break;
                    InClassCriterion.debug("false InClassCriterion.isSatisfiedBy:%n  cname=%s%n  tree=%s%n", string2, tree);
                    return false;
                }
                case NEW_CLASS: {
                    InClassCriterion.debug("InClassCriterion.isSatisfiedBy:%n  cname=%s%n  tree=%s%n", string2, tree);
                    if (string2.equals("")) {
                        bl2 = true;
                        break;
                    }
                    object = (NewClassTree)tree;
                    bl3 = object.getClassBody() != null;
                    break;
                }
                case METHOD: 
                case VARIABLE: {
                    if (!bl2) break;
                    InClassCriterion.debug("false InClassCriterion.isSatisfiedBy:%n  cname=%s%n  tree=%s%n", string2, tree);
                    return false;
                }
            }
            if (bl3) {
                int n;
                object4 = anonclassPattern.matcher(string2);
                if (!((Matcher)object4).matches()) {
                    InClassCriterion.debug("false[anonclassMatcher] InClassCriterion.isSatisfiedBy:%n  cname=%s%n  tree=%s%n", string2, tree);
                    return false;
                }
                object3 = ((Matcher)object4).group(1);
                string2 = ((Matcher)object4).group(3);
                if (string2 == null) {
                    string2 = "";
                }
                try {
                    n = Integer.parseInt((String)object3);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new Error("This can't happen: " + string2 + "$" + (String)object3, numberFormatException);
                }
                int n2 = AnonymousClassScanner.indexOfClassTree(treePath, tree);
                if (n == n2) continue;
                InClassCriterion.debug("false[anonclassNum %d %d] InClassCriterion.isSatisfiedBy:%n  cname=%s%n  tree=%s%n", n, n2, string2, tree);
                return false;
            }
            if (!bl4) continue;
            object4 = (ClassTree)tree;
            object3 = object4.getSimpleName().toString();
            object2 = localClassPattern.matcher(string2);
            if (!((Matcher)object2).matches()) {
                InClassCriterion.debug("false[localClassMatcher] InClassCriterion.isSatisfiedBy:%n  cname=%s%n  tree=%s%n", string2, tree);
                return false;
            }
            string3 = ((Matcher)object2).group(1);
            object = ((Matcher)object2).group(2);
            int n = Integer.parseInt(string3);
            int n3 = LocalClassScanner.indexOfClassTree(treePath, (ClassTree)object4);
            if (n3 == n && ((String)object3).startsWith((String)object)) {
                string2 = ((Matcher)object2).group(4);
                if (string2 != null) continue;
                string2 = "";
                continue;
            }
            InClassCriterion.debug("false[localClassNum %d %d] InClassCriterion.isSatisfiedBy:%n  cname=%s%n  tree=%s%n", n, n3, string2, tree);
            return false;
        }
        InClassCriterion.debug("%s InClassCriterion.isSatisfiedBy:%n  cname=%s%n  tree=%s%n", string2.equals(""), string2, treePath.getLeaf());
        return string2.equals("");
    }

    public String toString() {
        return "In class '" + this.className + "'" + (this.exactMatch ? " (exactly)" : "");
    }

    private static void debug(String string, Object ... objectArray) {
        if (debug) {
            System.out.printf(string, objectArray);
        }
    }
}

