/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criteria;
import annotator.find.Criterion;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;

public class FieldCriterion
implements Criterion {
    public final String varName;
    public final boolean isDeclaration;
    public final Criterion varCriterion;
    public final Criterion notInMethodCriterion;

    public FieldCriterion(String string) {
        this(string, false);
    }

    public FieldCriterion(String string, boolean bl) {
        this.varName = string;
        this.isDeclaration = bl;
        this.varCriterion = Criteria.is(Tree.Kind.VARIABLE, string);
        this.notInMethodCriterion = Criteria.notInMethod();
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath, Tree tree) {
        if (treePath == null) {
            return false;
        }
        assert (treePath.getLeaf() == tree);
        return this.isSatisfiedBy(treePath);
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath) {
        if (treePath == null || this.isDeclaration && treePath.getLeaf().getKind() != Tree.Kind.VARIABLE) {
            return false;
        }
        if (this.varCriterion.isSatisfiedBy(treePath) && this.notInMethodCriterion.isSatisfiedBy(treePath)) {
            return true;
        }
        return this.isSatisfiedBy(treePath.getParentPath());
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.FIELD;
    }

    public String toString() {
        return "FieldCriterion: " + this.varName;
    }
}

