/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criteria;
import annotator.find.Insertion;
import org.checkerframework.org.plumelib.util.Pair;

public class AnnotationInsertion
extends Insertion {
    private final String fullyQualifiedAnnotationText;
    private final String fullyQualifiedAnnotationName;
    private String type;
    private boolean generateBound;
    private boolean generateExtends;
    private boolean wasGenerateExtends;

    public AnnotationInsertion(String string, Criteria criteria, boolean bl) {
        super(criteria, bl);
        assert (string.startsWith("@")) : string;
        this.fullyQualifiedAnnotationText = string;
        this.fullyQualifiedAnnotationName = this.extractAnnotationFullyQualifiedName();
        this.type = null;
        this.generateBound = false;
        this.generateExtends = false;
        this.wasGenerateExtends = false;
    }

    public AnnotationInsertion(String string) {
        this(string, new Criteria(), false);
    }

    public boolean isGenerateExtends() {
        return this.generateExtends;
    }

    public boolean isGenerateBound() {
        return this.generateBound;
    }

    public void setGenerateExtends(boolean bl) {
        this.generateExtends = bl;
        this.wasGenerateExtends |= bl;
    }

    public void setGenerateBound(boolean bl) {
        this.generateBound = bl;
    }

    @Override
    protected String getText(boolean bl, boolean bl2) {
        String string = this.fullyQualifiedAnnotationText;
        if (bl2) {
            Pair<String, String> pair = AnnotationInsertion.removePackage(string);
            String string2 = (String)pair.a;
            if (string2 != null) {
                this.packageNames.add(string2);
                string = (String)pair.b;
            }
        }
        if (!string.startsWith("@")) {
            throw new Error("Illegal insertion, must start with @: " + string);
        }
        if (this.type != null) {
            string = "new " + string + " " + this.type;
        } else if (this.generateBound) {
            string = string + " Object &";
        } else if (this.generateExtends) {
            string = " extends " + string + " Object";
        }
        return bl ? "/*" + string + "*/" : string;
    }

    private String extractAnnotationFullyQualifiedName() {
        assert (this.fullyQualifiedAnnotationText.startsWith("@"));
        int n = 1;
        int n2 = this.fullyQualifiedAnnotationText.indexOf("(");
        if (n2 == -1) {
            n2 = this.fullyQualifiedAnnotationText.length();
        }
        return this.fullyQualifiedAnnotationText.substring(n, n2);
    }

    public String getAnnotation() {
        return this.fullyQualifiedAnnotationText;
    }

    public String getAnnotationFullyQualifiedName() {
        return this.fullyQualifiedAnnotationName;
    }

    @Override
    protected boolean addLeadingSpace(boolean bl, int n, char c) {
        if (this.generateExtends || c == '.') {
            return false;
        }
        return super.addLeadingSpace(bl, n, c);
    }

    @Override
    protected boolean addTrailingSpace(boolean bl) {
        return !this.wasGenerateExtends && super.addTrailingSpace(bl);
    }

    @Override
    public Insertion.Kind getKind() {
        return Insertion.Kind.ANNOTATION;
    }

    @Override
    public String toString() {
        return this.fullyQualifiedAnnotationText + " " + super.toString();
    }

    public void setType(String string) {
        this.type = string;
    }
}

