/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import sun.tools.java.BinaryAttribute;
import sun.tools.java.BinaryClass;
import sun.tools.java.BinaryConstantPool;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.CompilerError;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.MemberDefinition;
import sun.tools.java.Type;
import sun.tools.tree.BooleanExpression;
import sun.tools.tree.DoubleExpression;
import sun.tools.tree.Expression;
import sun.tools.tree.FloatExpression;
import sun.tools.tree.IntExpression;
import sun.tools.tree.LocalMember;
import sun.tools.tree.LongExpression;
import sun.tools.tree.Node;
import sun.tools.tree.StringExpression;

public final class BinaryMember
extends MemberDefinition {
    Expression value;
    BinaryAttribute atts;
    private boolean isConstantCache = false;
    private boolean isConstantCached = false;

    public BinaryMember(ClassDefinition classDefinition, int n, Type type, Identifier identifier, BinaryAttribute binaryAttribute) {
        super(0L, classDefinition, n, type, identifier, null, null);
        this.atts = binaryAttribute;
        if (this.getAttribute(idDeprecated) != null) {
            this.modifiers |= 0x40000;
        }
        if (this.getAttribute(idSynthetic) != null) {
            this.modifiers |= 0x80000;
        }
    }

    public BinaryMember(ClassDefinition classDefinition) {
        super(classDefinition);
    }

    @Override
    public boolean isInlineable(Environment environment, boolean bl) {
        return this.isConstructor() && this.getClassDefinition().getSuperClass() == null;
    }

    @Override
    public Vector getArguments() {
        if (this.isConstructor() && this.getClassDefinition().getSuperClass() == null) {
            Vector<LocalMember> vector = new Vector<LocalMember>();
            vector.addElement(new LocalMember(0L, this.getClassDefinition(), 0, this.getClassDefinition().getType(), idThis));
            return vector;
        }
        return null;
    }

    @Override
    public ClassDeclaration[] getExceptions(Environment environment) {
        if (!this.isMethod() || this.exp != null) {
            return this.exp;
        }
        byte[] byArray = this.getAttribute(idExceptions);
        if (byArray == null) {
            return new ClassDeclaration[0];
        }
        try {
            BinaryConstantPool binaryConstantPool = ((BinaryClass)this.getClassDefinition()).getConstants();
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            int n = dataInputStream.readUnsignedShort();
            this.exp = new ClassDeclaration[n];
            for (int i = 0; i < n; ++i) {
                this.exp[i] = binaryConstantPool.getDeclaration(environment, dataInputStream.readUnsignedShort());
            }
            return this.exp;
        }
        catch (IOException iOException) {
            throw new CompilerError(iOException);
        }
    }

    @Override
    public String getDocumentation() {
        if (this.documentation != null) {
            return this.documentation;
        }
        byte[] byArray = this.getAttribute(idDocumentation);
        if (byArray == null) {
            return null;
        }
        try {
            this.documentation = new DataInputStream(new ByteArrayInputStream(byArray)).readUTF();
            return this.documentation;
        }
        catch (IOException iOException) {
            throw new CompilerError(iOException);
        }
    }

    @Override
    public boolean isConstant() {
        if (!this.isConstantCached) {
            this.isConstantCache = this.isFinal() && this.isVariable() && this.getAttribute(idConstantValue) != null;
            this.isConstantCached = true;
        }
        return this.isConstantCache;
    }

    @Override
    public Node getValue(Environment environment) {
        if (this.isMethod()) {
            return null;
        }
        if (!this.isFinal()) {
            return null;
        }
        if (this.getValue() != null) {
            return (Expression)this.getValue();
        }
        byte[] byArray = this.getAttribute(idConstantValue);
        if (byArray == null) {
            return null;
        }
        try {
            BinaryConstantPool binaryConstantPool = ((BinaryClass)this.getClassDefinition()).getConstants();
            Object object = binaryConstantPool.getValue(new DataInputStream(new ByteArrayInputStream(byArray)).readUnsignedShort());
            switch (this.getType().getTypeCode()) {
                case 0: {
                    this.setValue(new BooleanExpression(0L, ((Number)object).intValue() != 0));
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this.setValue(new IntExpression(0L, ((Number)object).intValue()));
                    break;
                }
                case 5: {
                    this.setValue(new LongExpression(0L, ((Number)object).longValue()));
                    break;
                }
                case 6: {
                    this.setValue(new FloatExpression(0L, ((Number)object).floatValue()));
                    break;
                }
                case 7: {
                    this.setValue(new DoubleExpression(0L, ((Number)object).doubleValue()));
                    break;
                }
                case 10: {
                    this.setValue(new StringExpression(0L, (String)binaryConstantPool.getValue(((Number)object).intValue())));
                }
            }
            return (Expression)this.getValue();
        }
        catch (IOException iOException) {
            throw new CompilerError(iOException);
        }
    }

    public byte[] getAttribute(Identifier identifier) {
        BinaryAttribute binaryAttribute = this.atts;
        while (binaryAttribute != null) {
            if (binaryAttribute.name.equals(identifier)) {
                return binaryAttribute.data;
            }
            binaryAttribute = binaryAttribute.next;
        }
        return null;
    }

    public boolean deleteAttribute(Identifier identifier) {
        BinaryAttribute binaryAttribute = null;
        BinaryAttribute binaryAttribute2 = null;
        boolean bl = false;
        while (this.atts.name.equals(identifier)) {
            this.atts = this.atts.next;
            bl = true;
        }
        binaryAttribute = this.atts;
        while (binaryAttribute != null) {
            binaryAttribute2 = binaryAttribute.next;
            if (binaryAttribute2 != null && binaryAttribute2.name.equals(identifier)) {
                binaryAttribute.next = binaryAttribute2.next;
                binaryAttribute2 = binaryAttribute2.next;
                bl = true;
            }
            binaryAttribute = binaryAttribute2;
        }
        binaryAttribute = this.atts;
        while (binaryAttribute != null) {
            if (binaryAttribute.name.equals(identifier)) {
                throw new InternalError("Found attribute " + identifier);
            }
            binaryAttribute = binaryAttribute.next;
        }
        return bl;
    }

    public void addAttribute(Identifier identifier, byte[] byArray, Environment environment) {
        this.atts = new BinaryAttribute(identifier, byArray, this.atts);
        ((BinaryClass)this.clazz).cpool.indexString(identifier.toString(), environment);
    }
}

