/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import com.sun.corba.se.impl.util.PackagePrefixChecker;
import com.sun.corba.se.impl.util.Utility;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import sun.rmi.rmic.IndentingWriter;
import sun.rmi.rmic.Main;
import sun.rmi.rmic.iiop.AbstractType;
import sun.rmi.rmic.iiop.BatchEnvironment;
import sun.rmi.rmic.iiop.ClassType;
import sun.rmi.rmic.iiop.CompoundType;
import sun.rmi.rmic.iiop.ContextStack;
import sun.rmi.rmic.iiop.Generator;
import sun.rmi.rmic.iiop.IDLNames;
import sun.rmi.rmic.iiop.ImplementationType;
import sun.rmi.rmic.iiop.InterfaceType;
import sun.rmi.rmic.iiop.RemoteType;
import sun.rmi.rmic.iiop.StaticStringsHash;
import sun.rmi.rmic.iiop.StringComparator;
import sun.rmi.rmic.iiop.Type;
import sun.rmi.rmic.iiop.UserExceptionComparator;
import sun.rmi.rmic.iiop.Util;
import sun.rmi.rmic.iiop.ValueType;
import sun.tools.java.ClassDefinition;
import sun.tools.java.CompilerError;
import sun.tools.java.Identifier;

public class StubGenerator
extends Generator {
    private static final String DEFAULT_STUB_CLASS = "javax.rmi.CORBA.Stub";
    private static final String DEFAULT_TIE_CLASS = "org.omg.CORBA_2_3.portable.ObjectImpl";
    private static final String DEFAULT_POA_TIE_CLASS = "org.omg.PortableServer.Servant";
    protected boolean reverseIDs = false;
    protected boolean localStubs = true;
    protected boolean standardPackage = false;
    protected boolean useHash = true;
    protected String stubBaseClass = "javax.rmi.CORBA.Stub";
    protected String tieBaseClass = "org.omg.CORBA_2_3.portable.ObjectImpl";
    protected HashSet namesInUse = new HashSet();
    protected Hashtable classesInUse = new Hashtable();
    protected Hashtable imports = new Hashtable();
    protected int importCount = 0;
    protected String currentPackage = null;
    protected String currentClass = null;
    protected boolean castArray = false;
    protected Hashtable transactionalObjects = new Hashtable();
    protected boolean POATie = false;
    protected boolean emitPermissionCheck = false;
    private static final String NO_IMPORT = new String();
    static final String SINGLE_SLASH = "\\";
    static final String DOUBLE_SLASH = "\\\\";

    @Override
    public void generate(sun.rmi.rmic.BatchEnvironment batchEnvironment, ClassDefinition classDefinition, File file) {
        ((BatchEnvironment)batchEnvironment).setStandardPackage(this.standardPackage);
        super.generate(batchEnvironment, classDefinition, file);
    }

    @Override
    protected boolean requireNewInstance() {
        return false;
    }

    @Override
    protected boolean parseNonConforming(ContextStack contextStack) {
        return contextStack.getEnv().getParseNonConforming();
    }

    @Override
    protected CompoundType getTopType(ClassDefinition classDefinition, ContextStack contextStack) {
        CompoundType compoundType = null;
        if (classDefinition.isInterface()) {
            compoundType = AbstractType.forAbstract(classDefinition, contextStack, true);
            if (compoundType == null) {
                compoundType = RemoteType.forRemote(classDefinition, contextStack, false);
            }
        } else {
            compoundType = ImplementationType.forImplementation(classDefinition, contextStack, false);
        }
        return compoundType;
    }

    @Override
    public boolean parseArgs(String[] stringArray, Main main) {
        Object object = new Object();
        this.reverseIDs = false;
        this.localStubs = true;
        this.useHash = true;
        this.stubBaseClass = DEFAULT_STUB_CLASS;
        this.transactionalObjects = new Hashtable();
        boolean bl = super.parseArgs(stringArray, main);
        if (bl) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                String string = stringArray[i].toLowerCase();
                if (string.equals("-iiop")) {
                    stringArray[i] = null;
                    continue;
                }
                if (string.equals("-xreverseids")) {
                    this.reverseIDs = true;
                    stringArray[i] = null;
                    continue;
                }
                if (string.equals("-nolocalstubs")) {
                    this.localStubs = false;
                    stringArray[i] = null;
                    continue;
                }
                if (string.equals("-xnohash")) {
                    this.useHash = false;
                    stringArray[i] = null;
                    continue;
                }
                if (stringArray[i].equals("-standardPackage")) {
                    this.standardPackage = true;
                    stringArray[i] = null;
                    continue;
                }
                if (stringArray[i].equals("-emitPermissionCheck")) {
                    this.emitPermissionCheck = true;
                    stringArray[i] = null;
                    continue;
                }
                if (string.equals("-xstubbase")) {
                    stringArray[i] = null;
                    if (++i < stringArray.length && stringArray[i] != null && !stringArray[i].startsWith("-")) {
                        this.stubBaseClass = stringArray[i];
                        stringArray[i] = null;
                        continue;
                    }
                    main.error("rmic.option.requires.argument", "-Xstubbase");
                    bl = false;
                    continue;
                }
                if (string.equals("-xtiebase")) {
                    stringArray[i] = null;
                    if (++i < stringArray.length && stringArray[i] != null && !stringArray[i].startsWith("-")) {
                        this.tieBaseClass = stringArray[i];
                        stringArray[i] = null;
                        continue;
                    }
                    main.error("rmic.option.requires.argument", "-Xtiebase");
                    bl = false;
                    continue;
                }
                if (string.equals("-transactional")) {
                    for (int j = i + 1; j < stringArray.length; ++j) {
                        if (stringArray[j].charAt(1) == '-') continue;
                        this.transactionalObjects.put(stringArray[j], object);
                        break;
                    }
                    stringArray[i] = null;
                    continue;
                }
                if (!string.equals("-poa")) continue;
                this.POATie = true;
                stringArray[i] = null;
            }
        }
        this.tieBaseClass = this.POATie ? DEFAULT_POA_TIE_CLASS : DEFAULT_TIE_CLASS;
        return bl;
    }

    @Override
    protected Generator.OutputType[] getOutputTypesFor(CompoundType compoundType, HashSet hashSet) {
        int n = 69632;
        Type[] typeArray = compoundType.collectMatching(n, hashSet);
        int n2 = typeArray.length;
        Vector<Generator.OutputType> vector = new Vector<Generator.OutputType>(n2 + 5);
        BatchEnvironment batchEnvironment = compoundType.getEnv();
        for (int i = 0; i < typeArray.length; ++i) {
            Type type = typeArray[i];
            String string = type.getName();
            boolean bl = true;
            if (type instanceof ImplementationType) {
                vector.addElement(new Generator.OutputType(Utility.tieNameForCompiler((String)string), type));
                int n3 = 0;
                InterfaceType[] interfaceTypeArray = ((CompoundType)type).getInterfaces();
                for (int j = 0; j < interfaceTypeArray.length; ++j) {
                    if (!interfaceTypeArray[j].isType(4096) || interfaceTypeArray[j].isType(8192)) continue;
                    ++n3;
                }
                if (n3 <= 1) {
                    bl = false;
                }
            }
            if (type instanceof AbstractType) {
                bl = false;
            }
            if (!bl) continue;
            vector.addElement(new Generator.OutputType(Utility.stubNameForCompiler((String)string), type));
        }
        Object[] objectArray = new Generator.OutputType[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    @Override
    protected String getFileNameExtensionFor(Generator.OutputType outputType) {
        return ".java";
    }

    @Override
    protected void writeOutputFor(Generator.OutputType outputType, HashSet hashSet, IndentingWriter indentingWriter) throws IOException {
        String string = outputType.getName();
        CompoundType compoundType = (CompoundType)outputType.getType();
        if (string.endsWith("_Stub")) {
            this.writeStub(outputType, indentingWriter);
        } else {
            this.writeTie(outputType, indentingWriter);
        }
    }

    protected void writeStub(Generator.OutputType outputType, IndentingWriter indentingWriter) throws IOException {
        CompoundType compoundType = (CompoundType)outputType.getType();
        RemoteType[] remoteTypeArray = this.getDirectRemoteInterfaces(compoundType);
        indentingWriter.pln("// Stub class generated by rmic, do not edit.");
        indentingWriter.pln("// Contents subject to change without notice.");
        indentingWriter.pln();
        this.setStandardClassesInUse(compoundType, true);
        this.addClassesInUse(compoundType, remoteTypeArray);
        this.writePackageAndImports(indentingWriter);
        if (this.emitPermissionCheck) {
            indentingWriter.pln("import java.security.AccessController;");
            indentingWriter.pln("import java.security.PrivilegedAction;");
            indentingWriter.pln("import java.io.SerializablePermission;");
            indentingWriter.pln();
            indentingWriter.pln();
        }
        indentingWriter.p("public class " + this.currentClass);
        indentingWriter.p(" extends " + this.getName(this.stubBaseClass));
        indentingWriter.p(" implements ");
        if (remoteTypeArray.length > 0) {
            for (int i = 0; i < remoteTypeArray.length; ++i) {
                if (i > 0) {
                    indentingWriter.pln(",");
                }
                String string = this.testUtil(this.getName(remoteTypeArray[i]), compoundType);
                indentingWriter.p(string);
            }
        }
        if (!this.implementsRemote(compoundType)) {
            indentingWriter.pln(",");
            indentingWriter.p(this.getName("java.rmi.Remote"));
        }
        indentingWriter.plnI(" {");
        indentingWriter.pln();
        this.writeIds(indentingWriter, compoundType, false);
        indentingWriter.pln();
        if (this.emitPermissionCheck) {
            indentingWriter.pln();
            indentingWriter.plnI("private static Void checkPermission() {");
            indentingWriter.plnI("SecurityManager sm = System.getSecurityManager();");
            indentingWriter.pln("if (sm != null) {");
            indentingWriter.pI();
            indentingWriter.plnI("sm.checkPermission(new SerializablePermission(");
            indentingWriter.plnI("\"enableSubclassImplementation\"));");
            indentingWriter.pO();
            indentingWriter.pO();
            indentingWriter.pOln("}");
            indentingWriter.pln("return null;");
            indentingWriter.pO();
            indentingWriter.pOln("}");
            indentingWriter.pln();
            indentingWriter.pO();
            indentingWriter.pI();
            indentingWriter.pln("private " + this.currentClass + "(Void ignore) {  }");
            indentingWriter.pln();
            indentingWriter.plnI("public " + this.currentClass + "() { ");
            indentingWriter.pln("this(checkPermission());");
            indentingWriter.pOln("}");
            indentingWriter.pln();
        }
        if (!this.emitPermissionCheck) {
            indentingWriter.pI();
        }
        indentingWriter.plnI("public String[] _ids() { ");
        indentingWriter.pln("return (String[]) _type_ids.clone();");
        indentingWriter.pOln("}");
        CompoundType.Method[] methodArray = compoundType.getMethods();
        int n = methodArray.length;
        if (n > 0) {
            boolean bl = true;
            for (int i = 0; i < n; ++i) {
                if (methodArray[i].isConstructor()) continue;
                if (bl) {
                    bl = false;
                }
                indentingWriter.pln();
                this.writeStubMethod(indentingWriter, methodArray[i], compoundType);
            }
        }
        this.writeCastArray(indentingWriter);
        indentingWriter.pOln("}");
    }

    void addClassInUse(String string) {
        String string2 = string;
        String string3 = null;
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string2 = string.substring(n + 1);
            string3 = string.substring(0, n);
        }
        this.addClassInUse(string2, string, string3);
    }

    void addClassInUse(Type type) {
        if (!type.isPrimitive()) {
            Identifier identifier = type.getIdentifier();
            String string = IDLNames.replace(identifier.getName().toString(), ". ", ".");
            String string2 = type.getPackageName();
            String string3 = string2 != null ? string2 + "." + string : string;
            this.addClassInUse(string, string3, string2);
        }
    }

    void addClassInUse(Type[] typeArray) {
        for (int i = 0; i < typeArray.length; ++i) {
            this.addClassInUse(typeArray[i]);
        }
    }

    void addStubInUse(Type type) {
        if (type.getIdentifier() != idCorbaObject && type.isType(2048)) {
            String string = this.getStubNameFor(type, false);
            String string2 = type.getPackageName();
            String string3 = string2 == null ? string : string2 + "." + string;
            this.addClassInUse(string, string3, string2);
        }
        if (type.isType(4096) || type.isType(524288)) {
            this.addClassInUse("javax.rmi.PortableRemoteObject");
        }
    }

    String getStubNameFor(Type type, boolean bl) {
        String string = bl ? type.getQualifiedName() : type.getName();
        String string2 = ((CompoundType)type).isCORBAObject() ? Utility.idlStubName((String)string) : Utility.stubNameForCompiler((String)string);
        return string2;
    }

    void addStubInUse(Type[] typeArray) {
        for (int i = 0; i < typeArray.length; ++i) {
            this.addStubInUse(typeArray[i]);
        }
    }

    void addClassInUse(String string, String string2, String string3) {
        String string4 = (String)this.classesInUse.get(string2);
        if (string4 == null) {
            String string5 = (String)this.imports.get(string);
            String string6 = null;
            if (string3 == null) {
                string6 = string;
            } else if (string3.equals("java.lang")) {
                string6 = string;
                if (string6.endsWith("_Stub")) {
                    string6 = Util.packagePrefix() + string2;
                }
            } else if (this.currentPackage != null && string3.equals(this.currentPackage)) {
                string6 = string;
                if (string5 != null) {
                    string6 = string2;
                }
            } else if (string5 != null) {
                string6 = string2;
            } else if (string2.equals("org.omg.CORBA.Object")) {
                string6 = string2;
            } else if (string.indexOf(46) != -1) {
                string6 = string2;
            } else {
                string6 = string;
                this.imports.put(string, string2);
                ++this.importCount;
            }
            this.classesInUse.put(string2, string6);
        }
    }

    String getName(Type type) {
        if (type.isPrimitive()) {
            return type.getName() + type.getArrayBrackets();
        }
        Identifier identifier = type.getIdentifier();
        String string = IDLNames.replace(identifier.toString(), ". ", ".");
        return this.getName(string) + type.getArrayBrackets();
    }

    String getExceptionName(Type type) {
        Identifier identifier = type.getIdentifier();
        return IDLNames.replace(identifier.toString(), ". ", ".");
    }

    String getName(String string) {
        return (String)this.classesInUse.get(string);
    }

    String getName(Identifier identifier) {
        return this.getName(identifier.toString());
    }

    String getStubName(Type type) {
        String string = this.getStubNameFor(type, true);
        return this.getName(string);
    }

    void setStandardClassesInUse(CompoundType compoundType, boolean bl) throws IOException {
        this.currentPackage = compoundType.getPackageName();
        this.imports.clear();
        this.classesInUse.clear();
        this.namesInUse.clear();
        this.importCount = 0;
        this.castArray = false;
        this.addClassInUse(compoundType);
        this.currentClass = bl ? Utility.stubNameForCompiler((String)compoundType.getName()) : Utility.tieNameForCompiler((String)compoundType.getName());
        if (this.currentPackage == null) {
            this.addClassInUse(this.currentClass, this.currentClass, this.currentPackage);
        } else {
            this.addClassInUse(this.currentClass, this.currentPackage + "." + this.currentClass, this.currentPackage);
        }
        this.addClassInUse("javax.rmi.CORBA.Util");
        this.addClassInUse(idRemote.toString());
        this.addClassInUse(idRemoteException.toString());
        this.addClassInUse(idOutputStream.toString());
        this.addClassInUse(idInputStream.toString());
        this.addClassInUse(idSystemException.toString());
        this.addClassInUse(idJavaIoSerializable.toString());
        this.addClassInUse(idCorbaORB.toString());
        this.addClassInUse(idReplyHandler.toString());
        if (bl) {
            this.addClassInUse(this.stubBaseClass);
            this.addClassInUse("java.rmi.UnexpectedException");
            this.addClassInUse(idRemarshalException.toString());
            this.addClassInUse(idApplicationException.toString());
            if (this.localStubs) {
                this.addClassInUse("org.omg.CORBA.portable.ServantObject");
            }
        } else {
            this.addClassInUse(compoundType);
            this.addClassInUse(this.tieBaseClass);
            this.addClassInUse(idTieInterface.toString());
            this.addClassInUse(idBadMethodException.toString());
            this.addClassInUse(idPortableUnknownException.toString());
            this.addClassInUse(idJavaLangThrowable.toString());
        }
    }

    void addClassesInUse(CompoundType compoundType, RemoteType[] remoteTypeArray) {
        CompoundType.Method[] methodArray = compoundType.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            this.addClassInUse(methodArray[i].getReturnType());
            this.addStubInUse(methodArray[i].getReturnType());
            this.addClassInUse(methodArray[i].getArguments());
            this.addStubInUse(methodArray[i].getArguments());
            this.addClassInUse(methodArray[i].getExceptions());
            this.addClassInUse(methodArray[i].getImplExceptions());
        }
        if (remoteTypeArray != null) {
            this.addClassInUse(remoteTypeArray);
        }
    }

    void writePackageAndImports(IndentingWriter indentingWriter) throws IOException {
        if (this.currentPackage != null) {
            indentingWriter.pln("package " + Util.correctPackageName(this.currentPackage, false, this.standardPackage) + ";");
            indentingWriter.pln();
        }
        String[] stringArray = new String[this.importCount];
        int n = 0;
        Enumeration enumeration = this.imports.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string == NO_IMPORT) continue;
            stringArray[n++] = string;
        }
        Arrays.sort(stringArray, new StringComparator());
        for (int i = 0; i < this.importCount; ++i) {
            if (Util.isOffendingPackage(stringArray[i]) && stringArray[i].endsWith("_Stub") && String.valueOf(stringArray[i].charAt(stringArray[i].lastIndexOf(".") + 1)).equals("_")) {
                indentingWriter.pln("import " + PackagePrefixChecker.packagePrefix() + stringArray[i] + ";");
                continue;
            }
            indentingWriter.pln("import " + stringArray[i] + ";");
        }
        indentingWriter.pln();
        if (this.currentPackage != null && Util.isOffendingPackage(this.currentPackage)) {
            indentingWriter.pln("import " + this.currentPackage + ".*  ;");
        }
        indentingWriter.pln();
    }

    boolean implementsRemote(CompoundType compoundType) {
        boolean bl;
        boolean bl2 = bl = compoundType.isType(4096) && !compoundType.isType(8192);
        if (!bl) {
            InterfaceType[] interfaceTypeArray = compoundType.getInterfaces();
            for (int i = 0; i < interfaceTypeArray.length && !(bl = this.implementsRemote(interfaceTypeArray[i])); ++i) {
            }
        }
        return bl;
    }

    void writeStubMethod(IndentingWriter indentingWriter, CompoundType.Method method, CompoundType compoundType) throws IOException {
        int n;
        String string = method.getName();
        String string2 = method.getIDLName();
        Type[] typeArray = method.getArguments();
        String[] stringArray = method.getArgumentNames();
        Type type = method.getReturnType();
        ValueType[] valueTypeArray = this.getStubExceptions(method, false);
        this.addNamesInUse(method);
        this.addNameInUse("_type_ids");
        String string3 = this.testUtil(this.getName(type), type);
        indentingWriter.p("public " + string3 + " " + string + "(");
        for (n = 0; n < typeArray.length; ++n) {
            if (n > 0) {
                indentingWriter.p(", ");
            }
            indentingWriter.p(this.getName(typeArray[n]) + " " + stringArray[n]);
        }
        indentingWriter.p(")");
        if (valueTypeArray.length > 0) {
            indentingWriter.p(" throws ");
            for (n = 0; n < valueTypeArray.length; ++n) {
                if (n > 0) {
                    indentingWriter.p(", ");
                }
                indentingWriter.p(this.getExceptionName(valueTypeArray[n]));
            }
        }
        indentingWriter.plnI(" {");
        if (this.localStubs) {
            this.writeLocalStubMethodBody(indentingWriter, method, compoundType);
        } else {
            this.writeNonLocalStubMethodBody(indentingWriter, method, compoundType);
        }
        indentingWriter.pOln("}");
    }

    void writeLocalStubMethodBody(IndentingWriter indentingWriter, CompoundType.Method method, CompoundType compoundType) throws IOException {
        String string;
        String[] stringArray = method.getArgumentNames();
        Type type = method.getReturnType();
        ValueType[] valueTypeArray = this.getStubExceptions(method, false);
        String string2 = method.getName();
        String string3 = method.getIDLName();
        indentingWriter.plnI("if (!Util.isLocal(this)) {");
        this.writeNonLocalStubMethodBody(indentingWriter, method, compoundType);
        indentingWriter.pOlnI("} else {");
        String string4 = this.getVariableName("so");
        indentingWriter.pln("ServantObject " + string4 + " = _servant_preinvoke(\"" + string3 + "\"," + this.getName(compoundType) + ".class);");
        indentingWriter.plnI("if (" + string4 + " == null) {");
        if (!type.isType(1)) {
            indentingWriter.p("return ");
        }
        indentingWriter.p(string2 + "(");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                indentingWriter.p(", ");
            }
            indentingWriter.p(stringArray[i]);
        }
        indentingWriter.pln(");");
        if (type.isType(1)) {
            indentingWriter.pln("return ;");
        }
        indentingWriter.pOln("}");
        indentingWriter.plnI("try {");
        String[] stringArray2 = this.writeCopyArguments(method, indentingWriter);
        boolean bl = StubGenerator.mustCopy(type);
        String string5 = null;
        if (!type.isType(1)) {
            if (bl) {
                string5 = this.getVariableName("result");
                string = this.testUtil(this.getName(type), type);
                indentingWriter.p(string + " " + string5 + " = ");
            } else {
                indentingWriter.p("return ");
            }
        }
        string = this.testUtil(this.getName(compoundType), compoundType);
        indentingWriter.p("((" + string + ")" + string4 + ".servant)." + string2 + "(");
        for (int i = 0; i < stringArray2.length; ++i) {
            if (i > 0) {
                indentingWriter.p(", ");
            }
            indentingWriter.p(stringArray2[i]);
        }
        if (bl) {
            indentingWriter.pln(");");
            string = this.testUtil(this.getName(type), type);
            indentingWriter.pln("return (" + string + ")Util.copyObject(" + string5 + ",_orb());");
        } else {
            indentingWriter.pln(");");
        }
        String string6 = this.getVariableName("ex");
        String string7 = this.getVariableName("exCopy");
        indentingWriter.pOlnI("} catch (Throwable " + string6 + ") {");
        indentingWriter.pln("Throwable " + string7 + " = (Throwable)Util.copyObject(" + string6 + ",_orb());");
        for (int i = 0; i < valueTypeArray.length; ++i) {
            if (valueTypeArray[i].getIdentifier() == idRemoteException || !valueTypeArray[i].isType(32768)) continue;
            indentingWriter.plnI("if (" + string7 + " instanceof " + this.getExceptionName(valueTypeArray[i]) + ") {");
            indentingWriter.pln("throw (" + this.getExceptionName(valueTypeArray[i]) + ")" + string7 + ";");
            indentingWriter.pOln("}");
        }
        indentingWriter.pln("throw Util.wrapException(" + string7 + ");");
        indentingWriter.pOlnI("} finally {");
        indentingWriter.pln("_servant_postinvoke(" + string4 + ");");
        indentingWriter.pOln("}");
        indentingWriter.pOln("}");
    }

    void writeNonLocalStubMethodBody(IndentingWriter indentingWriter, CompoundType.Method method, CompoundType compoundType) throws IOException {
        int n;
        int n2;
        String string = method.getName();
        String string2 = method.getIDLName();
        Type[] typeArray = method.getArguments();
        String[] stringArray = method.getArgumentNames();
        Type type = method.getReturnType();
        ValueType[] valueTypeArray = this.getStubExceptions(method, true);
        String string3 = this.getVariableName("in");
        String string4 = this.getVariableName("out");
        String string5 = this.getVariableName("ex");
        boolean bl = false;
        for (n2 = 0; n2 < valueTypeArray.length; ++n2) {
            if (valueTypeArray[n2].getIdentifier() == idRemoteException || !valueTypeArray[n2].isType(32768) || !StubGenerator.needNewReadStreamClass(valueTypeArray[n2])) continue;
            bl = true;
            break;
        }
        if (!bl) {
            for (n2 = 0; n2 < typeArray.length; ++n2) {
                if (!StubGenerator.needNewReadStreamClass(typeArray[n2])) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            bl = StubGenerator.needNewReadStreamClass(type);
        }
        n2 = 0;
        for (int i = 0; i < typeArray.length; ++i) {
            if (!StubGenerator.needNewWriteStreamClass(typeArray[i])) continue;
            n2 = 1;
            break;
        }
        indentingWriter.plnI("try {");
        if (bl) {
            indentingWriter.pln(idExtInputStream + " " + string3 + " = null;");
        } else {
            indentingWriter.pln(idInputStream + " " + string3 + " = null;");
        }
        indentingWriter.plnI("try {");
        String string6 = "null";
        if (n2 != 0) {
            indentingWriter.plnI(idExtOutputStream + " " + string4 + " = ");
            indentingWriter.pln("(" + idExtOutputStream + ")");
            indentingWriter.pln("_request(\"" + string2 + "\", true);");
            indentingWriter.pO();
        } else {
            indentingWriter.pln("OutputStream " + string4 + " = _request(\"" + string2 + "\", true);");
        }
        if (typeArray.length > 0) {
            this.writeMarshalArguments(indentingWriter, string4, typeArray, stringArray);
            indentingWriter.pln();
        }
        string6 = string4;
        if (type.isType(1)) {
            indentingWriter.pln("_invoke(" + string6 + ");");
        } else {
            if (bl) {
                indentingWriter.plnI(string3 + " = (" + idExtInputStream + ")_invoke(" + string6 + ");");
                indentingWriter.pO();
            } else {
                indentingWriter.pln(string3 + " = _invoke(" + string6 + ");");
            }
            indentingWriter.p("return ");
            this.writeUnmarshalArgument(indentingWriter, string3, type, null);
            indentingWriter.pln();
        }
        indentingWriter.pOlnI("} catch (" + this.getName(idApplicationException) + " " + string5 + ") {");
        if (bl) {
            indentingWriter.pln(string3 + " = (" + idExtInputStream + ") " + string5 + ".getInputStream();");
        } else {
            indentingWriter.pln(string3 + " = " + string5 + ".getInputStream();");
        }
        boolean bl2 = false;
        boolean bl3 = false;
        for (n = 0; n < valueTypeArray.length; ++n) {
            if (valueTypeArray[n].getIdentifier() == idRemoteException) continue;
            if (valueTypeArray[n].isIDLEntityException() && !valueTypeArray[n].isCORBAUserException()) {
                if (!bl3 && !bl2) {
                    indentingWriter.pln("String $_id = " + string5 + ".getId();");
                    bl3 = true;
                }
                String string7 = IDLNames.replace(valueTypeArray[n].getQualifiedIDLName(false), "::", ".");
                string7 = string7 + "Helper";
                indentingWriter.plnI("if ($_id.equals(" + string7 + ".id())) {");
                indentingWriter.pln("throw " + string7 + ".read(" + string3 + ");");
            } else {
                if (!bl3 && !bl2) {
                    indentingWriter.pln("String $_id = " + string3 + ".read_string();");
                    bl3 = true;
                    bl2 = true;
                } else if (bl3 && !bl2) {
                    indentingWriter.pln("$_id = " + string3 + ".read_string();");
                    bl2 = true;
                }
                indentingWriter.plnI("if ($_id.equals(\"" + this.getExceptionRepositoryID(valueTypeArray[n]) + "\")) {");
                indentingWriter.pln("throw (" + this.getExceptionName(valueTypeArray[n]) + ") " + string3 + ".read_value(" + this.getExceptionName(valueTypeArray[n]) + ".class);");
            }
            indentingWriter.pOln("}");
        }
        if (!bl3 && !bl2) {
            indentingWriter.pln("String $_id = " + string3 + ".read_string();");
            bl3 = true;
            bl2 = true;
        } else if (bl3 && !bl2) {
            indentingWriter.pln("$_id = " + string3 + ".read_string();");
            bl2 = true;
        }
        indentingWriter.pln("throw new UnexpectedException($_id);");
        indentingWriter.pOlnI("} catch (" + this.getName(idRemarshalException) + " " + string5 + ") {");
        if (!type.isType(1)) {
            indentingWriter.p("return ");
        }
        indentingWriter.p(string + "(");
        for (n = 0; n < typeArray.length; ++n) {
            if (n > 0) {
                indentingWriter.p(",");
            }
            indentingWriter.p(stringArray[n]);
        }
        indentingWriter.pln(");");
        indentingWriter.pOlnI("} finally {");
        indentingWriter.pln("_releaseReply(" + string3 + ");");
        indentingWriter.pOln("}");
        indentingWriter.pOlnI("} catch (SystemException " + string5 + ") {");
        indentingWriter.pln("throw Util.mapSystemException(" + string5 + ");");
        indentingWriter.pOln("}");
    }

    void allocateResult(IndentingWriter indentingWriter, Type type) throws IOException {
        if (!type.isType(1)) {
            String string = this.testUtil(this.getName(type), type);
            indentingWriter.p(string + " result = ");
        }
    }

    int getTypeCode(Type type) {
        int n = type.getTypeCode();
        if (type instanceof CompoundType && ((CompoundType)type).isAbstractBase()) {
            n = 8192;
        }
        return n;
    }

    void writeMarshalArgument(IndentingWriter indentingWriter, String string, Type type, String string2) throws IOException {
        int n = this.getTypeCode(type);
        switch (n) {
            case 2: {
                indentingWriter.p(string + ".write_boolean(" + string2 + ");");
                break;
            }
            case 4: {
                indentingWriter.p(string + ".write_octet(" + string2 + ");");
                break;
            }
            case 8: {
                indentingWriter.p(string + ".write_wchar(" + string2 + ");");
                break;
            }
            case 16: {
                indentingWriter.p(string + ".write_short(" + string2 + ");");
                break;
            }
            case 32: {
                indentingWriter.p(string + ".write_long(" + string2 + ");");
                break;
            }
            case 64: {
                indentingWriter.p(string + ".write_longlong(" + string2 + ");");
                break;
            }
            case 128: {
                indentingWriter.p(string + ".write_float(" + string2 + ");");
                break;
            }
            case 256: {
                indentingWriter.p(string + ".write_double(" + string2 + ");");
                break;
            }
            case 512: {
                indentingWriter.p(string + ".write_value(" + string2 + "," + this.getName(type) + ".class);");
                break;
            }
            case 1024: {
                indentingWriter.p("Util.writeAny(" + string + "," + string2 + ");");
                break;
            }
            case 2048: {
                indentingWriter.p(string + ".write_Object(" + string2 + ");");
                break;
            }
            case 4096: {
                indentingWriter.p("Util.writeRemoteObject(" + string + "," + string2 + ");");
                break;
            }
            case 8192: {
                indentingWriter.p("Util.writeAbstractObject(" + string + "," + string2 + ");");
                break;
            }
            case 16384: {
                indentingWriter.p(string + ".write_value((Serializable)" + string2 + "," + this.getName(type) + ".class);");
                break;
            }
            case 32768: {
                indentingWriter.p(string + ".write_value(" + string2 + "," + this.getName(type) + ".class);");
                break;
            }
            case 65536: {
                indentingWriter.p(string + ".write_value((Serializable)" + string2 + "," + this.getName(type) + ".class);");
                break;
            }
            case 131072: {
                indentingWriter.p(string + ".write_value((Serializable)" + string2 + "," + this.getName(type) + ".class);");
                break;
            }
            case 262144: {
                this.castArray = true;
                indentingWriter.p(string + ".write_value(cast_array(" + string2 + ")," + this.getName(type) + ".class);");
                break;
            }
            case 524288: {
                indentingWriter.p("Util.writeRemoteObject(" + string + "," + string2 + ");");
                break;
            }
            default: {
                throw new Error("unexpected type code: " + n);
            }
        }
    }

    void writeUnmarshalArgument(IndentingWriter indentingWriter, String string, Type type, String string2) throws IOException {
        int n = this.getTypeCode(type);
        if (string2 != null) {
            indentingWriter.p(string2 + " = ");
        }
        switch (n) {
            case 2: {
                indentingWriter.p(string + ".read_boolean();");
                break;
            }
            case 4: {
                indentingWriter.p(string + ".read_octet();");
                break;
            }
            case 8: {
                indentingWriter.p(string + ".read_wchar();");
                break;
            }
            case 16: {
                indentingWriter.p(string + ".read_short();");
                break;
            }
            case 32: {
                indentingWriter.p(string + ".read_long();");
                break;
            }
            case 64: {
                indentingWriter.p(string + ".read_longlong();");
                break;
            }
            case 128: {
                indentingWriter.p(string + ".read_float();");
                break;
            }
            case 256: {
                indentingWriter.p(string + ".read_double();");
                break;
            }
            case 512: {
                indentingWriter.p("(String) " + string + ".read_value(" + this.getName(type) + ".class);");
                break;
            }
            case 1024: {
                if (type.getIdentifier() != idJavaLangObject) {
                    indentingWriter.p("(" + this.getName(type) + ") ");
                }
                indentingWriter.p("Util.readAny(" + string + ");");
                break;
            }
            case 2048: {
                if (type.getIdentifier() == idCorbaObject) {
                    indentingWriter.p("(" + this.getName(type) + ") " + string + ".read_Object();");
                    break;
                }
                indentingWriter.p("(" + this.getName(type) + ") " + string + ".read_Object(" + this.getStubName(type) + ".class);");
                break;
            }
            case 4096: {
                String string3 = this.testUtil(this.getName(type), type);
                indentingWriter.p("(" + string3 + ") " + "PortableRemoteObject.narrow(" + string + ".read_Object(), " + string3 + ".class);");
                break;
            }
            case 8192: {
                indentingWriter.p("(" + this.getName(type) + ") " + string + ".read_abstract_interface();");
                break;
            }
            case 16384: {
                indentingWriter.p("(" + this.getName(type) + ") " + string + ".read_value(" + this.getName(type) + ".class);");
                break;
            }
            case 32768: {
                indentingWriter.p("(" + this.getName(type) + ") " + string + ".read_value(" + this.getName(type) + ".class);");
                break;
            }
            case 65536: {
                indentingWriter.p("(" + this.getName(type) + ") " + string + ".read_value(" + this.getName(type) + ".class);");
                break;
            }
            case 131072: {
                indentingWriter.p("(" + this.getName(type) + ") " + string + ".read_value(" + this.getName(type) + ".class);");
                break;
            }
            case 262144: {
                indentingWriter.p("(" + this.getName(type) + ") " + string + ".read_value(" + this.getName(type) + ".class);");
                break;
            }
            case 524288: {
                indentingWriter.p("(" + this.getName(type) + ") " + "PortableRemoteObject.narrow(" + string + ".read_Object(), " + this.getName(type) + ".class);");
                break;
            }
            default: {
                throw new Error("unexpected type code: " + n);
            }
        }
    }

    String[] getAllRemoteRepIDs(CompoundType compoundType) {
        int n;
        Object object;
        int n2;
        String[] stringArray;
        Type[] typeArray = this.collectAllRemoteInterfaces(compoundType);
        int n3 = typeArray.length;
        boolean bl = compoundType instanceof ImplementationType;
        Type[] typeArray2 = compoundType.getInterfaces();
        int n4 = this.countRemote(typeArray2, false);
        int n5 = 0;
        if (bl && n4 > 1) {
            stringArray = new String[n3 + 1];
            stringArray[0] = this.getRepositoryID(compoundType);
            n5 = 1;
        } else {
            stringArray = new String[n3];
            if (n3 > 1) {
                String string = null;
                if (bl) {
                    for (n2 = 0; n2 < typeArray2.length; ++n2) {
                        if (!typeArray2[n2].isType(4096)) continue;
                        string = typeArray2[n2].getRepositoryID();
                        break;
                    }
                } else {
                    string = compoundType.getRepositoryID();
                }
                for (n2 = 0; n2 < n3; ++n2) {
                    if (typeArray[n2].getRepositoryID() != string) continue;
                    if (n2 <= 0) break;
                    object = typeArray[0];
                    typeArray[0] = typeArray[n2];
                    typeArray[n2] = object;
                    break;
                }
            }
        }
        for (n = 0; n < typeArray.length; ++n) {
            stringArray[n5++] = this.getRepositoryID(typeArray[n]);
        }
        if (this.reverseIDs) {
            n = 0;
            n2 = stringArray.length - 1;
            while (n < n2) {
                object = stringArray[n];
                stringArray[n++] = stringArray[n2];
                stringArray[n2--] = object;
            }
        }
        return stringArray;
    }

    Type[] collectAllRemoteInterfaces(CompoundType compoundType) {
        Vector vector = new Vector();
        this.addRemoteInterfaces(vector, compoundType);
        Object[] objectArray = new Type[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    void addRemoteInterfaces(Vector vector, CompoundType compoundType) {
        if (compoundType != null) {
            if (compoundType.isInterface() && !vector.contains(compoundType)) {
                vector.addElement(compoundType);
            }
            InterfaceType[] interfaceTypeArray = compoundType.getInterfaces();
            for (int i = 0; i < interfaceTypeArray.length; ++i) {
                if (!interfaceTypeArray[i].isType(4096)) continue;
                this.addRemoteInterfaces(vector, interfaceTypeArray[i]);
            }
            this.addRemoteInterfaces(vector, compoundType.getSuperclass());
        }
    }

    RemoteType[] getDirectRemoteInterfaces(CompoundType compoundType) {
        Type[] typeArray = compoundType.getInterfaces();
        Type[] typeArray2 = compoundType instanceof ImplementationType ? typeArray : new InterfaceType[]{(InterfaceType)compoundType};
        int n = this.countRemote(typeArray2, false);
        if (n == 0) {
            throw new CompilerError("iiop.StubGenerator: No remote interfaces!");
        }
        RemoteType[] remoteTypeArray = new RemoteType[n];
        int n2 = 0;
        for (int i = 0; i < typeArray2.length; ++i) {
            if (!typeArray2[i].isType(4096)) continue;
            remoteTypeArray[n2++] = (RemoteType)typeArray2[i];
        }
        return remoteTypeArray;
    }

    int countRemote(Type[] typeArray, boolean bl) {
        int n = 0;
        for (int i = 0; i < typeArray.length; ++i) {
            if (!typeArray[i].isType(4096) || !bl && typeArray[i].isType(8192)) continue;
            ++n;
        }
        return n;
    }

    void writeCastArray(IndentingWriter indentingWriter) throws IOException {
        if (this.castArray) {
            indentingWriter.pln();
            indentingWriter.pln("// This method is required as a work-around for");
            indentingWriter.pln("// a bug in the JDK 1.1.6 verifier.");
            indentingWriter.pln();
            indentingWriter.plnI("private " + this.getName(idJavaIoSerializable) + " cast_array(Object obj) {");
            indentingWriter.pln("return (" + this.getName(idJavaIoSerializable) + ")obj;");
            indentingWriter.pOln("}");
        }
    }

    void writeIds(IndentingWriter indentingWriter, CompoundType compoundType, boolean bl) throws IOException {
        boolean bl2;
        indentingWriter.plnI("private static final String[] _type_ids = {");
        String[] stringArray = this.getAllRemoteRepIDs(compoundType);
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    indentingWriter.pln(", ");
                }
                indentingWriter.p("\"" + stringArray[i] + "\"");
            }
        } else {
            indentingWriter.pln("\"\"");
        }
        String string = compoundType.getQualifiedName();
        boolean bl3 = bl2 = bl && this.transactionalObjects.containsKey(string);
        if (bl2) {
            indentingWriter.pln(", ");
            indentingWriter.pln("\"IDL:omg.org/CosTransactions/TransactionalObject:1.0\"");
        } else if (stringArray.length > 0) {
            indentingWriter.pln();
        }
        indentingWriter.pOln("};");
    }

    protected void writeTie(Generator.OutputType outputType, IndentingWriter indentingWriter) throws IOException {
        CompoundType compoundType = (CompoundType)outputType.getType();
        RemoteType[] remoteTypeArray = null;
        indentingWriter.pln("// Tie class generated by rmic, do not edit.");
        indentingWriter.pln("// Contents subject to change without notice.");
        indentingWriter.pln();
        this.setStandardClassesInUse(compoundType, false);
        this.addClassesInUse(compoundType, remoteTypeArray);
        this.writePackageAndImports(indentingWriter);
        indentingWriter.p("public class " + this.currentClass + " extends " + this.getName(this.tieBaseClass) + " implements Tie");
        if (!this.implementsRemote(compoundType)) {
            indentingWriter.pln(",");
            indentingWriter.p(this.getName("java.rmi.Remote"));
        }
        indentingWriter.plnI(" {");
        indentingWriter.pln();
        indentingWriter.pln("volatile private " + this.getName(compoundType) + " target = null;");
        indentingWriter.pln();
        this.writeIds(indentingWriter, compoundType, true);
        indentingWriter.pln();
        indentingWriter.plnI("public void setTarget(Remote target) {");
        indentingWriter.pln("this.target = (" + this.getName(compoundType) + ") target;");
        indentingWriter.pOln("}");
        indentingWriter.pln();
        indentingWriter.plnI("public Remote getTarget() {");
        indentingWriter.pln("return target;");
        indentingWriter.pOln("}");
        indentingWriter.pln();
        this.write_tie_thisObject_method(indentingWriter, idCorbaObject);
        indentingWriter.pln();
        this.write_tie_deactivate_method(indentingWriter);
        indentingWriter.pln();
        indentingWriter.plnI("public ORB orb() {");
        indentingWriter.pln("return _orb();");
        indentingWriter.pOln("}");
        indentingWriter.pln();
        this.write_tie_orb_method(indentingWriter);
        indentingWriter.pln();
        this.write_tie__ids_method(indentingWriter);
        CompoundType.Method[] methodArray = compoundType.getMethods();
        this.addNamesInUse(methodArray);
        this.addNameInUse("target");
        this.addNameInUse("_type_ids");
        indentingWriter.pln();
        String string = this.getVariableName("in");
        String string2 = this.getVariableName("_in");
        String string3 = this.getVariableName("ex");
        String string4 = this.getVariableName("method");
        String string5 = this.getVariableName("reply");
        indentingWriter.plnI("public OutputStream  _invoke(String " + string4 + ", InputStream " + string2 + ", " + "ResponseHandler " + string5 + ") throws SystemException {");
        if (methodArray.length > 0) {
            indentingWriter.plnI("try {");
            indentingWriter.pln(this.getName(compoundType) + " target = this.target;");
            indentingWriter.plnI("if (target == null) {");
            indentingWriter.pln("throw new java.io.IOException();");
            indentingWriter.pOln("}");
            indentingWriter.plnI(idExtInputStream + " " + string + " = ");
            indentingWriter.pln("(" + idExtInputStream + ") " + string2 + ";");
            indentingWriter.pO();
            StaticStringsHash staticStringsHash = this.getStringsHash(methodArray);
            if (staticStringsHash != null) {
                indentingWriter.plnI("switch (" + string4 + "." + staticStringsHash.method + ") {");
                for (int i = 0; i < staticStringsHash.buckets.length; ++i) {
                    indentingWriter.plnI("case " + staticStringsHash.keys[i] + ": ");
                    for (int j = 0; j < staticStringsHash.buckets[i].length; ++j) {
                        CompoundType.Method method = methodArray[staticStringsHash.buckets[i][j]];
                        if (j > 0) {
                            indentingWriter.pO("} else ");
                        }
                        indentingWriter.plnI("if (" + string4 + ".equals(\"" + method.getIDLName() + "\")) {");
                        this.writeTieMethod(indentingWriter, compoundType, method);
                    }
                    indentingWriter.pOln("}");
                    indentingWriter.pO();
                }
            } else {
                for (int i = 0; i < methodArray.length; ++i) {
                    CompoundType.Method method = methodArray[i];
                    if (i > 0) {
                        indentingWriter.pO("} else ");
                    }
                    indentingWriter.plnI("if (" + string4 + ".equals(\"" + method.getIDLName() + "\")) {");
                    this.writeTieMethod(indentingWriter, compoundType, method);
                }
            }
            if (staticStringsHash != null) {
                indentingWriter.pI();
            }
            if (staticStringsHash != null) {
                indentingWriter.pO();
            }
            indentingWriter.pOln("}");
            indentingWriter.pln("throw new " + this.getName(idBadMethodException) + "();");
            indentingWriter.pOlnI("} catch (" + this.getName(idSystemException) + " " + string3 + ") {");
            indentingWriter.pln("throw " + string3 + ";");
            indentingWriter.pOlnI("} catch (" + this.getName(idJavaLangThrowable) + " " + string3 + ") {");
            indentingWriter.pln("throw new " + this.getName(idPortableUnknownException) + "(" + string3 + ");");
            indentingWriter.pOln("}");
        } else {
            indentingWriter.pln("throw new " + this.getName(idBadMethodException) + "();");
        }
        indentingWriter.pOln("}");
        this.writeCastArray(indentingWriter);
        indentingWriter.pOln("}");
    }

    public void catchWrongPolicy(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.pln("");
    }

    public void catchServantNotActive(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.pln("");
    }

    public void catchObjectNotActive(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.pln("");
    }

    public void write_tie_thisObject_method(IndentingWriter indentingWriter, Identifier identifier) throws IOException {
        if (this.POATie) {
            indentingWriter.plnI("public " + identifier + " thisObject() {");
            indentingWriter.pln("return _this_object();");
            indentingWriter.pOln("}");
        } else {
            indentingWriter.plnI("public " + identifier + " thisObject() {");
            indentingWriter.pln("return this;");
            indentingWriter.pOln("}");
        }
    }

    public void write_tie_deactivate_method(IndentingWriter indentingWriter) throws IOException {
        if (this.POATie) {
            indentingWriter.plnI("public void deactivate() {");
            indentingWriter.pln("try{");
            indentingWriter.pln("_poa().deactivate_object(_poa().servant_to_id(this));");
            indentingWriter.pln("}catch (org.omg.PortableServer.POAPackage.WrongPolicy exception){");
            this.catchWrongPolicy(indentingWriter);
            indentingWriter.pln("}catch (org.omg.PortableServer.POAPackage.ObjectNotActive exception){");
            this.catchObjectNotActive(indentingWriter);
            indentingWriter.pln("}catch (org.omg.PortableServer.POAPackage.ServantNotActive exception){");
            this.catchServantNotActive(indentingWriter);
            indentingWriter.pln("}");
            indentingWriter.pOln("}");
        } else {
            indentingWriter.plnI("public void deactivate() {");
            indentingWriter.pln("_orb().disconnect(this);");
            indentingWriter.pln("_set_delegate(null);");
            indentingWriter.pln("target = null;");
            indentingWriter.pOln("}");
        }
    }

    public void write_tie_orb_method(IndentingWriter indentingWriter) throws IOException {
        if (this.POATie) {
            indentingWriter.plnI("public void orb(ORB orb) {");
            indentingWriter.pln("try {");
            indentingWriter.pln("    ((org.omg.CORBA_2_3.ORB)orb).set_delegate(this);");
            indentingWriter.pln("}");
            indentingWriter.pln("catch(ClassCastException e) {");
            indentingWriter.pln("    throw new org.omg.CORBA.BAD_PARAM");
            indentingWriter.pln("        (\"POA Servant requires an instance of org.omg.CORBA_2_3.ORB\");");
            indentingWriter.pln("}");
            indentingWriter.pOln("}");
        } else {
            indentingWriter.plnI("public void orb(ORB orb) {");
            indentingWriter.pln("orb.connect(this);");
            indentingWriter.pOln("}");
        }
    }

    public void write_tie__ids_method(IndentingWriter indentingWriter) throws IOException {
        if (this.POATie) {
            indentingWriter.plnI("public String[] _all_interfaces(org.omg.PortableServer.POA poa, byte[] objectId){");
            indentingWriter.pln("return (String[]) _type_ids.clone();");
            indentingWriter.pOln("}");
        } else {
            indentingWriter.plnI("public String[] _ids() { ");
            indentingWriter.pln("return (String[]) _type_ids.clone();");
            indentingWriter.pOln("}");
        }
    }

    StaticStringsHash getStringsHash(CompoundType.Method[] methodArray) {
        if (this.useHash && methodArray.length > 1) {
            String[] stringArray = new String[methodArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = methodArray[i].getIDLName();
            }
            return new StaticStringsHash(stringArray);
        }
        return null;
    }

    static boolean needNewReadStreamClass(Type type) {
        if (type.isType(8192)) {
            return true;
        }
        if (type instanceof CompoundType && ((CompoundType)type).isAbstractBase()) {
            return true;
        }
        return StubGenerator.needNewWriteStreamClass(type);
    }

    static boolean needNewWriteStreamClass(Type type) {
        switch (type.getTypeCode()) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 32: 
            case 64: 
            case 128: 
            case 256: {
                return false;
            }
            case 512: {
                return true;
            }
            case 1024: {
                return false;
            }
            case 2048: {
                return false;
            }
            case 4096: {
                return false;
            }
            case 8192: {
                return false;
            }
            case 16384: {
                return true;
            }
            case 32768: {
                return true;
            }
            case 65536: {
                return true;
            }
            case 131072: {
                return true;
            }
            case 262144: {
                return true;
            }
            case 524288: {
                return false;
            }
        }
        throw new Error("unexpected type code: " + type.getTypeCode());
    }

    String[] writeCopyArguments(CompoundType.Method method, IndentingWriter indentingWriter) throws IOException {
        int n;
        int n2;
        Type[] typeArray = method.getArguments();
        String[] stringArray = method.getArgumentNames();
        String[] stringArray2 = new String[stringArray.length];
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            stringArray2[n2] = stringArray[n2];
        }
        n2 = 0;
        boolean[] blArray = new boolean[typeArray.length];
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < typeArray.length; ++n) {
            if (StubGenerator.mustCopy(typeArray[n])) {
                blArray[n] = true;
                ++n3;
                n4 = n;
                if (typeArray[n].getTypeCode() == 4096 || typeArray[n].getTypeCode() == 65536) continue;
                n2 = 1;
                continue;
            }
            blArray[n] = false;
        }
        if (n3 > 0) {
            if (n2 != 0) {
                for (n = 0; n < typeArray.length; ++n) {
                    if (typeArray[n].getTypeCode() != 512) continue;
                    blArray[n] = true;
                    ++n3;
                }
            }
            if (n3 > 1) {
                int n5;
                String string = this.getVariableName("copies");
                indentingWriter.p("Object[] " + string + " = Util.copyObjects(new Object[]{");
                boolean bl = true;
                for (n5 = 0; n5 < typeArray.length; ++n5) {
                    if (!blArray[n5]) continue;
                    if (!bl) {
                        indentingWriter.p(",");
                    }
                    bl = false;
                    indentingWriter.p(stringArray[n5]);
                }
                indentingWriter.pln("},_orb());");
                n5 = 0;
                for (int i = 0; i < typeArray.length; ++i) {
                    if (!blArray[i]) continue;
                    stringArray2[i] = this.getVariableName(stringArray2[i] + "Copy");
                    indentingWriter.pln(this.getName(typeArray[i]) + " " + stringArray2[i] + " = (" + this.getName(typeArray[i]) + ") " + string + "[" + n5++ + "];");
                }
            } else {
                stringArray2[n4] = this.getVariableName(stringArray2[n4] + "Copy");
                indentingWriter.pln(this.getName(typeArray[n4]) + " " + stringArray2[n4] + " = (" + this.getName(typeArray[n4]) + ") Util.copyObject(" + stringArray[n4] + ",_orb());");
            }
        }
        return stringArray2;
    }

    String getRepositoryID(Type type) {
        return IDLNames.replace(type.getRepositoryID(), SINGLE_SLASH, DOUBLE_SLASH);
    }

    String getExceptionRepositoryID(Type type) {
        ClassType classType = (ClassType)type;
        return IDLNames.getIDLRepositoryID(classType.getQualifiedIDLExceptionName(false));
    }

    String getVariableName(String string) {
        while (this.namesInUse.contains(string)) {
            string = "$" + string;
        }
        return string;
    }

    void addNamesInUse(CompoundType.Method[] methodArray) {
        for (int i = 0; i < methodArray.length; ++i) {
            this.addNamesInUse(methodArray[i]);
        }
    }

    void addNamesInUse(CompoundType.Method method) {
        String[] stringArray = method.getArgumentNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.addNameInUse(stringArray[i]);
        }
    }

    void addNameInUse(String string) {
        this.namesInUse.add(string);
    }

    static boolean mustCopy(Type type) {
        switch (type.getTypeCode()) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 32: 
            case 64: 
            case 128: 
            case 256: 
            case 512: {
                return false;
            }
            case 1024: {
                return true;
            }
            case 2048: {
                return false;
            }
            case 4096: 
            case 8192: 
            case 16384: 
            case 32768: 
            case 65536: 
            case 131072: 
            case 262144: 
            case 524288: {
                return true;
            }
        }
        throw new Error("unexpected type code: " + type.getTypeCode());
    }

    ValueType[] getStubExceptions(CompoundType.Method method, boolean bl) {
        ValueType[] valueTypeArray = method.getFilteredStubExceptions(method.getExceptions());
        if (bl) {
            Arrays.sort(valueTypeArray, new UserExceptionComparator());
        }
        return valueTypeArray;
    }

    ValueType[] getTieExceptions(CompoundType.Method method) {
        return method.getUniqueCatchList(method.getImplExceptions());
    }

    void writeTieMethod(IndentingWriter indentingWriter, CompoundType compoundType, CompoundType.Method method) throws IOException {
        int n;
        boolean bl;
        int n2;
        String string = method.getName();
        Type[] typeArray = method.getArguments();
        String[] stringArray = method.getArgumentNames();
        Type type = method.getReturnType();
        ValueType[] valueTypeArray = this.getTieExceptions(method);
        String string2 = this.getVariableName("in");
        String string3 = this.getVariableName("ex");
        String string4 = this.getVariableName("out");
        String string5 = this.getVariableName("reply");
        for (n2 = 0; n2 < typeArray.length; ++n2) {
            indentingWriter.p(this.getName(typeArray[n2]) + " " + stringArray[n2] + " = ");
            this.writeUnmarshalArgument(indentingWriter, string2, typeArray[n2], null);
            indentingWriter.pln();
        }
        n2 = valueTypeArray != null ? 1 : 0;
        boolean bl2 = bl = !type.isType(1);
        if (n2 != 0 && bl) {
            String string6 = this.testUtil(this.getName(type), type);
            indentingWriter.pln(string6 + " result;");
        }
        if (n2 != 0) {
            indentingWriter.plnI("try {");
        }
        if (bl) {
            if (n2 != 0) {
                indentingWriter.p("result = ");
            } else {
                indentingWriter.p(this.getName(type) + " result = ");
            }
        }
        indentingWriter.p("target." + string + "(");
        for (n = 0; n < stringArray.length; ++n) {
            if (n > 0) {
                indentingWriter.p(", ");
            }
            indentingWriter.p(stringArray[n]);
        }
        indentingWriter.pln(");");
        if (n2 != 0) {
            for (n = 0; n < valueTypeArray.length; ++n) {
                indentingWriter.pOlnI("} catch (" + this.getName(valueTypeArray[n]) + " " + string3 + ") {");
                if (valueTypeArray[n].isIDLEntityException() && !valueTypeArray[n].isCORBAUserException()) {
                    String string7 = IDLNames.replace(valueTypeArray[n].getQualifiedIDLName(false), "::", ".");
                    string7 = string7 + "Helper";
                    indentingWriter.pln(idOutputStream + " " + string4 + " = " + string5 + ".createExceptionReply();");
                    indentingWriter.pln(string7 + ".write(" + string4 + "," + string3 + ");");
                } else {
                    indentingWriter.pln("String id = \"" + this.getExceptionRepositoryID(valueTypeArray[n]) + "\";");
                    indentingWriter.plnI(idExtOutputStream + " " + string4 + " = ");
                    indentingWriter.pln("(" + idExtOutputStream + ") " + string5 + ".createExceptionReply();");
                    indentingWriter.pOln(string4 + ".write_string(id);");
                    indentingWriter.pln(string4 + ".write_value(" + string3 + "," + this.getName(valueTypeArray[n]) + ".class);");
                }
                indentingWriter.pln("return " + string4 + ";");
            }
            indentingWriter.pOln("}");
        }
        if (StubGenerator.needNewWriteStreamClass(type)) {
            indentingWriter.plnI(idExtOutputStream + " " + string4 + " = ");
            indentingWriter.pln("(" + idExtOutputStream + ") " + string5 + ".createReply();");
            indentingWriter.pO();
        } else {
            indentingWriter.pln("OutputStream " + string4 + " = " + string5 + ".createReply();");
        }
        if (bl) {
            this.writeMarshalArgument(indentingWriter, string4, type, "result");
            indentingWriter.pln();
        }
        indentingWriter.pln("return " + string4 + ";");
    }

    void writeMarshalArguments(IndentingWriter indentingWriter, String string, Type[] typeArray, String[] stringArray) throws IOException {
        if (typeArray.length != stringArray.length) {
            throw new Error("paramter type and name arrays different sizes");
        }
        for (int i = 0; i < typeArray.length; ++i) {
            this.writeMarshalArgument(indentingWriter, string, typeArray[i], stringArray[i]);
            if (i == typeArray.length - 1) continue;
            indentingWriter.pln();
        }
    }

    String testUtil(String string, Type type) {
        if (string.equals("Util")) {
            String string2 = type.getPackageName() + "." + string;
            return string2;
        }
        return string;
    }
}

