/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sun.rmi.rmic.BatchEnvironment;
import sun.rmi.rmic.Names;
import sun.rmi.rmic.RMIConstants;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Identifier;
import sun.tools.java.MemberDefinition;
import sun.tools.java.Type;

public class RemoteClass
implements RMIConstants {
    private BatchEnvironment env;
    private ClassDefinition implClassDef;
    private ClassDefinition[] remoteInterfaces;
    private Method[] remoteMethods;
    private long interfaceHash;
    private ClassDefinition defRemote;
    private ClassDefinition defException;
    private ClassDefinition defRemoteException;

    public static RemoteClass forClass(BatchEnvironment batchEnvironment, ClassDefinition classDefinition) {
        RemoteClass remoteClass = new RemoteClass(batchEnvironment, classDefinition);
        if (remoteClass.initialize()) {
            return remoteClass;
        }
        return null;
    }

    public ClassDefinition getClassDefinition() {
        return this.implClassDef;
    }

    public Identifier getName() {
        return this.implClassDef.getName();
    }

    public ClassDefinition[] getRemoteInterfaces() {
        return (ClassDefinition[])this.remoteInterfaces.clone();
    }

    public Method[] getRemoteMethods() {
        return (Method[])this.remoteMethods.clone();
    }

    public long getInterfaceHash() {
        return this.interfaceHash;
    }

    public String toString() {
        return "remote class " + this.implClassDef.getName().toString();
    }

    private RemoteClass(BatchEnvironment batchEnvironment, ClassDefinition classDefinition) {
        this.env = batchEnvironment;
        this.implClassDef = classDefinition;
    }

    private boolean initialize() {
        ClassDeclaration[] classDeclarationArray;
        ClassDefinition classDefinition;
        if (this.implClassDef.isInterface()) {
            this.env.error(0L, "rmic.cant.make.stubs.for.interface", this.implClassDef.getName());
            return false;
        }
        try {
            this.defRemote = this.env.getClassDeclaration(idRemote).getClassDefinition(this.env);
            this.defException = this.env.getClassDeclaration(idJavaLangException).getClassDefinition(this.env);
            this.defRemoteException = this.env.getClassDeclaration(idRemoteException).getClassDefinition(this.env);
        }
        catch (ClassNotFound classNotFound) {
            this.env.error(0L, "rmic.class.not.found", classNotFound.name);
            return false;
        }
        Vector<ClassDefinition> vector = new Vector<ClassDefinition>();
        Object object = this.implClassDef;
        while (object != null) {
            try {
                ClassDeclaration[] classDeclarationArray2 = ((ClassDefinition)object).getInterfaces();
                for (int i = 0; i < classDeclarationArray2.length; ++i) {
                    classDefinition = classDeclarationArray2[i].getClassDefinition(this.env);
                    if (vector.contains(classDefinition) || !this.defRemote.implementedBy(this.env, classDeclarationArray2[i])) continue;
                    vector.addElement(classDefinition);
                    if (!this.env.verbose()) continue;
                    System.out.println("[found remote interface: " + classDefinition.getName() + "]");
                }
                if (object == this.implClassDef && vector.isEmpty()) {
                    if (this.defRemote.implementedBy(this.env, this.implClassDef.getClassDeclaration())) {
                        this.env.error(0L, "rmic.must.implement.remote.directly", this.implClassDef.getName());
                    } else {
                        this.env.error(0L, "rmic.must.implement.remote", this.implClassDef.getName());
                    }
                    return false;
                }
                object = ((ClassDefinition)object).getSuperClass() != null ? ((ClassDefinition)object).getSuperClass().getClassDefinition(this.env) : null;
            }
            catch (ClassNotFound classNotFound) {
                this.env.error(0L, "class.not.found", classNotFound.name, ((ClassDefinition)object).getName());
                return false;
            }
        }
        object = new Hashtable();
        boolean bl = false;
        String[] stringArray = vector.elements();
        while (stringArray.hasMoreElements()) {
            classDefinition = (ClassDefinition)stringArray.nextElement();
            if (this.collectRemoteMethods(classDefinition, (Hashtable<String, Method>)object)) continue;
            bl = true;
        }
        if (bl) {
            return false;
        }
        this.remoteInterfaces = new ClassDefinition[vector.size()];
        vector.copyInto(this.remoteInterfaces);
        stringArray = new String[((Hashtable)object).size()];
        int n = 0;
        Enumeration enumeration = ((Hashtable)object).elements();
        while (enumeration.hasMoreElements()) {
            classDeclarationArray = (ClassDeclaration[])enumeration.nextElement();
            String string = classDeclarationArray.getNameAndDescriptor();
            for (int i = n; i > 0 && string.compareTo(stringArray[i - 1]) < 0; --i) {
                stringArray[i] = stringArray[i - 1];
            }
            stringArray[i] = string;
            ++n;
        }
        this.remoteMethods = new Method[((Hashtable)object).size()];
        for (int i = 0; i < this.remoteMethods.length; ++i) {
            this.remoteMethods[i] = (Method)((Hashtable)object).get(stringArray[i]);
            if (!this.env.verbose()) continue;
            System.out.print("[found remote method <" + i + ">: " + this.remoteMethods[i].getOperationString());
            classDeclarationArray = this.remoteMethods[i].getExceptions();
            if (classDeclarationArray.length > 0) {
                System.out.print(" throws ");
            }
            for (int j = 0; j < classDeclarationArray.length; ++j) {
                if (j > 0) {
                    System.out.print(", ");
                }
                System.out.print(classDeclarationArray[j].getName());
            }
            System.out.println("]");
        }
        this.interfaceHash = this.computeInterfaceHash();
        return true;
    }

    private boolean collectRemoteMethods(ClassDefinition classDefinition, Hashtable<String, Method> hashtable) {
        Object object;
        if (!classDefinition.isInterface()) {
            throw new Error("expected interface, not class: " + classDefinition.getName());
        }
        boolean bl = false;
        block6: for (object = classDefinition.getFirstMember(); object != null; object = ((MemberDefinition)object).getNextMember()) {
            String string;
            Method method;
            Object object2;
            block13: {
                if (!((MemberDefinition)object).isMethod() || ((MemberDefinition)object).isConstructor() || ((MemberDefinition)object).isInitializer()) continue;
                ClassDeclaration[] classDeclarationArray = ((MemberDefinition)object).getExceptions(this.env);
                boolean bl2 = false;
                for (int i = 0; i < classDeclarationArray.length; ++i) {
                    try {
                        if (!this.defRemoteException.subClassOf(this.env, classDeclarationArray[i])) continue;
                        bl2 = true;
                        break;
                    }
                    catch (ClassNotFound classNotFound) {
                        this.env.error(0L, "class.not.found", classNotFound.name, classDefinition.getName());
                        continue block6;
                    }
                }
                if (!bl2) {
                    this.env.error(0L, "rmic.must.throw.remoteexception", classDefinition.getName(), ((MemberDefinition)object).toString());
                    bl = true;
                    continue;
                }
                try {
                    object2 = this.implClassDef.findMethod(this.env, ((MemberDefinition)object).getName(), ((MemberDefinition)object).getType());
                    if (object2 == null) break block13;
                    classDeclarationArray = ((MemberDefinition)object2).getExceptions(this.env);
                    for (int i = 0; i < classDeclarationArray.length; ++i) {
                        if (this.defException.superClassOf(this.env, classDeclarationArray[i])) continue;
                        this.env.error(0L, "rmic.must.only.throw.exception", ((MemberDefinition)object2).toString(), classDeclarationArray[i].getName());
                        bl = true;
                        continue block6;
                    }
                }
                catch (ClassNotFound classNotFound) {
                    this.env.error(0L, "class.not.found", classNotFound.name, this.implClassDef.getName());
                    continue;
                }
            }
            if ((method = hashtable.get(string = ((Method)(object2 = new Method((MemberDefinition)object))).getNameAndDescriptor())) != null && (object2 = ((Method)object2).mergeWith(method)) == null) {
                bl = true;
                continue;
            }
            hashtable.put(string, (Method)object2);
        }
        try {
            object = classDefinition.getInterfaces();
            for (int i = 0; i < ((Object)object).length; ++i) {
                ClassDefinition classDefinition2 = ((ClassDeclaration)object[i]).getClassDefinition(this.env);
                if (this.collectRemoteMethods(classDefinition2, hashtable)) continue;
                bl = true;
            }
        }
        catch (ClassNotFound classNotFound) {
            this.env.error(0L, "class.not.found", classNotFound.name, classDefinition.getName());
            return false;
        }
        return !bl;
    }

    private long computeInterfaceHash() {
        long l = 0L;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DataOutputStream dataOutputStream = new DataOutputStream(new DigestOutputStream(byteArrayOutputStream, messageDigest));
            dataOutputStream.writeInt(1);
            for (int i = 0; i < this.remoteMethods.length; ++i) {
                MemberDefinition memberDefinition = this.remoteMethods[i].getMemberDefinition();
                Identifier identifier = memberDefinition.getName();
                Type type = memberDefinition.getType();
                dataOutputStream.writeUTF(identifier.toString());
                dataOutputStream.writeUTF(type.getTypeSignature());
                ClassDeclaration[] classDeclarationArray = memberDefinition.getExceptions(this.env);
                this.sortClassDeclarations(classDeclarationArray);
                for (int j = 0; j < classDeclarationArray.length; ++j) {
                    dataOutputStream.writeUTF(Names.mangleClass(classDeclarationArray[j].getName()).toString());
                }
            }
            dataOutputStream.flush();
            byte[] byArray = messageDigest.digest();
            for (int i = 0; i < Math.min(8, byArray.length); ++i) {
                l += (long)(byArray[i] & 0xFF) << i * 8;
            }
        }
        catch (IOException iOException) {
            throw new Error("unexpected exception computing intetrface hash: " + iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Error("unexpected exception computing intetrface hash: " + noSuchAlgorithmException);
        }
        return l;
    }

    private void sortClassDeclarations(ClassDeclaration[] classDeclarationArray) {
        for (int i = 1; i < classDeclarationArray.length; ++i) {
            ClassDeclaration classDeclaration = classDeclarationArray[i];
            String string = Names.mangleClass(classDeclaration.getName()).toString();
            for (int j = i; j > 0 && string.compareTo(Names.mangleClass(classDeclarationArray[j - 1].getName()).toString()) < 0; --j) {
                classDeclarationArray[j] = classDeclarationArray[j - 1];
            }
            classDeclarationArray[j] = classDeclaration;
        }
    }

    public class Method
    implements Cloneable {
        private MemberDefinition memberDef;
        private long methodHash;
        private ClassDeclaration[] exceptions;

        public MemberDefinition getMemberDefinition() {
            return this.memberDef;
        }

        public Identifier getName() {
            return this.memberDef.getName();
        }

        public Type getType() {
            return this.memberDef.getType();
        }

        public ClassDeclaration[] getExceptions() {
            return (ClassDeclaration[])this.exceptions.clone();
        }

        public long getMethodHash() {
            return this.methodHash;
        }

        public String toString() {
            return this.memberDef.toString();
        }

        public String getOperationString() {
            return this.memberDef.toString();
        }

        public String getNameAndDescriptor() {
            return this.memberDef.getName().toString() + this.memberDef.getType().getTypeSignature();
        }

        Method(MemberDefinition memberDefinition) {
            this.memberDef = memberDefinition;
            this.exceptions = memberDefinition.getExceptions(RemoteClass.this.env);
            this.methodHash = this.computeMethodHash();
        }

        protected Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new Error("clone failed");
            }
        }

        private Method mergeWith(Method method) {
            if (!this.getName().equals(method.getName()) || !this.getType().equals(method.getType())) {
                throw new Error("attempt to merge method \"" + method.getNameAndDescriptor() + "\" with \"" + this.getNameAndDescriptor());
            }
            Vector<ClassDeclaration> vector = new Vector<ClassDeclaration>();
            try {
                this.collectCompatibleExceptions(method.exceptions, this.exceptions, vector);
                this.collectCompatibleExceptions(this.exceptions, method.exceptions, vector);
            }
            catch (ClassNotFound classNotFound) {
                RemoteClass.this.env.error(0L, "class.not.found", classNotFound.name, RemoteClass.this.getClassDefinition().getName());
                return null;
            }
            Method method2 = (Method)this.clone();
            method2.exceptions = new ClassDeclaration[vector.size()];
            vector.copyInto(method2.exceptions);
            return method2;
        }

        private void collectCompatibleExceptions(ClassDeclaration[] classDeclarationArray, ClassDeclaration[] classDeclarationArray2, Vector<ClassDeclaration> vector) throws ClassNotFound {
            block0: for (int i = 0; i < classDeclarationArray.length; ++i) {
                ClassDefinition classDefinition = classDeclarationArray[i].getClassDefinition(RemoteClass.this.env);
                if (vector.contains(classDeclarationArray[i])) continue;
                for (int j = 0; j < classDeclarationArray2.length; ++j) {
                    if (!classDefinition.subClassOf(RemoteClass.this.env, classDeclarationArray2[j])) continue;
                    vector.addElement(classDeclarationArray[i]);
                    continue block0;
                }
            }
        }

        private long computeMethodHash() {
            long l = 0L;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA");
                DataOutputStream dataOutputStream = new DataOutputStream(new DigestOutputStream(byteArrayOutputStream, messageDigest));
                String string = this.getNameAndDescriptor();
                if (RemoteClass.this.env.verbose()) {
                    System.out.println("[string used for method hash: \"" + string + "\"]");
                }
                dataOutputStream.writeUTF(string);
                dataOutputStream.flush();
                byte[] byArray = messageDigest.digest();
                for (int i = 0; i < Math.min(8, byArray.length); ++i) {
                    l += (long)(byArray[i] & 0xFF) << i * 8;
                }
            }
            catch (IOException iOException) {
                throw new Error("unexpected exception computing intetrface hash: " + iOException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new Error("unexpected exception computing intetrface hash: " + noSuchAlgorithmException);
            }
            return l;
        }
    }
}

