/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.builders;

import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import com.sun.tools.doclets.internal.toolkit.AnnotationTypeWriter;
import com.sun.tools.doclets.internal.toolkit.ClassWriter;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.MemberSummaryWriter;
import com.sun.tools.doclets.internal.toolkit.builders.AbstractMemberBuilder;
import com.sun.tools.doclets.internal.toolkit.builders.XMLNode;
import com.sun.tools.doclets.internal.toolkit.util.DocFinder;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import com.sun.tools.doclets.internal.toolkit.util.VisibleMemberMap;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class MemberSummaryBuilder
extends AbstractMemberBuilder {
    public static final String NAME = "MemberSummary";
    private VisibleMemberMap[] visibleMemberMaps;
    private MemberSummaryWriter[] memberSummaryWriters;
    private ClassDoc classDoc;

    private MemberSummaryBuilder(Configuration configuration) {
        super(configuration);
    }

    public static MemberSummaryBuilder getInstance(ClassWriter classWriter, Configuration configuration) throws Exception {
        MemberSummaryBuilder memberSummaryBuilder = new MemberSummaryBuilder(configuration);
        memberSummaryBuilder.classDoc = classWriter.getClassDoc();
        memberSummaryBuilder.init(classWriter);
        return memberSummaryBuilder;
    }

    public static MemberSummaryBuilder getInstance(AnnotationTypeWriter annotationTypeWriter, Configuration configuration) throws Exception {
        MemberSummaryBuilder memberSummaryBuilder = new MemberSummaryBuilder(configuration);
        memberSummaryBuilder.classDoc = annotationTypeWriter.getAnnotationTypeDoc();
        memberSummaryBuilder.init(annotationTypeWriter);
        return memberSummaryBuilder;
    }

    private void init(Object object) throws Exception {
        int n;
        this.visibleMemberMaps = new VisibleMemberMap[8];
        for (n = 0; n < 8; ++n) {
            this.visibleMemberMaps[n] = new VisibleMemberMap(this.classDoc, n, this.configuration.nodeprecated);
        }
        this.memberSummaryWriters = new MemberSummaryWriter[8];
        for (n = 0; n < 8; ++n) {
            this.memberSummaryWriters[n] = this.classDoc.isAnnotationType() ? (this.visibleMemberMaps[n].noVisibleMembers() ? null : this.configuration.getWriterFactory().getMemberSummaryWriter((AnnotationTypeWriter)object, n)) : (this.visibleMemberMaps[n].noVisibleMembers() ? null : this.configuration.getWriterFactory().getMemberSummaryWriter((ClassWriter)object, n));
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    public VisibleMemberMap getVisibleMemberMap(int n) {
        return this.visibleMemberMaps[n];
    }

    public MemberSummaryWriter getMemberSummaryWriter(int n) {
        return this.memberSummaryWriters[n];
    }

    public List<ProgramElementDoc> members(int n) {
        return this.visibleMemberMaps[n].getLeafClassMembers(this.configuration);
    }

    @Override
    public boolean hasMembersToDocument() {
        if (this.classDoc instanceof AnnotationTypeDoc) {
            return ((AnnotationTypeDoc)this.classDoc).elements().length > 0;
        }
        for (int i = 0; i < 8; ++i) {
            VisibleMemberMap visibleMemberMap = this.visibleMemberMaps[i];
            if (visibleMemberMap.noVisibleMembers()) continue;
            return true;
        }
        return false;
    }

    public void buildEnumConstantsSummary(XMLNode xMLNode, Content content) {
        MemberSummaryWriter memberSummaryWriter = this.memberSummaryWriters[1];
        VisibleMemberMap visibleMemberMap = this.visibleMemberMaps[1];
        this.addSummary(memberSummaryWriter, visibleMemberMap, false, content);
    }

    public void buildAnnotationTypeOptionalMemberSummary(XMLNode xMLNode, Content content) {
        MemberSummaryWriter memberSummaryWriter = this.memberSummaryWriters[5];
        VisibleMemberMap visibleMemberMap = this.visibleMemberMaps[5];
        this.addSummary(memberSummaryWriter, visibleMemberMap, false, content);
    }

    public void buildAnnotationTypeRequiredMemberSummary(XMLNode xMLNode, Content content) {
        MemberSummaryWriter memberSummaryWriter = this.memberSummaryWriters[6];
        VisibleMemberMap visibleMemberMap = this.visibleMemberMaps[6];
        this.addSummary(memberSummaryWriter, visibleMemberMap, false, content);
    }

    public void buildFieldsSummary(XMLNode xMLNode, Content content) {
        MemberSummaryWriter memberSummaryWriter = this.memberSummaryWriters[2];
        VisibleMemberMap visibleMemberMap = this.visibleMemberMaps[2];
        this.addSummary(memberSummaryWriter, visibleMemberMap, true, content);
    }

    public void buildPropertiesSummary(XMLNode xMLNode, Content content) {
        MemberSummaryWriter memberSummaryWriter = this.memberSummaryWriters[7];
        VisibleMemberMap visibleMemberMap = this.visibleMemberMaps[7];
        this.addSummary(memberSummaryWriter, visibleMemberMap, true, content);
    }

    public void buildNestedClassesSummary(XMLNode xMLNode, Content content) {
        MemberSummaryWriter memberSummaryWriter = this.memberSummaryWriters[0];
        VisibleMemberMap visibleMemberMap = this.visibleMemberMaps[0];
        this.addSummary(memberSummaryWriter, visibleMemberMap, true, content);
    }

    public void buildMethodsSummary(XMLNode xMLNode, Content content) {
        MemberSummaryWriter memberSummaryWriter = this.memberSummaryWriters[4];
        VisibleMemberMap visibleMemberMap = this.visibleMemberMaps[4];
        this.addSummary(memberSummaryWriter, visibleMemberMap, true, content);
    }

    public void buildConstructorsSummary(XMLNode xMLNode, Content content) {
        MemberSummaryWriter memberSummaryWriter = this.memberSummaryWriters[3];
        VisibleMemberMap visibleMemberMap = this.visibleMemberMaps[3];
        this.addSummary(memberSummaryWriter, visibleMemberMap, false, content);
    }

    private void buildSummary(MemberSummaryWriter memberSummaryWriter, VisibleMemberMap visibleMemberMap, LinkedList<Content> linkedList) {
        ArrayList<ProgramElementDoc> arrayList = new ArrayList<ProgramElementDoc>(visibleMemberMap.getLeafClassMembers(this.configuration));
        if (arrayList.size() > 0) {
            Collections.sort(arrayList);
            Content content = memberSummaryWriter.getSummaryTableTree(this.classDoc);
            for (int i = 0; i < arrayList.size(); ++i) {
                ProgramElementDoc programElementDoc = (ProgramElementDoc)arrayList.get(i);
                ProgramElementDoc programElementDoc2 = visibleMemberMap.getPropertyMemberDoc(programElementDoc);
                if (programElementDoc2 != null) {
                    this.processProperty(visibleMemberMap, programElementDoc, programElementDoc2);
                }
                Tag[] tagArray = programElementDoc.firstSentenceTags();
                if (programElementDoc instanceof MethodDoc && tagArray.length == 0) {
                    DocFinder.Output output = DocFinder.search(new DocFinder.Input((MethodDoc)programElementDoc));
                    if (output.holder != null && output.holder.firstSentenceTags().length > 0) {
                        tagArray = output.holder.firstSentenceTags();
                    }
                }
                memberSummaryWriter.addMemberSummary(this.classDoc, programElementDoc, tagArray, content, i);
            }
            linkedList.add(content);
        }
    }

    private void processProperty(VisibleMemberMap visibleMemberMap, ProgramElementDoc programElementDoc, ProgramElementDoc programElementDoc2) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = this.isSetter(programElementDoc);
        boolean bl2 = this.isGetter(programElementDoc);
        if (bl2 || bl) {
            if (bl) {
                stringBuilder.append(MessageFormat.format(Util.RESOURCE_BUNDLE.getString("doclet.PropertySetterWithName"), Util.propertyNameFromMethodName(programElementDoc.name())));
            }
            if (bl2) {
                stringBuilder.append(MessageFormat.format(Util.RESOURCE_BUNDLE.getString("doclet.PropertyGetterWithName"), Util.propertyNameFromMethodName(programElementDoc.name())));
            }
            if (programElementDoc2.commentText() != null && !programElementDoc2.commentText().isEmpty()) {
                stringBuilder.append(" \n @propertyDescription ");
            }
        }
        stringBuilder.append(programElementDoc2.commentText());
        Tag[] tagArray = programElementDoc2.tags("@defaultValue");
        if (tagArray != null) {
            for (Tag tag : tagArray) {
                stringBuilder.append("\n").append(tag.name()).append(" ").append(tag.text());
            }
        }
        if (!bl2 && !bl) {
            MethodDoc methodDoc = (MethodDoc)visibleMemberMap.getGetterForProperty(programElementDoc);
            MethodDoc methodDoc2 = (MethodDoc)visibleMemberMap.getSetterForProperty(programElementDoc);
            if (null != methodDoc && stringBuilder.indexOf("@see #" + methodDoc.name()) == -1) {
                stringBuilder.append("\n @see #").append(methodDoc.name()).append("() ");
            }
            if (null != methodDoc2 && stringBuilder.indexOf("@see #" + methodDoc2.name()) == -1) {
                String string = methodDoc2.parameters()[0].typeName();
                if ((string = string.split("<")[0]).contains(".")) {
                    string = string.substring(string.lastIndexOf(".") + 1);
                }
                stringBuilder.append("\n @see #").append(methodDoc2.name());
                if (methodDoc2.parameters()[0].type().asTypeVariable() == null) {
                    stringBuilder.append("(").append(string).append(")");
                }
                stringBuilder.append(" \n");
            }
        }
        programElementDoc.setRawCommentText(stringBuilder.toString());
    }

    private boolean isGetter(ProgramElementDoc programElementDoc) {
        String string = programElementDoc.name();
        return string.startsWith("get") || string.startsWith("is");
    }

    private boolean isSetter(ProgramElementDoc programElementDoc) {
        return programElementDoc.name().startsWith("set");
    }

    private void buildInheritedSummary(MemberSummaryWriter memberSummaryWriter, VisibleMemberMap visibleMemberMap, LinkedList<Content> linkedList) {
        for (ClassDoc classDoc : visibleMemberMap.getVisibleClassesList()) {
            List<ProgramElementDoc> list;
            if (!classDoc.isPublic() && !Util.isLinkable(classDoc, this.configuration) || classDoc == this.classDoc || (list = visibleMemberMap.getMembersFor(classDoc)).size() <= 0) continue;
            Collections.sort(list);
            Content content = memberSummaryWriter.getInheritedSummaryHeader(classDoc);
            Content content2 = memberSummaryWriter.getInheritedSummaryLinksTree();
            for (int i = 0; i < list.size(); ++i) {
                memberSummaryWriter.addInheritedMemberSummary(classDoc.isPackagePrivate() && !Util.isLinkable(classDoc, this.configuration) ? this.classDoc : classDoc, list.get(i), i == 0, i == list.size() - 1, content2);
            }
            content.addContent(content2);
            linkedList.add(memberSummaryWriter.getMemberTree(content));
        }
    }

    private void addSummary(MemberSummaryWriter memberSummaryWriter, VisibleMemberMap visibleMemberMap, boolean bl, Content content) {
        LinkedList<Content> linkedList = new LinkedList<Content>();
        this.buildSummary(memberSummaryWriter, visibleMemberMap, linkedList);
        if (bl) {
            this.buildInheritedSummary(memberSummaryWriter, visibleMemberMap, linkedList);
        }
        if (!linkedList.isEmpty()) {
            Content content2 = memberSummaryWriter.getMemberSummaryHeader(this.classDoc, content);
            for (int i = 0; i < linkedList.size(); ++i) {
                content2.addContent(linkedList.get(i));
            }
            content.addContent(memberSummaryWriter.getMemberTree(content2));
        }
    }
}

